/*
 * Decompiled with CFR 0.152.
 */
package org.klojang.path;

import java.util.Collection;
import java.util.Iterator;
import java.util.OptionalInt;
import org.klojang.convert.NumberMethods;
import org.klojang.path.KeyDeserializer;
import org.klojang.path.ObjectReader;
import org.klojang.path.Path;
import org.klojang.path.PathWalkerException;
import org.klojang.path.SegmentReader;

final class CollectionSegmentReader
extends SegmentReader<Collection> {
    CollectionSegmentReader(boolean suppressExceptions, KeyDeserializer keyDeserializer) {
        super(suppressExceptions, keyDeserializer);
    }

    @Override
    Object read(Collection collection, Path path, int segment) {
        OptionalInt opt = NumberMethods.toInt((String)path.segment(segment));
        if (opt.isEmpty()) {
            return this.deadEnd(PathWalkerException.indexExpected(path, segment));
        }
        int idx = opt.getAsInt();
        if (idx < collection.size()) {
            Iterator iter = collection.iterator();
            while (idx != 0 && iter.hasNext()) {
                --idx;
                iter.next();
            }
            if (iter.hasNext()) {
                return new ObjectReader(this.se, this.kd).read(iter.next(), path, ++segment);
            }
        }
        return this.deadEnd(PathWalkerException.indexOutOfBounds(path, segment));
    }
}

