/*
 * Decompiled with CFR 0.152.
 */
package org.klojang.path;

import java.util.List;
import java.util.OptionalInt;
import org.klojang.convert.NumberMethods;
import org.klojang.path.KeyDeserializer;
import org.klojang.path.Path;
import org.klojang.path.PathWalkerException;
import org.klojang.path.SegmentWriter;

final class ListSegmentWriter
extends SegmentWriter<List> {
    ListSegmentWriter(boolean suppressExceptions, KeyDeserializer keyDeserializer) {
        super(suppressExceptions, keyDeserializer);
    }

    @Override
    boolean write(List list, Path path, Object value) {
        int segment = path.size() - 1;
        OptionalInt opt = NumberMethods.toInt((String)path.segment(segment));
        if (opt.isEmpty()) {
            return this.deadEnd(PathWalkerException.indexExpected(path, segment));
        }
        int idx = opt.getAsInt();
        if (idx < list.size()) {
            try {
                list.set(opt.getAsInt(), value);
            }
            catch (UnsupportedOperationException e) {
                return this.deadEnd(PathWalkerException.notModifiable(path.parent(), segment, List.class));
            }
            return true;
        }
        return this.deadEnd(PathWalkerException.indexOutOfBounds(path, segment));
    }
}

