/*
 * Decompiled with CFR 0.152.
 */
package org.klojang.path;

import java.util.OptionalInt;
import org.klojang.convert.NumberMethods;
import org.klojang.path.KeyDeserializer;
import org.klojang.path.ObjectReader;
import org.klojang.path.Path;
import org.klojang.path.PathWalkerException;
import org.klojang.path.SegmentReader;
import org.klojang.util.InvokeMethods;

final class PrimitiveArraySegmentReader
extends SegmentReader<Object> {
    PrimitiveArraySegmentReader(boolean suppressExceptions, KeyDeserializer keyDeserializer) {
        super(suppressExceptions, keyDeserializer);
    }

    @Override
    Object read(Object array, Path path, int segment) {
        OptionalInt opt = NumberMethods.toInt((String)path.segment(segment));
        if (opt.isEmpty()) {
            return this.deadEnd(PathWalkerException.indexExpected(path, segment));
        }
        int idx = opt.getAsInt();
        int len = InvokeMethods.getArrayLength((Object)array);
        if (idx >= 0 && idx < len) {
            Object val = InvokeMethods.getArrayElement((Object)array, (int)idx);
            return new ObjectReader(this.se, this.kd).read(val, path, ++segment);
        }
        return this.deadEnd(PathWalkerException.indexOutOfBounds(path, segment));
    }
}

