/*
 * Decompiled with CFR 0.152.
 */
package org.klojang.invoke;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import org.klojang.check.Check;
import org.klojang.check.CommonChecks;
import org.klojang.invoke.Getter;
import org.klojang.invoke.NoPublicGettersException;
import org.klojang.util.ArrayMethods;
import org.klojang.util.ClassMethods;

public final class GetterFactory {
    public static final GetterFactory INSTANCE = new GetterFactory();
    private final Map<Class<?>, Map<String, Getter>> cache = new HashMap();
    private static final Set<String> NON_GETTERS = Set.of("getClass", "toString", "hashCode");

    private GetterFactory() {
    }

    public Map<String, Getter> getGetters(Class<?> clazz, boolean strict) {
        Map<String, Getter> getters = this.cache.get(clazz);
        if (getters == null) {
            List<Method> methods = GetterFactory.getMethods(clazz, strict);
            Check.that(methods).isNot((Predicate)CommonChecks.empty(), () -> new NoPublicGettersException(clazz));
            Map.Entry[] entries = new Map.Entry[methods.size()];
            int i = 0;
            for (Method m : methods) {
                String prop = GetterFactory.getPropertyNameFromGetter(m, strict);
                entries[i++] = Map.entry(prop, new Getter(m, prop));
            }
            getters = Map.ofEntries(entries);
            this.cache.put(clazz, getters);
        }
        return getters;
    }

    private static List<Method> getMethods(Class<?> clazz, boolean strict) {
        Method[] methods = clazz.getMethods();
        ArrayList<Method> getters = new ArrayList<Method>(methods.length - NON_GETTERS.size());
        for (Method m : methods) {
            if (Modifier.isStatic(m.getModifiers()) || m.getParameterCount() != 0 || m.getReturnType() == Void.TYPE || NON_GETTERS.contains(m.getName()) || strict && !clazz.isRecord() && !GetterFactory.validGetterName(m)) continue;
            getters.add(m);
        }
        return getters;
    }

    private static String getPropertyNameFromGetter(Method m, boolean strict) {
        if (m.getDeclaringClass().isRecord()) {
            return m.getName();
        }
        String n = m.getName();
        if ((m.getReturnType() == Boolean.TYPE || m.getReturnType() == Boolean.class) && n.length() > 2 && n.startsWith("is") && Character.isUpperCase(n.charAt(2))) {
            return GetterFactory.extractName(n, 2);
        }
        if (n.length() > 3 && n.startsWith("get") && Character.isUpperCase(n.charAt(3))) {
            return GetterFactory.extractName(n, 3);
        }
        if (!strict) {
            return n;
        }
        throw GetterFactory.notAProperty(m);
    }

    private static String extractName(String n, int from) {
        StringBuilder sb = new StringBuilder(n.length() - 3);
        sb.append(n.substring(from));
        sb.setCharAt(0, Character.toLowerCase(sb.charAt(0)));
        return sb.toString();
    }

    private static boolean validGetterName(Method m) {
        String n = m.getName();
        if (n.length() > 4 && n.startsWith("get") && Character.isUpperCase(n.charAt(3))) {
            return true;
        }
        if (n.length() > 3 && n.startsWith("is") && Character.isUpperCase(n.charAt(2))) {
            return m.getReturnType() == Boolean.TYPE || m.getReturnType() == Boolean.class;
        }
        return false;
    }

    private static IllegalArgumentException notAProperty(Method m) {
        String fmt = "method %s %s(%s) in class %s is not a getter";
        String rt = ClassMethods.simpleClassName(m.getReturnType());
        String clazz = ClassMethods.className(m.getDeclaringClass());
        String params = ArrayMethods.implode((Object[])m.getParameterTypes(), ClassMethods::simpleClassName);
        String msg = String.format(fmt, rt, m.getName(), params, clazz);
        return new IllegalArgumentException(msg);
    }
}

