/*
 * Decompiled with CFR 0.152.
 */
package org.klojang.invoke;

import org.klojang.util.ClassMethods;
import org.klojang.util.InvokeException;
import org.klojang.util.ObjectMethods;

public final class IllegalAssignmentException
extends InvokeException {
    private final Class<?> beanClass;
    private final String propertyName;
    private final Class<?> propertyType;
    private final Object value;

    IllegalAssignmentException(Class<?> beanClass, String propertyName, Class<?> propertyType, Object value) {
        super(IllegalAssignmentException.createMessage(beanClass, propertyName, propertyType, value));
        this.beanClass = beanClass;
        this.propertyName = propertyName;
        this.propertyType = propertyType;
        this.value = value;
    }

    private static String createMessage(Class<?> beanClass, String propertyName, Class<?> propertyType, Object value) {
        String valueType = (String)ObjectMethods.ifNotNull((Object)value, ClassMethods::simpleClassName, (Object)"null");
        return "illegal assignment for " + ClassMethods.simpleClassName(beanClass) + "." + propertyName + ": cannot assign " + valueType + " to " + ClassMethods.simpleClassName(propertyType);
    }

    public Class<?> getBeanClass() {
        return this.beanClass;
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public Class<?> getPropertyType() {
        return this.propertyType;
    }

    public Object getValue() {
        return this.value;
    }
}

