/*
 * Decompiled with CFR 0.152.
 */
package org.klojang.path;

import java.util.List;
import java.util.Map;
import org.klojang.path.ArraySegmentWriter;
import org.klojang.path.BeanSegmentWriter;
import org.klojang.path.KeyDeserializer;
import org.klojang.path.ListSegmentWriter;
import org.klojang.path.MapSegmentWriter;
import org.klojang.path.Path;
import org.klojang.path.PathWalker;
import org.klojang.path.PathWalkerException;
import org.klojang.path.PrimitiveArraySegmentWriter;
import org.klojang.util.ClassMethods;

final class ObjectWriter {
    private final boolean se;
    private final KeyDeserializer kd;

    ObjectWriter(boolean suppressExceptions, KeyDeserializer keyDeserializer) {
        this.se = suppressExceptions;
        this.kd = keyDeserializer;
    }

    boolean write(Object host, Path path, Object value) {
        int segment;
        Object writeTo;
        if (path.size() == 1) {
            writeTo = host;
            segment = 0;
        } else {
            Path parent = path.parent();
            PathWalker pw = new PathWalker(path.parent(), false, this.kd);
            try {
                writeTo = pw.read(host);
            }
            catch (PathWalkerException e) {
                if (this.se) {
                    return false;
                }
                throw e;
            }
            segment = parent.size() - 1;
        }
        if (writeTo == null) {
            return this.deadEnd(PathWalkerException.nullValue(path, segment));
        }
        if (writeTo instanceof List) {
            List l = (List)writeTo;
            return new ListSegmentWriter(this.se, this.kd).write(l, path, value);
        }
        if (writeTo instanceof Map) {
            Map m = (Map)writeTo;
            return new MapSegmentWriter(this.se, this.kd).write(m, path, value);
        }
        if (writeTo instanceof Object[]) {
            Object[] o = (Object[])writeTo;
            return new ArraySegmentWriter(this.se, this.kd).write(o, path, value);
        }
        if (ClassMethods.isPrimitiveArray((Object)writeTo)) {
            return new PrimitiveArraySegmentWriter(this.se, this.kd).write(writeTo, path, value);
        }
        return new BeanSegmentWriter(this.se, this.kd).write(writeTo, path, value);
    }

    boolean deadEnd(PathWalkerException.Factory excFactory) {
        if (this.se) {
            return false;
        }
        throw (PathWalkerException)excFactory.get();
    }
}

