/*
 * Decompiled with CFR 0.152.
 */
package org.klojang.path;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import org.klojang.check.Check;
import org.klojang.check.CommonChecks;
import org.klojang.check.CommonProperties;
import org.klojang.path.KeyDeserializer;
import org.klojang.path.ObjectReader;
import org.klojang.path.ObjectWriter;
import org.klojang.path.Path;
import org.klojang.path.PathWalkerException;

public final class PathWalker {
    private static final String PATHS = "paths";
    private final Path[] paths;
    private final boolean se;
    private final KeyDeserializer kd;

    public static <T> T read(Object host, String path) {
        return new PathWalker(path).read(host);
    }

    public static <T> T read(Object host, Path path) {
        return new PathWalker(path).read(host);
    }

    public PathWalker(Path ... paths) {
        Check.that((Object)paths, (String)PATHS).isNot((Predicate)CommonChecks.empty()).is((Predicate)CommonChecks.deepNotNull());
        this.paths = Arrays.copyOf(paths, paths.length);
        this.se = true;
        this.kd = null;
    }

    public PathWalker(String ... paths) {
        Check.that((Object)paths, (String)PATHS).isNot((Predicate)CommonChecks.empty()).is((Predicate)CommonChecks.deepNotNull());
        this.paths = (Path[])Arrays.stream(paths).map(Path::from).toArray(Path[]::new);
        this.se = true;
        this.kd = null;
    }

    public PathWalker(List<Path> paths) {
        this(paths, true);
    }

    public PathWalker(List<Path> paths, boolean suppressExceptions) {
        Check.that(paths, (String)PATHS).isNot((Predicate)CommonChecks.empty()).is((Predicate)CommonChecks.deepNotNull());
        this.paths = (Path[])paths.toArray(Path[]::new);
        this.se = suppressExceptions;
        this.kd = null;
    }

    public PathWalker(List<Path> paths, boolean suppressExceptions, KeyDeserializer keyDeserializer) {
        Check.that(paths, (String)PATHS).isNot((Predicate)CommonChecks.empty()).is((Predicate)CommonChecks.deepNotNull());
        Check.notNull((Object)keyDeserializer, (String)"keyDeserializer");
        this.paths = (Path[])paths.toArray(Path[]::new);
        this.se = suppressExceptions;
        this.kd = keyDeserializer;
    }

    PathWalker(Path path, boolean suppressExceptions, KeyDeserializer keyDeserializer) {
        this.paths = new Path[]{path};
        this.se = suppressExceptions;
        this.kd = keyDeserializer;
    }

    public Object[] readValues(Object host) throws PathWalkerException {
        ObjectReader reader = new ObjectReader(this.se, this.kd);
        return Arrays.stream(this.paths).map(path -> reader.read(host, (Path)path, 0)).toArray();
    }

    public void readValues(Object host, Object[] output) throws PathWalkerException {
        Check.notNull((Object)output, (String)"output").has(CommonProperties.length(), CommonChecks.gte(), this.paths.length);
        ObjectReader reader = new ObjectReader(this.se, this.kd);
        for (int i = 0; i < this.paths.length; ++i) {
            output[i] = reader.read(host, this.paths[i], 0);
        }
    }

    public void readValues(Object host, Map<Path, Object> output) throws PathWalkerException {
        Check.notNull(output, (String)"output");
        ObjectReader reader = new ObjectReader(this.se, this.kd);
        Arrays.stream(this.paths).forEach(p -> output.put((Path)p, reader.read(host, (Path)p, 0)));
    }

    public <T> T read(Object host) {
        return (T)new ObjectReader(this.se, this.kd).read(host, this.paths[0], 0);
    }

    public int writeValues(Object host, Object ... values) {
        Check.notNull((Object)values, (String)"values").has(CommonProperties.length(), CommonChecks.eq(), this.paths.length);
        ObjectWriter writer = new ObjectWriter(this.se, this.kd);
        int x = 0;
        for (int i = 0; i < this.paths.length; ++i) {
            if (!writer.write(host, this.paths[i], values[i])) continue;
            ++x;
        }
        return x;
    }

    public boolean write(Object host, Object value) {
        return new ObjectWriter(this.se, this.kd).write(host, this.paths[0], value);
    }
}

