/*
 * Decompiled with CFR 0.152.
 */
package org.klojang.invoke;

import java.util.Map;
import java.util.function.Predicate;
import org.klojang.check.Check;
import org.klojang.check.CommonChecks;
import org.klojang.invoke.Getter;
import org.klojang.invoke.GetterFactory;
import org.klojang.invoke.NoSuchPropertyException;
import org.klojang.invoke.Private;

public final class AnyBeanReader {
    private final boolean strict;

    public AnyBeanReader() {
        this(true);
    }

    public AnyBeanReader(boolean strictNaming) {
        this.strict = strictNaming;
    }

    public <U> U read(Object bean, String property) throws NoSuchPropertyException {
        Check.notNull((Object)bean, (String)"bean");
        Check.notNull((Object)property, (String)"property");
        return this.doRead(bean, property);
    }

    private <U> U doRead(Object bean, String prop) {
        Map<String, Getter> getters = GetterFactory.INSTANCE.getGetters(bean.getClass(), this.strict);
        Getter getter = getters.get(prop);
        Check.that((Object)getter).is((Predicate)CommonChecks.notNull(), () -> NoSuchPropertyException.noSuchProperty(bean, prop)).ok();
        try {
            return (U)getter.read(bean);
        }
        catch (Throwable exc) {
            throw Private.wrap(exc, bean, getter);
        }
    }
}

