/*
 * Decompiled with CFR 0.152.
 */
package org.klojang.invoke;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import org.klojang.check.Check;
import org.klojang.check.CommonChecks;
import org.klojang.invoke.BeanReader;
import org.klojang.invoke.BeanValueTransformer;
import org.klojang.invoke.IllegalAssignmentException;
import org.klojang.invoke.IncludeExclude;
import org.klojang.invoke.NoPublicSettersException;
import org.klojang.invoke.NoSuchPropertyException;
import org.klojang.invoke.Setter;
import org.klojang.invoke.SetterFactory;

public final class BeanWriter<T> {
    private final Class<T> beanClass;
    private final BeanValueTransformer<T> transformer;
    private final Map<String, Setter> setters;
    private BeanReader<T> beanReader;

    public BeanWriter(Class<T> beanClass, String ... properties) {
        this(beanClass, IncludeExclude.INCLUDE, properties);
    }

    public BeanWriter(Class<T> beanClass, BeanValueTransformer<T> transformer, String ... properties) {
        this(beanClass, transformer, IncludeExclude.INCLUDE, properties);
    }

    public BeanWriter(Class<T> beanClass, IncludeExclude includeExclude, String ... properties) {
        this.beanClass = (Class)Check.notNull(beanClass, (String)"beanClass").ok();
        this.transformer = null;
        Check.notNull((Object)((Object)includeExclude), (String)"includeExclude");
        Check.notNull((Object)properties, (String)"properties");
        this.setters = this.getSetters(includeExclude, properties);
    }

    public BeanWriter(Class<T> beanClass, BeanValueTransformer<T> transformer, IncludeExclude includeExclude, String ... properties) {
        this.beanClass = (Class)Check.notNull(beanClass, (String)"beanClass").ok();
        this.transformer = (BeanValueTransformer)Check.notNull(transformer, (String)"converter").ok();
        Check.notNull((Object)((Object)includeExclude), (String)"includeExclude");
        Check.notNull((Object)properties, (String)"properties");
        this.setters = this.getSetters(includeExclude, properties);
    }

    public void write(T bean, String property, Object value) throws Throwable {
        Check.notNull(bean, (String)"bean");
        Setter setter = (Setter)Check.notNull((Object)property, (String)"property").ok(this.setters::get);
        Check.that((Object)setter).is((Predicate)CommonChecks.notNull(), () -> NoSuchPropertyException.noSuchProperty(bean, property));
        this.set(bean, setter, value);
    }

    public void copy(T fromBean, T toBean) throws Throwable {
        Check.notNull(fromBean, (String)"source bean");
        Check.notNull(toBean, (String)"target bean");
        BeanReader<T> reader = this.getBeanReader();
        for (Setter setter : this.setters.values()) {
            this.set(toBean, setter, reader.read(fromBean, setter.getProperty()));
        }
    }

    public void copyNonNull(T fromBean, T toBean) throws Throwable {
        Check.notNull(fromBean, (String)"source bean");
        Check.notNull(toBean, (String)"target bean");
        BeanReader<T> reader = this.getBeanReader();
        for (Setter setter : this.setters.values()) {
            Object v = reader.read(fromBean, setter.getProperty());
            if (v == null) continue;
            this.set(toBean, setter, v);
        }
    }

    public void enrich(T fromBean, T toBean) throws Throwable {
        Check.notNull(fromBean, (String)"source bean");
        Check.notNull(toBean, (String)"target bean");
        BeanReader<T> reader = this.getBeanReader();
        for (Setter setter : this.setters.values()) {
            Object v = reader.read(fromBean, setter.getProperty());
            if (v == null || reader.read(toBean, setter.getProperty()) != null) continue;
            this.set(toBean, setter, v);
        }
    }

    public void copy(Map<String, ?> fromMap, T toBean) throws IllegalAssignmentException, Throwable {
        Check.notNull(fromMap, (String)"source map");
        Check.notNull(toBean, (String)"target bean");
        for (Map.Entry<String, ?> e : fromMap.entrySet()) {
            Setter setter;
            if (e.getKey() == null || (setter = this.setters.get(e.getKey())) == null) continue;
            this.set(toBean, setter, e.getValue());
        }
    }

    public void copyNonNull(Map<String, ?> fromMap, T toBean) throws Throwable {
        Check.notNull(fromMap, (String)"source map");
        Check.notNull(toBean, (String)"target bean");
        for (Map.Entry<String, ?> e : fromMap.entrySet()) {
            Setter setter;
            if (e.getValue() == null || e.getKey() == null || (setter = this.setters.get(e.getKey())) == null) continue;
            this.set(toBean, setter, e.getValue());
        }
    }

    public void enrich(Map<String, ?> fromMap, T toBean) throws IllegalAssignmentException, Throwable {
        Check.notNull(fromMap, (String)"source map");
        Check.notNull(toBean, (String)"target bean");
        BeanReader<T> reader = this.getBeanReader();
        for (Map.Entry<String, ?> e : fromMap.entrySet()) {
            Setter setter;
            if (e.getValue() == null || e.getKey() == null || (setter = this.setters.get(e.getKey())) == null || reader.read(toBean, e.getKey()) != null) continue;
            this.set(toBean, setter, e.getValue());
        }
    }

    public Class<T> getBeanClass() {
        return this.beanClass;
    }

    public boolean canWrite(String property) {
        return this.setters.containsKey(property);
    }

    public Set<String> getWritableProperties() {
        return this.setters.keySet();
    }

    public Map<String, Setter> getIncludedSetters() {
        return this.setters;
    }

    private Map<String, Setter> getSetters(IncludeExclude ie, String[] props) {
        LinkedHashMap<String, Setter> tmp;
        Map<String, Setter> m = SetterFactory.INSTANCE.getSetters(this.beanClass);
        if (props.length == 0) {
            return m;
        }
        if (ie.isExclude()) {
            Set<String> propSet = Set.of(props);
            tmp = LinkedHashMap.newLinkedHashMap(m.size() - props.length);
            m.forEach((x, y) -> {
                if (!propSet.contains(x)) {
                    tmp.put((String)x, (Setter)y);
                }
            });
        } else {
            tmp = LinkedHashMap.newLinkedHashMap(props.length);
            for (String prop : props) {
                if (!m.containsKey(prop)) continue;
                tmp.put(prop, m.get(prop));
            }
        }
        Check.that(tmp).isNot((Predicate)CommonChecks.empty(), () -> new NoPublicSettersException(this.beanClass));
        return tmp;
    }

    private void set(T bean, Setter setter, Object value) throws Throwable {
        if (this.transformer != null) {
            value = this.transformer.transform(bean, setter.getProperty(), value);
        }
        setter.write(bean, value);
    }

    private BeanReader<T> getBeanReader() {
        if (this.beanReader == null) {
            this.beanReader = new BeanReader<T>(this.beanClass, (String[])this.setters.keySet().toArray(String[]::new));
        }
        return this.beanReader;
    }
}

