/*
 * Decompiled with CFR 0.152.
 */
package org.klojang.path;

import java.util.OptionalInt;
import org.klojang.check.extra.Result;
import org.klojang.convert.NumberMethods;
import org.klojang.path.DeadEndException;
import org.klojang.path.ObjectReader;
import org.klojang.path.PathSegmentDeserializer;
import org.klojang.path.SegmentNode;
import org.klojang.path.SegmentReader;
import org.klojang.util.Path;

final class ArraySegmentReader
extends SegmentReader<Object[]> {
    ArraySegmentReader(boolean suppressExceptions, PathSegmentDeserializer keyDeserializer) {
        super(suppressExceptions, keyDeserializer);
    }

    @Override
    Result<Object> read(Object[] array, SegmentNode node) {
        OptionalInt opt = NumberMethods.toInt((String)node.segment());
        if (opt.isPresent()) {
            int idx = opt.getAsInt();
            if (idx < array.length) {
                return Result.of((Object)array[idx]);
            }
            return this.deadEnd(DeadEndException.indexOutOfBounds(node.getArbitraryFullPath(), node.segmentIndex()));
        }
        return this.deadEnd(DeadEndException.indexExpected(node.getArbitraryFullPath(), node.segmentIndex()));
    }

    @Override
    Result<Object> read(Object[] array, Path path, int segment) {
        OptionalInt opt = NumberMethods.toInt((String)path.segment(segment));
        if (opt.isPresent()) {
            int idx = opt.getAsInt();
            if (idx < array.length) {
                return new ObjectReader(this.suppressExceptions, this.keyDeserializer).read(array[idx], path, ++segment);
            }
            return this.deadEnd(DeadEndException.indexOutOfBounds(path, segment));
        }
        return this.deadEnd(DeadEndException.indexExpected(path, segment));
    }
}

