/*
 * Decompiled with CFR 0.152.
 */
package org.klojang.path;

import java.util.OptionalInt;
import org.klojang.convert.NumberMethods;
import org.klojang.path.DeadEndException;
import org.klojang.path.PathSegmentDeserializer;
import org.klojang.path.SegmentWriter;
import org.klojang.util.Path;

final class ArraySegmentWriter
extends SegmentWriter<Object[]> {
    ArraySegmentWriter(boolean suppressExceptions, PathSegmentDeserializer keyDeserializer) {
        super(suppressExceptions, keyDeserializer);
    }

    @Override
    boolean write(Object[] array, Path path, Object value) {
        Class<?> elemClass;
        int segment = path.size() - 1;
        if (value != null && !(elemClass = array.getClass().getComponentType()).isInstance(value)) {
            return this.deadEnd(DeadEndException.typeMismatch(path, segment, elemClass, value.getClass()));
        }
        OptionalInt opt = NumberMethods.toInt((String)path.segment(segment));
        if (opt.isEmpty()) {
            return this.deadEnd(DeadEndException.indexExpected(path, segment));
        }
        int idx = opt.getAsInt();
        if (idx < array.length) {
            array[idx] = value;
            return true;
        }
        return this.deadEnd(DeadEndException.indexOutOfBounds(path, segment));
    }
}

