/*
 * Decompiled with CFR 0.152.
 */
package org.klojang.path;

import org.klojang.check.extra.Result;
import org.klojang.invoke.BeanReader;
import org.klojang.invoke.NoPublicGettersException;
import org.klojang.invoke.NoSuchPropertyException;
import org.klojang.path.DeadEndException;
import org.klojang.path.ObjectReader;
import org.klojang.path.PathSegmentDeserializer;
import org.klojang.path.SegmentNode;
import org.klojang.path.SegmentReader;
import org.klojang.util.ObjectMethods;
import org.klojang.util.Path;

final class BeanSegmentReader
extends SegmentReader<Object> {
    BeanSegmentReader(boolean suppressExceptions, PathSegmentDeserializer keyDeserializer) {
        super(suppressExceptions, keyDeserializer);
    }

    @Override
    Result<Object> read(Object bean, SegmentNode node) {
        BeanReader reader;
        String property = node.segment();
        if (ObjectMethods.isEmpty((CharSequence)property)) {
            return this.deadEnd(DeadEndException.emptySegment(node.getArbitraryFullPath(), node.segmentIndex()));
        }
        try {
            reader = new BeanReader(bean.getClass(), new String[0]);
        }
        catch (NoPublicGettersException e) {
            return this.deadEnd(DeadEndException.terminalValue(node.getArbitraryFullPath(), node.segmentIndex(), bean.getClass()));
        }
        try {
            return Result.of(reader.read(bean, property));
        }
        catch (NoSuchPropertyException e) {
            return this.deadEnd(DeadEndException.noSuchProperty(node.getArbitraryFullPath(), node.segmentIndex(), bean.getClass()));
        }
    }

    @Override
    Result<Object> read(Object bean, Path path, int segment) {
        BeanReader reader;
        String property = path.segment(segment);
        if (ObjectMethods.isEmpty((CharSequence)property)) {
            return this.deadEnd(DeadEndException.emptySegment(path, segment));
        }
        try {
            reader = new BeanReader(bean.getClass(), new String[0]);
        }
        catch (NoPublicGettersException e) {
            return this.deadEnd(DeadEndException.terminalValue(path, segment, bean.getClass()));
        }
        try {
            Object val = reader.read(bean, property);
            return new ObjectReader(this.suppressExceptions, this.keyDeserializer).read(val, path, ++segment);
        }
        catch (NoSuchPropertyException e) {
            return this.deadEnd(DeadEndException.noSuchProperty(path, segment, bean.getClass()));
        }
    }
}

