/*
 * Decompiled with CFR 0.152.
 */
package org.klojang.path;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.OptionalInt;
import org.klojang.check.extra.Result;
import org.klojang.convert.NumberMethods;
import org.klojang.path.DeadEndException;
import org.klojang.path.ObjectReader;
import org.klojang.path.PathSegmentDeserializer;
import org.klojang.path.SegmentNode;
import org.klojang.path.SegmentReader;
import org.klojang.util.Path;

final class CollectionSegmentReader
extends SegmentReader<Collection> {
    CollectionSegmentReader(boolean suppressExceptions, PathSegmentDeserializer keyDeserializer) {
        super(suppressExceptions, keyDeserializer);
    }

    @Override
    Result<Object> read(Collection collection, SegmentNode node) {
        OptionalInt opt = NumberMethods.toInt((String)node.segment());
        if (opt.isPresent()) {
            int idx = opt.getAsInt();
            if (idx < collection.size()) {
                if (collection instanceof List) {
                    List list = (List)collection;
                    return Result.of(list.get(idx));
                }
                Iterator iter = collection.iterator();
                while (idx != 0 && iter.hasNext()) {
                    --idx;
                    iter.next();
                }
                return Result.of(iter.next());
            }
            return this.deadEnd(DeadEndException.indexOutOfBounds(node.getArbitraryFullPath(), node.segmentIndex()));
        }
        return this.deadEnd(DeadEndException.indexExpected(node.getArbitraryFullPath(), node.segmentIndex()));
    }

    @Override
    Result<Object> read(Collection collection, Path path, int segment) {
        OptionalInt opt = NumberMethods.toInt((String)path.segment(segment));
        if (opt.isPresent()) {
            int idx = opt.getAsInt();
            if (idx < collection.size()) {
                Object elem;
                if (collection instanceof List) {
                    List list = (List)collection;
                    elem = list.get(idx);
                } else {
                    Iterator iter = collection.iterator();
                    while (idx != 0 && iter.hasNext()) {
                        --idx;
                        iter.next();
                    }
                    elem = iter.next();
                }
                return new ObjectReader(this.suppressExceptions, this.keyDeserializer).read(elem, path, ++segment);
            }
            return this.deadEnd(DeadEndException.indexOutOfBounds(path, segment));
        }
        return this.deadEnd(DeadEndException.indexExpected(path, segment));
    }
}

