/*
 * Decompiled with CFR 0.152.
 */
package org.klojang.path;

import java.util.function.Supplier;
import org.klojang.util.ClassMethods;
import org.klojang.util.Path;

public final class DeadEndException
extends RuntimeException {
    private static final String INVALID_PATH = "Invalid path: \"%s\" (segment %d). ";
    private static final String PATH_SEGMENT = "Path %s, segment %s: ";

    static Factory noSuchProperty(Path path, int segment, Class<?> clazz) {
        return () -> {
            String fmt = "Invalid path: \"%s\" (segment %d). No accessible property named \"%s\" in %s";
            String msg = fmt.formatted(path, segment + 1, path.segment(segment), ClassMethods.className((Class)clazz));
            return new DeadEndException(msg);
        };
    }

    static Factory noSuchKey(Path path, int segment, Object key) {
        return () -> {
            String fmt = "Invalid path: \"%s\" (segment %d). No such key: \"%s\"";
            String msg = fmt.formatted(path, segment + 1, key);
            return new DeadEndException(msg);
        };
    }

    static Factory indexExpected(Path path, int segment) {
        return () -> {
            String fmt = "Invalid path: \"%s\" (segment %d). Array or list index expected. Found: \"%s\"";
            String msg = fmt.formatted(path, segment + 1, path.segment(segment));
            return new DeadEndException(msg);
        };
    }

    static Factory indexOutOfBounds(Path path, int segment) {
        return () -> {
            String fmt = "Invalid path: \"%s\" (segment %d). Index out of bounds: %s";
            String msg = fmt.formatted(path, segment + 1, path.segment(segment));
            return new DeadEndException(msg);
        };
    }

    static Factory nullValue(Path path, int segment) {
        return () -> {
            String fmt = "Invalid path: \"%s\" (segment %d). Terminal value encountered at segment \"%s\": null";
            String msg = fmt.formatted(path, segment + 1, path.segment(segment));
            return new DeadEndException(msg);
        };
    }

    static Factory terminalValue(Path path, int segment, Object value) {
        return () -> {
            String fmt = "Invalid path: \"%s\" (segment %d). Terminal value encountered at segment \"%s\": (%s) %s";
            String className = ClassMethods.simpleClassName(value.getClass());
            String msg = fmt.formatted(path, segment + 1, path.segment(segment), className, value);
            return new DeadEndException(msg);
        };
    }

    static Factory emptySegment(Path path, int segment) {
        return () -> {
            String fmt = "Invalid path: \"%s\" (segment %d). Segment must not be null or empty";
            String msg = fmt.formatted(path, segment + 1);
            return new DeadEndException(msg);
        };
    }

    static Factory typeMismatch(Path path, int segment, String message) {
        return () -> {
            String fmt = "Path %s, segment %s: %s";
            String msg = fmt.formatted(path, segment + 1, message);
            return new DeadEndException(msg);
        };
    }

    static Factory typeMismatch(Path path, int segment, Class<?> expected, Class<?> actual) {
        return () -> {
            String fmt = "Path %s, segment %s: cannot assign %s to %s";
            String scn0 = ClassMethods.simpleClassName((Class)expected);
            String scn1 = ClassMethods.simpleClassName((Class)actual);
            String msg = fmt.formatted(path, segment + 1, scn0, scn1);
            return new DeadEndException(msg);
        };
    }

    static Factory notModifiable(Path path, int segment, Class<?> type) {
        return () -> {
            String fmt = "Path %s, segment %s: %s at segment \"%s\" not modifiable";
            String scn = ClassMethods.simpleClassName((Class)type);
            String msg = fmt.formatted(path, segment + 1, scn, path.segment(segment));
            return new DeadEndException(msg);
        };
    }

    static Factory deserializationFailed(Path path, int segment, Exception exc) {
        return () -> {
            Object fmt = exc.getMessage() == null ? "Invalid path: \"%s\" (segment %d). Failed to deserialize \"%s\" into map key" : "Invalid path: \"%s\" (segment %d). Failed to deserialize \"%s\" into map key. " + String.valueOf(exc);
            String msg = ((String)fmt).formatted(path, segment + 1, path.segment(segment));
            return new DeadEndException(msg);
        };
    }

    static Factory unexpectedError(Path path, int segment, Throwable t) {
        return () -> {
            String fmt = "Path %s, segment %s: Unexpected error. %s";
            String msg = fmt.formatted(path, segment + 1, t);
            return new DeadEndException(msg);
        };
    }

    private DeadEndException(String message) {
        super(message);
    }

    static interface Factory
    extends Supplier<DeadEndException> {
    }
}

