/*
 * Decompiled with CFR 0.152.
 */
package org.klojang.path;

import java.util.Map;
import org.klojang.check.extra.Result;
import org.klojang.path.DeadEndException;
import org.klojang.path.ObjectReader;
import org.klojang.path.PathSegmentDeserializer;
import org.klojang.path.SegmentNode;
import org.klojang.path.SegmentReader;
import org.klojang.util.Path;

final class MapSegmentReader
extends SegmentReader<Map<?, ?>> {
    MapSegmentReader(boolean suppressExceptions, PathSegmentDeserializer keyDeserializer) {
        super(suppressExceptions, keyDeserializer);
    }

    @Override
    Result<Object> read(Map<?, ?> map, SegmentNode node) {
        Object key;
        if (this.keyDeserializer == null) {
            key = node.segment();
        } else {
            try {
                key = this.keyDeserializer.deserialize(node.toPath(), node.segmentIndex());
            }
            catch (Exception e) {
                return this.deadEnd(DeadEndException.deserializationFailed(node.getArbitraryFullPath(), node.segmentIndex(), e));
            }
        }
        Object val = map.get(key);
        if (val == null && !map.containsKey(key)) {
            return this.deadEnd(DeadEndException.noSuchKey(node.getArbitraryFullPath(), node.segmentIndex(), key));
        }
        return Result.of(val);
    }

    @Override
    Result<Object> read(Map<?, ?> map, Path path, int segment) {
        Object key;
        if (this.keyDeserializer == null) {
            key = path.segment(segment);
        } else {
            try {
                key = this.keyDeserializer.deserialize(path, segment);
            }
            catch (Exception e) {
                return this.deadEnd(DeadEndException.deserializationFailed(path, segment, e));
            }
        }
        Object val = map.get(key);
        if (val == null && !map.containsKey(key)) {
            return this.deadEnd(DeadEndException.noSuchKey(path, segment, key));
        }
        return new ObjectReader(this.suppressExceptions, this.keyDeserializer).read(val, path, ++segment);
    }
}

