/*
 * Decompiled with CFR 0.152.
 */
package org.klojang.path;

import java.util.Collection;
import java.util.Map;
import org.klojang.check.extra.Result;
import org.klojang.path.ArraySegmentReader;
import org.klojang.path.BeanSegmentReader;
import org.klojang.path.CollectionSegmentReader;
import org.klojang.path.DeadEndException;
import org.klojang.path.MapSegmentReader;
import org.klojang.path.PathSegmentDeserializer;
import org.klojang.path.PrimitiveArraySegmentReader;
import org.klojang.path.SegmentNode;
import org.klojang.util.ClassMethods;
import org.klojang.util.Path;

final class ObjectReader {
    private final boolean suppressExceptions;
    private final PathSegmentDeserializer keyDeserializer;

    ObjectReader(boolean suppressExceptions, PathSegmentDeserializer keyDeserializer) {
        this.suppressExceptions = suppressExceptions;
        this.keyDeserializer = keyDeserializer;
    }

    void read(Map<Path, Result<Object>> results, Object obj, SegmentNode node) {
        if (node.isRootNode()) {
            node.children().values().forEach(child -> this.read(results, obj, (SegmentNode)child));
        } else if (obj == null) {
            if (!this.suppressExceptions) {
                throw (DeadEndException)DeadEndException.nullValue(node.getArbitraryFullPath(), node.segmentIndex()).get();
            }
        } else {
            Result<Object> next;
            if (obj instanceof Collection) {
                Collection x = (Collection)obj;
                next = new CollectionSegmentReader(this.suppressExceptions, this.keyDeserializer).read(x, node);
            } else if (obj instanceof Object[]) {
                Object[] x = (Object[])obj;
                next = new ArraySegmentReader(this.suppressExceptions, this.keyDeserializer).read(x, node);
            } else if (obj instanceof Map) {
                Map x = (Map)obj;
                next = new MapSegmentReader(this.suppressExceptions, this.keyDeserializer).read(x, node);
            } else {
                next = ClassMethods.isPrimitiveArray((Object)obj) ? new PrimitiveArraySegmentReader(this.suppressExceptions, this.keyDeserializer).read(obj, node) : new BeanSegmentReader(this.suppressExceptions, this.keyDeserializer).read(obj, node);
            }
            if (next.isAvailable()) {
                if (node.isLeaf()) {
                    results.put(node.toPath(), next);
                } else {
                    node.children().values().forEach(child -> this.read(results, next.get(), (SegmentNode)child));
                }
            }
        }
    }

    Result<Object> read(Object obj, Path path, int segment) {
        if (segment == path.size()) {
            return Result.of((Object)obj);
        }
        if (obj == null) {
            return this.deadEnd(DeadEndException.nullValue(path, segment));
        }
        if (obj instanceof Collection) {
            Collection x = (Collection)obj;
            return new CollectionSegmentReader(this.suppressExceptions, this.keyDeserializer).read(x, path, segment);
        }
        if (obj instanceof Object[]) {
            Object[] x = (Object[])obj;
            return new ArraySegmentReader(this.suppressExceptions, this.keyDeserializer).read(x, path, segment);
        }
        if (obj instanceof Map) {
            Map x = (Map)obj;
            return new MapSegmentReader(this.suppressExceptions, this.keyDeserializer).read(x, path, segment);
        }
        if (ClassMethods.isPrimitiveArray((Object)obj)) {
            return new PrimitiveArraySegmentReader(this.suppressExceptions, this.keyDeserializer).read(obj, path, segment);
        }
        return new BeanSegmentReader(this.suppressExceptions, this.keyDeserializer).read(obj, path, segment);
    }

    Result<Object> deadEnd(DeadEndException.Factory excFactory) {
        if (this.suppressExceptions) {
            return Result.notAvailable();
        }
        throw (DeadEndException)excFactory.get();
    }
}

