/*
 * Decompiled with CFR 0.152.
 */
package org.klojang.path;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import org.klojang.check.Check;
import org.klojang.check.CommonChecks;
import org.klojang.check.extra.Result;
import org.klojang.path.DeadEndException;
import org.klojang.path.ObjectReader;
import org.klojang.path.PathSegmentDeserializer;
import org.klojang.path.SegmentNode;
import org.klojang.util.Path;

public final class PathTreeWalker {
    private static final String PATHS = "paths";
    private final List<Path> paths;
    private final SegmentNode root;
    private final boolean suppressExceptions;
    private final PathSegmentDeserializer segmentDeserializer;

    public PathTreeWalker(Path ... paths) {
        this(List.of((Path[])Check.notNull((Object)paths, (String)PATHS).ok()));
    }

    public PathTreeWalker(String ... paths) {
        this(PathTreeWalker.toPathList(paths), true);
    }

    public PathTreeWalker(List<Path> paths) {
        this(paths, true);
    }

    public PathTreeWalker(List<Path> paths, boolean suppressExceptions) {
        Check.that(paths, (String)PATHS).isNot((Predicate)CommonChecks.empty()).is((Predicate)CommonChecks.deepNotNull());
        this.paths = paths;
        this.root = SegmentNode.buildTree(paths);
        this.suppressExceptions = suppressExceptions;
        this.segmentDeserializer = null;
    }

    public PathTreeWalker(List<Path> paths, boolean suppressExceptions, PathSegmentDeserializer segmentDeserializer) {
        Check.that(paths, (String)PATHS).isNot((Predicate)CommonChecks.empty()).is((Predicate)CommonChecks.deepNotNull());
        Check.notNull((Object)segmentDeserializer, (String)"segment deserializer");
        this.paths = paths;
        this.root = SegmentNode.buildTree(paths);
        this.suppressExceptions = suppressExceptions;
        this.segmentDeserializer = segmentDeserializer;
    }

    public Map<Path, Result<Object>> read(Object host) throws DeadEndException {
        HashMap<Path, Result<Object>> results = HashMap.newHashMap(this.paths.size());
        this.paths.forEach(path -> results.put((Path)path, (Result<Object>)Result.notAvailable()));
        ObjectReader reader = new ObjectReader(this.suppressExceptions, this.segmentDeserializer);
        reader.read(results, host, this.root);
        return results;
    }

    private static List<Path> toPathList(String[] paths) {
        Check.notNull((Object)paths, (String)PATHS);
        return Arrays.stream(paths).map(Path::from).toList();
    }
}

