/*
 * Decompiled with CFR 0.152.
 */
package org.klojang.path;

import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;
import org.klojang.check.Check;
import org.klojang.check.CommonChecks;
import org.klojang.check.CommonProperties;
import org.klojang.check.extra.Result;
import org.klojang.path.DeadEndException;
import org.klojang.path.ObjectReader;
import org.klojang.path.ObjectWriter;
import org.klojang.path.PathSegmentDeserializer;
import org.klojang.util.ClassMethods;
import org.klojang.util.Path;

public final class PathWalker {
    private static final String PATHS = "paths";
    private final List<Path> paths;
    private final boolean suppressExceptions;
    private final PathSegmentDeserializer segmentDeserializer;

    public static <T> T get(Object host, String path) {
        return (T)PathWalker.read(host, path).get();
    }

    public static <T> Result<T> read(Object host, String path) {
        return new PathWalker(path).read(host);
    }

    public PathWalker(Path ... paths) {
        Check.that((Object)paths, (String)PATHS).isNot((Predicate)CommonChecks.empty()).is((Predicate)CommonChecks.deepNotNull());
        this.paths = List.of(paths);
        this.suppressExceptions = true;
        this.segmentDeserializer = null;
    }

    public PathWalker(String ... paths) {
        Check.that((Object)paths, (String)PATHS).isNot((Predicate)CommonChecks.empty()).is((Predicate)CommonChecks.deepNotNull());
        this.paths = Arrays.stream(paths).map(Path::from).toList();
        this.suppressExceptions = true;
        this.segmentDeserializer = null;
    }

    public PathWalker(List<Path> paths) {
        this(paths, true);
    }

    public PathWalker(List<Path> paths, boolean suppressExceptions) {
        Check.that(paths, (String)PATHS).isNot((Predicate)CommonChecks.empty()).is((Predicate)CommonChecks.deepNotNull());
        this.paths = List.copyOf(paths);
        this.suppressExceptions = suppressExceptions;
        this.segmentDeserializer = null;
    }

    public PathWalker(List<Path> paths, boolean suppressExceptions, PathSegmentDeserializer segmentDeserializer) {
        Check.that(paths, (String)PATHS).isNot((Predicate)CommonChecks.empty()).is((Predicate)CommonChecks.deepNotNull());
        Check.notNull((Object)segmentDeserializer, (String)"segment deserializer");
        this.paths = List.copyOf(paths);
        this.suppressExceptions = suppressExceptions;
        this.segmentDeserializer = segmentDeserializer;
    }

    PathWalker(Path path, boolean suppressExceptions, PathSegmentDeserializer segmentDeserializer) {
        this.paths = List.of(path);
        this.suppressExceptions = suppressExceptions;
        this.segmentDeserializer = segmentDeserializer;
    }

    public List<Result<Object>> readValues(Object host) throws DeadEndException {
        ObjectReader reader = new ObjectReader(this.suppressExceptions, this.segmentDeserializer);
        return this.paths.stream().map(path -> reader.read(host, (Path)path, 0)).toList();
    }

    public <T> Result<T> read(Object host) {
        return (Result)ClassMethods.cast(new ObjectReader(this.suppressExceptions, this.segmentDeserializer).read(host, this.paths.getFirst(), 0));
    }

    public boolean[] writeValues(Object host, Object ... values) {
        return this.writeValues(host, List.of(values));
    }

    public boolean[] writeValues(Object host, List<Object> values) {
        Check.notNull(values, (String)"values").has(CommonProperties.size(), CommonChecks.eq(), this.paths.size());
        ObjectWriter writer = new ObjectWriter(this.suppressExceptions, this.segmentDeserializer);
        boolean[] result = new boolean[this.paths.size()];
        for (int i = 0; i < this.paths.size(); ++i) {
            if (!writer.write(host, this.paths.get(i), values.get(i))) continue;
            result[i] = true;
        }
        return result;
    }

    public boolean write(Object host, Object value) {
        return new ObjectWriter(this.suppressExceptions, this.segmentDeserializer).write(host, this.paths.getFirst(), value);
    }
}

