/*
 * Decompiled with CFR 0.152.
 */
package org.klojang.path;

import java.util.OptionalInt;
import org.klojang.check.extra.Result;
import org.klojang.convert.NumberMethods;
import org.klojang.path.DeadEndException;
import org.klojang.path.ObjectReader;
import org.klojang.path.PathSegmentDeserializer;
import org.klojang.path.SegmentNode;
import org.klojang.path.SegmentReader;
import org.klojang.util.InvokeMethods;
import org.klojang.util.Path;

final class PrimitiveArraySegmentReader
extends SegmentReader<Object> {
    PrimitiveArraySegmentReader(boolean suppressExceptions, PathSegmentDeserializer keyDeserializer) {
        super(suppressExceptions, keyDeserializer);
    }

    @Override
    Result<Object> read(Object array, SegmentNode node) {
        OptionalInt opt = NumberMethods.toInt((String)node.segment());
        if (opt.isEmpty()) {
            return this.deadEnd(DeadEndException.indexExpected(node.getArbitraryFullPath(), node.segmentIndex()));
        }
        int idx = opt.getAsInt();
        int len = InvokeMethods.getArrayLength((Object)array);
        if (idx >= 0 && idx < len) {
            Object val = InvokeMethods.getArrayElement((Object)array, (int)idx);
            return Result.of((Object)val);
        }
        return this.deadEnd(DeadEndException.indexOutOfBounds(node.getArbitraryFullPath(), node.segmentIndex()));
    }

    @Override
    Result<Object> read(Object array, Path path, int segment) {
        OptionalInt opt = NumberMethods.toInt((String)path.segment(segment));
        if (opt.isEmpty()) {
            return this.deadEnd(DeadEndException.indexExpected(path, segment));
        }
        int idx = opt.getAsInt();
        int len = InvokeMethods.getArrayLength((Object)array);
        if (idx >= 0 && idx < len) {
            Object val = InvokeMethods.getArrayElement((Object)array, (int)idx);
            return new ObjectReader(this.suppressExceptions, this.keyDeserializer).read(val, path, ++segment);
        }
        return this.deadEnd(DeadEndException.indexOutOfBounds(path, segment));
    }
}

