/*
 * Decompiled with CFR 0.152.
 */
package org.klojang.path;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.klojang.util.Path;

final class SegmentNode {
    private final Path path;
    private final int index;
    private final Map<String, SegmentNode> children;

    static SegmentNode buildTree(List<Path> paths) {
        SegmentNode root = new SegmentNode(null, -1);
        paths.forEach(p -> root.addPath((Path)p, 0));
        return root;
    }

    SegmentNode(Path path, int index) {
        this.path = path;
        this.index = index;
        this.children = new HashMap<String, SegmentNode>();
    }

    String segment() {
        return this.path.segment(this.index);
    }

    boolean isRootNode() {
        return this.path == null;
    }

    boolean isLeaf() {
        return this.index == this.path.size() - 1;
    }

    Map<String, SegmentNode> children() {
        return this.children;
    }

    int segmentIndex() {
        return this.index;
    }

    Path getArbitraryFullPath() {
        return this.path;
    }

    Path toPath() {
        if (this.segmentIndex() == this.path.size() - 1) {
            return this.path;
        }
        return this.path.subPath(0, this.index + 1);
    }

    public String toString() {
        return this.toPath().toString();
    }

    private void addPath(Path path, int index) {
        if (index < path.size()) {
            SegmentNode node = this.children.computeIfAbsent(path.segment(index), string -> new SegmentNode(path, index));
            node.addPath(path, index + 1);
        }
    }
}

