/*
 * Decompiled with CFR 0.152.
 */
package gnu.io;

import gnu.io.CommDriver;
import gnu.io.CommPort;
import gnu.io.CommPortEnumerator;
import gnu.io.CommPortOwnershipListener;
import gnu.io.NoSuchPortException;
import gnu.io.PortInUseException;
import gnu.io.UnsupportedCommOperationException;
import java.io.FileDescriptor;
import java.util.Enumeration;
import java.util.Vector;

public class CommPortIdentifier {
    public static final int PORT_SERIAL = 1;
    public static final int PORT_PARALLEL = 2;
    public static final int PORT_I2C = 3;
    public static final int PORT_RS485 = 4;
    public static final int PORT_RAW = 5;
    private String PortName;
    private boolean Available = true;
    private String Owner;
    private CommPort commport;
    private CommDriver RXTXDriver;
    static CommPortIdentifier CommPortIndex;
    CommPortIdentifier next;
    private int PortType;
    private static final boolean debug = false;
    static Object Sync;
    Vector ownershipListener;
    private boolean HideOwnerEvents;

    CommPortIdentifier(String pn, CommPort cp, int pt, CommDriver driver) {
        this.PortName = pn;
        this.commport = cp;
        this.PortType = pt;
        this.next = null;
        this.RXTXDriver = driver;
    }

    public static void addPortName(String s, int type, CommDriver c) {
        CommPortIdentifier.AddIdentifierToList(new CommPortIdentifier(s, null, type, c));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void AddIdentifierToList(CommPortIdentifier cpi) {
        Object object = Sync;
        synchronized (object) {
            if (CommPortIndex == null) {
                CommPortIndex = cpi;
            } else {
                CommPortIdentifier index = CommPortIndex;
                while (index.next != null) {
                    index = index.next;
                }
                index.next = cpi;
            }
        }
    }

    public void addPortOwnershipListener(CommPortOwnershipListener c) {
        if (this.ownershipListener == null) {
            this.ownershipListener = new Vector();
        }
        if (!this.ownershipListener.contains(c)) {
            this.ownershipListener.addElement(c);
        }
    }

    public String getCurrentOwner() {
        return this.Owner;
    }

    public String getName() {
        return this.PortName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CommPortIdentifier getPortIdentifier(String s) throws NoSuchPortException {
        CommPortIdentifier index = CommPortIndex;
        Object object = Sync;
        synchronized (object) {
            while (index != null && !index.PortName.equals(s)) {
                index = index.next;
            }
        }
        if (index != null) {
            return index;
        }
        throw new NoSuchPortException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CommPortIdentifier getPortIdentifier(CommPort p) throws NoSuchPortException {
        CommPortIdentifier c = CommPortIndex;
        Object object = Sync;
        synchronized (object) {
            while (c != null && c.commport != p) {
                c = c.next;
            }
        }
        if (c != null) {
            return c;
        }
        throw new NoSuchPortException();
    }

    public static Enumeration getPortIdentifiers() {
        return new CommPortEnumerator();
    }

    public int getPortType() {
        return this.PortType;
    }

    public synchronized boolean isCurrentlyOwned() {
        return !this.Available;
    }

    public synchronized CommPort open(FileDescriptor f) throws UnsupportedCommOperationException {
        throw new UnsupportedCommOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized CommPort open(String TheOwner, int i) throws PortInUseException {
        if (!this.Available) {
            Object object = Sync;
            synchronized (object) {
                this.fireOwnershipEvent(3);
                try {
                    this.wait(i);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
            }
        }
        if (!this.Available) {
            throw new PortInUseException(this.getCurrentOwner());
        }
        if (this.commport == null) {
            this.commport = this.RXTXDriver.getCommPort(this.PortName, this.PortType);
        }
        if (this.commport != null) {
            this.Owner = TheOwner;
            this.Available = false;
            this.fireOwnershipEvent(1);
            return this.commport;
        }
        throw new PortInUseException(this.PortName);
    }

    public void removePortOwnershipListener(CommPortOwnershipListener c) {
        if (this.ownershipListener != null) {
            this.ownershipListener.removeElement(c);
        }
    }

    synchronized void internalClosePort() {
        this.Owner = null;
        this.Available = true;
        this.commport = null;
        this.notifyAll();
        this.fireOwnershipEvent(2);
    }

    void fireOwnershipEvent(int eventType) {
        if (this.ownershipListener != null) {
            Enumeration e = this.ownershipListener.elements();
            while (e.hasMoreElements()) {
                CommPortOwnershipListener c = (CommPortOwnershipListener)e.nextElement();
                c.ownershipChange(eventType);
            }
        }
    }

    static {
        Sync = new Object();
        try {
            CommDriver RXTXDriver = (CommDriver)Class.forName("gnu.io.RXTXCommDriver").newInstance();
            RXTXDriver.initialize();
        }
        catch (Throwable e) {
            System.err.println(e + " thrown while loading " + "gnu.io.RXTXCommDriver");
        }
        String OS = System.getProperty("os.name");
        if (OS.toLowerCase().indexOf("linux") == -1) {
            // empty if block
        }
    }
}

