/*
 * Decompiled with CFR 0.152.
 */
package org.knowhowlab.comm.testing.oracle;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.comm.CommDriver;
import javax.comm.CommPort;
import javax.comm.CommPortIdentifier;
import org.knowhowlab.comm.testing.common.Linkable;
import org.knowhowlab.comm.testing.common.config.DriverConfig;
import org.knowhowlab.comm.testing.common.config.PortConfig;
import org.knowhowlab.comm.testing.common.config.PortType;
import org.knowhowlab.comm.testing.oracle.MockOracleSerialPort;

public class MockOracleDriver
implements CommDriver {
    private static final Logger LOG = Logger.getLogger(MockOracleDriver.class.getName());
    private DriverConfig config;
    private List<Linkable> serialPorts = new ArrayList<Linkable>();

    public MockOracleDriver() {
    }

    public MockOracleDriver(DriverConfig config) {
        this.config = config;
    }

    public void initialize() {
        try {
            List<PortConfig> ports;
            this.serialPorts.clear();
            if (this.config != null && (ports = this.config.getPorts()) != null) {
                for (PortConfig port : ports) {
                    switch (port.getType()) {
                        case SERIAL: {
                            MockOracleSerialPort serialPort = new MockOracleSerialPort(port.getName());
                            this.serialPorts.add(serialPort);
                            if (port.getLinkPort() == null) break;
                            this.linkPort(this.serialPorts, serialPort, port.getLinkPort().getName());
                        }
                    }
                    CommPortIdentifier.addPortName((String)port.getName(), (int)port.getType().getCode(), (CommDriver)this);
                    LOG.info("Port is initialized: " + port.getName());
                }
            }
        }
        catch (IOException e) {
            LOG.log(Level.WARNING, "Initialization problem", e);
        }
    }

    private void linkPort(List<? extends Linkable> ports, Linkable port, String linkName) throws IOException {
        if (ports != null) {
            for (Linkable linkable : ports) {
                if (!linkable.getName().equals(linkName)) continue;
                port.linkTo(linkable);
            }
        }
    }

    public CommPort getCommPort(String portName, int portType) {
        if (portType == PortType.SERIAL.getCode()) {
            for (Linkable serialPort : this.serialPorts) {
                if (!serialPort.getName().equals(portName)) continue;
                return (CommPort)serialPort;
            }
        }
        return null;
    }

    public void setConfig(DriverConfig config) {
        this.config = config;
    }

    public void reset() throws IOException {
        for (Linkable port : this.serialPorts) {
            port.reset();
        }
    }
}

