/*
 * Decompiled with CFR 0.152.
 */
package org.knowhowlab.comm.testing.oracle;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.util.TooManyListenersException;
import java.util.logging.Logger;
import javax.comm.SerialPort;
import javax.comm.SerialPortEvent;
import javax.comm.SerialPortEventListener;
import javax.comm.UnsupportedCommOperationException;
import org.knowhowlab.comm.testing.common.DataListener;
import org.knowhowlab.comm.testing.common.Linkable;

public class MockOracleSerialPort
extends SerialPort
implements Linkable,
DataListener {
    private static final Logger LOG = Logger.getLogger(MockOracleSerialPort.class.getName());
    private SerialPortEventListener listener;
    private boolean notifyOnDataAvailable = false;
    private PipedInputStream inputStream;
    private PipedOutputStream outputStream;
    private boolean connected;
    private Linkable linkTo;

    public MockOracleSerialPort(String name) {
        this.name = name;
        this.inputStream = new PipedInputStream();
    }

    public int getBaudRate() {
        return 0;
    }

    public int getDataBits() {
        return 0;
    }

    public int getStopBits() {
        return 0;
    }

    public int getParity() {
        return 0;
    }

    public void sendBreak(int i) {
    }

    public void setFlowControlMode(int i) throws UnsupportedCommOperationException {
    }

    public int getFlowControlMode() {
        return 0;
    }

    public void setSerialPortParams(int i, int i2, int i3, int i4) throws UnsupportedCommOperationException {
    }

    public void setDTR(boolean b) {
    }

    public boolean isDTR() {
        return false;
    }

    public void setRTS(boolean b) {
    }

    public boolean isRTS() {
        return false;
    }

    public boolean isCTS() {
        return false;
    }

    public boolean isDSR() {
        return false;
    }

    public boolean isRI() {
        return false;
    }

    public boolean isCD() {
        return false;
    }

    public void addEventListener(SerialPortEventListener serialPortEventListener) throws TooManyListenersException {
        if (this.listener != null) {
            throw new TooManyListenersException("Listener is already set");
        }
        this.listener = serialPortEventListener;
    }

    public void removeEventListener() {
        this.listener = null;
    }

    public void notifyOnDataAvailable(boolean b) {
        this.notifyOnDataAvailable = b;
    }

    public void notifyOnOutputEmpty(boolean b) {
    }

    public void notifyOnCTS(boolean b) {
    }

    public void notifyOnDSR(boolean b) {
    }

    public void notifyOnRingIndicator(boolean b) {
    }

    public void notifyOnCarrierDetect(boolean b) {
    }

    public void notifyOnOverrunError(boolean b) {
    }

    public void notifyOnParityError(boolean b) {
    }

    public void notifyOnFramingError(boolean b) {
    }

    public void notifyOnBreakInterrupt(boolean b) {
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return this.inputStream;
    }

    @Override
    public PipedOutputStream getOutputStream(final DataListener listener) throws IOException {
        this.outputStream = new PipedOutputStream(){

            @Override
            public void write(byte[] b) throws IOException {
                super.write(b);
                listener.dataAvailable();
            }
        };
        return this.outputStream;
    }

    @Override
    public void reset() throws IOException {
        ((MockOracleSerialPort)this.linkTo).resetInternal();
        this.linkTo.linkTo(this);
        LOG.info("Port is reset: " + this.getName());
    }

    private void resetInternal() throws IOException {
        this.notifyOnDataAvailable = false;
        this.listener = null;
        this.inputStream = new PipedInputStream();
        this.inputStream.connect(this.linkTo.getOutputStream(this));
    }

    public OutputStream getOutputStream() throws IOException {
        return this.outputStream;
    }

    public void enableReceiveThreshold(int i) throws UnsupportedCommOperationException {
    }

    public void disableReceiveThreshold() {
    }

    public boolean isReceiveThresholdEnabled() {
        return false;
    }

    public int getReceiveThreshold() {
        return 0;
    }

    public void enableReceiveTimeout(int i) throws UnsupportedCommOperationException {
    }

    public void disableReceiveTimeout() {
    }

    public boolean isReceiveTimeoutEnabled() {
        return false;
    }

    public int getReceiveTimeout() {
        return 0;
    }

    public void enableReceiveFraming(int i) throws UnsupportedCommOperationException {
    }

    public void disableReceiveFraming() {
    }

    public boolean isReceiveFramingEnabled() {
        return false;
    }

    public int getReceiveFramingByte() {
        return 0;
    }

    public void setInputBufferSize(int i) {
    }

    public int getInputBufferSize() {
        return 0;
    }

    public void setOutputBufferSize(int i) {
    }

    public int getOutputBufferSize() {
        return 0;
    }

    @Override
    public void linkTo(Linkable linkTo) throws IOException {
        if (!this.connected) {
            this.connected = true;
            this.inputStream.connect(linkTo.getOutputStream(this));
            this.linkTo = linkTo;
            this.linkTo.linkTo(this);
        }
    }

    @Override
    public void dataAvailable() {
        if (this.notifyOnDataAvailable && this.listener != null) {
            this.listener.serialEvent(new SerialPortEvent((SerialPort)this, 1, false, true));
        }
    }
}

