/*
 * Decompiled with CFR 0.152.
 */
package org.knowhowlab.comm.testing.common.config;

import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.TreeSet;
import org.knowhowlab.comm.testing.common.config.PortConfig;
import org.knowhowlab.comm.testing.common.config.PortType;

public class DriverConfig {
    private static final String PORT_PREFIX = "port.";
    private static final String NAME_SUFFIX = ".name";
    private static final String TYPE_SUFFIX = ".type";
    private static final String LINK_TO_SUFFIX = ".linkTo";
    private List<PortConfig> ports = new ArrayList<PortConfig>();

    public DriverConfig(List<PortConfig> ports) {
        this.ports = ports;
    }

    public List<PortConfig> getPorts() {
        return this.ports;
    }

    public static DriverConfig unmarshal(String str) throws IOException {
        Properties props = new Properties();
        props.load(new StringReader(str));
        ArrayList<PortConfig> ports = new ArrayList<PortConfig>();
        TreeSet<Object> keys = new TreeSet<Object>(props.keySet());
        int processingIndex = 0;
        for (Object key : keys) {
            String keyStr = (String)key;
            int index = DriverConfig.readIndex(keyStr);
            if (index != processingIndex) continue;
            String name = props.getProperty(PORT_PREFIX + index + NAME_SUFFIX);
            PortType type = PortType.valueOf(props.getProperty(PORT_PREFIX + index + TYPE_SUFFIX));
            PortConfig linkToPort = DriverConfig.findLinkToPort(ports, props.getProperty(PORT_PREFIX + index + LINK_TO_SUFFIX));
            PortConfig port = new PortConfig(name, type, linkToPort);
            ports.add(port);
            ++processingIndex;
        }
        return new DriverConfig(ports);
    }

    private static PortConfig findLinkToPort(List<PortConfig> ports, String name) {
        for (PortConfig port : ports) {
            if (!name.equals(port.getName())) continue;
            return port;
        }
        return null;
    }

    private static int readIndex(String key) {
        return Integer.parseInt(key.substring(PORT_PREFIX.length(), key.indexOf(".", PORT_PREFIX.length())));
    }

    public String marshal() throws IOException {
        Properties props = new Properties();
        if (this.ports != null) {
            for (int i = 0; i < this.ports.size(); ++i) {
                PortConfig portConfig = this.ports.get(i);
                this.marshal(props, i, portConfig);
            }
        }
        StringWriter writer = new StringWriter();
        props.store(writer, null);
        return writer.toString();
    }

    private void marshal(Properties props, int index, PortConfig port) {
        props.put(PORT_PREFIX + index + NAME_SUFFIX, port.getName());
        props.put(PORT_PREFIX + index + TYPE_SUFFIX, port.getType().name());
        props.put(PORT_PREFIX + index + LINK_TO_SUFFIX, port.getLinkPort().getName());
    }
}

