/*
 * Decompiled with CFR 0.152.
 */
package org.knowhowlab.osgi.monitoradmin;

import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Dictionary;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.knowhowlab.osgi.monitoradmin.LogVisitor;
import org.knowhowlab.osgi.monitoradmin.OsgiVisitor;
import org.knowhowlab.osgi.monitoradmin.job.AbstractMonitoringJob;
import org.knowhowlab.osgi.monitoradmin.job.MonitoringJobVisitor;
import org.knowhowlab.osgi.monitoradmin.util.StatusVariablePath;
import org.knowhowlab.osgi.monitoradmin.util.Utils;
import org.osgi.framework.ServiceReference;
import org.osgi.service.event.Event;
import org.osgi.service.monitor.MonitorListener;
import org.osgi.service.monitor.Monitorable;
import org.osgi.service.monitor.MonitoringJob;
import org.osgi.service.monitor.StatusVariable;

class MonitorAdminCommon
implements MonitorListener,
MonitoringJobVisitor {
    private static final String SYMBOLIC_NAME_CHARACTERS = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789-_.";
    private static final int MAX_ID_LENGTH = 32;
    static final String PATH_PATTERN = "%s/%s";
    private final Set<String> disabledPaths = new HashSet<String>();
    private final List<AbstractMonitoringJob> jobs = new ArrayList<AbstractMonitoringJob>();
    private final OsgiVisitor osgiVisitor;
    private final LogVisitor logVisitor;

    MonitorAdminCommon(OsgiVisitor osgiVisitor, LogVisitor logVisitor) {
        this.osgiVisitor = osgiVisitor;
        this.logVisitor = logVisitor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updated(String monitorableId, StatusVariable statusVariable) throws IllegalArgumentException {
        this.findMonitorableById(monitorableId);
        if (statusVariable == null) {
            throw new IllegalArgumentException("StatusVariable is null");
        }
        StatusVariablePath path = new StatusVariablePath(monitorableId, statusVariable.getID());
        if (this.isEventEnabled(path.getPath())) {
            this.fireEvent(monitorableId, statusVariable, null);
            this.logVisitor.info("Fire new SV update Event: " + path.getPath(), null);
        }
        if (!this.jobs.isEmpty()) {
            List<AbstractMonitoringJob> list = this.jobs;
            synchronized (list) {
                for (AbstractMonitoringJob job : this.jobs) {
                    if (!job.isHandleUpdateEvent(path.getPath())) continue;
                    job.handleUpdateEvent(monitorableId, statusVariable);
                }
            }
        }
    }

    String[] getDisabledNotificationPaths() {
        return this.disabledPaths.toArray(new String[this.disabledPaths.size()]);
    }

    private boolean isEventEnabled(String path) {
        return !this.disabledPaths.contains(path);
    }

    private Monitorable findMonitorableById(String monitorableId) throws IllegalArgumentException {
        if (monitorableId == null) {
            throw new IllegalArgumentException("MonitorableId is null");
        }
        if (!Utils.validatePathId(monitorableId)) {
            throw new IllegalArgumentException("MonitorableId is invalid");
        }
        ServiceReference mostSuitableMonitorable = null;
        ServiceReference[] serviceReferences = this.osgiVisitor.findMonitorableReferences(monitorableId);
        if (serviceReferences != null) {
            for (ServiceReference serviceReference : serviceReferences) {
                if (mostSuitableMonitorable != null && mostSuitableMonitorable.compareTo((Object)serviceReference) >= 0) continue;
                mostSuitableMonitorable = serviceReference;
            }
        }
        if (mostSuitableMonitorable == null) {
            throw new IllegalArgumentException("Monitorable ID: " + monitorableId + " points to non-existing service");
        }
        return this.osgiVisitor.getService(mostSuitableMonitorable);
    }

    ServiceReference findMonitorableReferenceById(String monitorableId) throws IllegalArgumentException {
        if (monitorableId == null) {
            throw new IllegalArgumentException("MonitorableId is null");
        }
        if (!Utils.validatePathId(monitorableId)) {
            throw new IllegalArgumentException("MonitorableId is invalid");
        }
        ServiceReference mostSuitableMonitorable = null;
        ServiceReference[] serviceReferences = this.osgiVisitor.findMonitorableReferences(monitorableId);
        if (serviceReferences != null) {
            for (ServiceReference serviceReference : serviceReferences) {
                if (mostSuitableMonitorable != null && mostSuitableMonitorable.compareTo((Object)serviceReference) >= 0) continue;
                mostSuitableMonitorable = serviceReference;
            }
        }
        if (mostSuitableMonitorable == null) {
            throw new IllegalArgumentException("Monitorable ID: " + monitorableId + " points to non-existing service");
        }
        return mostSuitableMonitorable;
    }

    ServiceReference[] getMonitorableReferences() {
        return this.getMonitorableReferences(null);
    }

    ServiceReference[] getMonitorableReferences(String monitorableIdFilter) {
        TreeSet<ServiceReference> names = new TreeSet<ServiceReference>(new ServiceReferencePidComparator());
        ServiceReference[] serviceReferences = this.osgiVisitor.findMonitorableReferences(monitorableIdFilter);
        if (serviceReferences != null) {
            for (ServiceReference serviceReference : serviceReferences) {
                String pid = (String)serviceReference.getProperty("service.pid");
                if (pid == null || !MonitorAdminCommon.isValidId(pid)) continue;
                names.add(serviceReference);
            }
        }
        return names.toArray(new ServiceReference[names.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addJob(AbstractMonitoringJob job) {
        List<AbstractMonitoringJob> list = this.jobs;
        synchronized (list) {
            this.jobs.add(job);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<MonitoringJob> getRunningJobs() {
        ArrayList<MonitoringJob> runningJobs = new ArrayList<MonitoringJob>();
        List<AbstractMonitoringJob> list = this.jobs;
        synchronized (list) {
            for (AbstractMonitoringJob job : this.jobs) {
                if (!job.isRunning()) continue;
                runningJobs.add(job);
            }
        }
        return runningJobs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StatusVariable getStatusVariable(String path) throws IllegalArgumentException {
        this.logVisitor.debug("ENTRY: getStatusVariable: " + path, null);
        try {
            StatusVariablePath statusVariablePath = new StatusVariablePath(path);
            Monitorable monitorable = this.findMonitorableById(statusVariablePath.getMonitorableId());
            StatusVariable statusVariable = monitorable.getStatusVariable(statusVariablePath.getStatusVariableId());
            return statusVariable;
        }
        finally {
            this.logVisitor.debug("EXIT: getStatusVariable: " + path, null);
        }
    }

    StatusVariable getStatusVariable(ServiceReference serviceReference, String statusVariableId) {
        return this.osgiVisitor.getService(serviceReference).getStatusVariable(statusVariableId);
    }

    String getDescription(ServiceReference serviceReference, String statusVariableId) {
        return this.osgiVisitor.getService(serviceReference).getDescription(statusVariableId);
    }

    boolean notifiesOnChange(ServiceReference serviceReference, String statusVariableId) {
        return this.osgiVisitor.getService(serviceReference).notifiesOnChange(statusVariableId);
    }

    boolean resetStatusVariable(ServiceReference serviceReference, String statusVariableId) {
        return this.osgiVisitor.getService(serviceReference).resetStatusVariable(statusVariableId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancelJob(AbstractMonitoringJob job) {
        List<AbstractMonitoringJob> list = this.jobs;
        synchronized (list) {
            this.jobs.remove(job);
            job.cancel();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void cancelAllJobs() {
        block7: {
            this.logVisitor.debug("ENTRY: cancelJobs", null);
            try {
                if (this.jobs.isEmpty()) break block7;
                List<AbstractMonitoringJob> list = this.jobs;
                synchronized (list) {
                    Iterator<AbstractMonitoringJob> iterator = this.jobs.iterator();
                    while (iterator.hasNext()) {
                        AbstractMonitoringJob job = iterator.next();
                        job.cancel();
                        iterator.remove();
                    }
                }
            }
            finally {
                this.logVisitor.debug("EXIT: cancelJobs", null);
            }
        }
    }

    @Override
    public void fireEvent(String monitorableId, StatusVariable statusVariable, String initiator) {
        Hashtable<String, String> eventProperties = new Hashtable<String, String>();
        ((Dictionary)eventProperties).put("mon.monitorable.pid", monitorableId);
        ((Dictionary)eventProperties).put("mon.statusvariable.name", statusVariable.getID());
        String value = null;
        switch (statusVariable.getType()) {
            case 3: {
                value = Boolean.toString(statusVariable.getBoolean());
                break;
            }
            case 1: {
                value = Float.toString(statusVariable.getFloat());
                break;
            }
            case 0: {
                value = Integer.toString(statusVariable.getInteger());
                break;
            }
            case 2: {
                value = statusVariable.getString();
            }
        }
        ((Dictionary)eventProperties).put("mon.statusvariable.value", value);
        if (initiator != null) {
            ((Dictionary)eventProperties).put("mon.listener.id", initiator);
        }
        Event event = new Event("org/osgi/service/monitor", eventProperties);
        try {
            this.osgiVisitor.postEvent(event);
        }
        catch (SecurityException e) {
            this.logVisitor.error("MonitorAdmin bundle does not have TopicPermission", e);
        }
    }

    void switchEvents(Set<String> paths, boolean on) {
        if (on) {
            this.disabledPaths.removeAll(paths);
        } else {
            this.disabledPaths.addAll(paths);
        }
    }

    String[] getStatusVariableNames(String monitorableId) {
        Monitorable monitorable = this.findMonitorableById(monitorableId);
        String[] statusVariableNames = monitorable.getStatusVariableNames();
        ArrayList<String> result = new ArrayList<String>();
        for (String statusVariableName : statusVariableNames) {
            if (!MonitorAdminCommon.isValidId(statusVariableName)) continue;
            result.add(statusVariableName);
        }
        return result.toArray(new String[result.size()]);
    }

    private static boolean isValidId(String id) {
        char[] chars;
        byte[] nameBytes;
        try {
            nameBytes = id.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return false;
        }
        if (nameBytes.length > 32) {
            return false;
        }
        if (id.equals(".") || id.equals("..")) {
            return false;
        }
        for (char aChar : chars = id.toCharArray()) {
            if (SYMBOLIC_NAME_CHARACTERS.indexOf(aChar) != -1) continue;
            return false;
        }
        return true;
    }

    private static class ServiceReferencePidComparator
    implements Comparator<ServiceReference> {
        private ServiceReferencePidComparator() {
        }

        @Override
        public int compare(ServiceReference o1, ServiceReference o2) {
            String pid1 = (String)o1.getProperty("service.pid");
            String pid2 = (String)o2.getProperty("service.pid");
            return pid1.compareTo(pid2);
        }
    }
}

