/*
 * Decompiled with CFR 0.152.
 */
package org.knowhowlab.osgi.monitoradmin;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.TreeSet;
import org.knowhowlab.osgi.monitoradmin.LogVisitor;
import org.knowhowlab.osgi.monitoradmin.MonitorAdminCommon;
import org.knowhowlab.osgi.monitoradmin.job.ScheduledMonitoringJob;
import org.knowhowlab.osgi.monitoradmin.job.SubscriptionMonitoringJob;
import org.knowhowlab.osgi.monitoradmin.util.StatusVariablePath;
import org.knowhowlab.osgi.monitoradmin.util.StatusVariablePathFilter;
import org.osgi.framework.Bundle;
import org.osgi.framework.ServiceReference;
import org.osgi.service.monitor.MonitorAdmin;
import org.osgi.service.monitor.MonitorPermission;
import org.osgi.service.monitor.MonitoringJob;
import org.osgi.service.monitor.StatusVariable;

class MonitorAdminImpl
implements MonitorAdmin {
    private static final String STARTJOB_PERMISSION_PATTERN = String.format("%s:%%d", "startjob");
    private final LogVisitor logVisitor;
    private final MonitorAdminCommon common;
    private final Bundle consumer;

    MonitorAdminImpl(LogVisitor logVisitor, MonitorAdminCommon common, Bundle consumer) {
        this.logVisitor = logVisitor;
        this.common = common;
        this.consumer = consumer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StatusVariable getStatusVariable(String path) throws IllegalArgumentException, SecurityException {
        this.logVisitor.debug("ENTRY: getStatusVariable: " + path, null);
        try {
            StatusVariablePath statusVariablePath = new StatusVariablePath(path);
            ServiceReference serviceReference = this.common.findMonitorableReferenceById(statusVariablePath.getMonitorableId());
            this.checkPermissions(statusVariablePath, serviceReference, "publish", "read");
            StatusVariable statusVariable = this.common.getStatusVariable(serviceReference, statusVariablePath.getStatusVariableId());
            return statusVariable;
        }
        finally {
            this.logVisitor.debug("EXIT: getStatusVariable: " + path, null);
        }
    }

    private void checkPermissions(StatusVariablePath statusVariablePath, ServiceReference serviceReference, String producerPermission, String consumerPermission) {
        String[] variableNames = this.common.getStatusVariableNames(statusVariablePath.getMonitorableId());
        Collection<String> producerVariables = this.filterVariableNames(statusVariablePath.getMonitorableId(), variableNames, serviceReference.getBundle(), producerPermission);
        if (!producerVariables.contains(statusVariablePath.getStatusVariableId())) {
            throw new IllegalArgumentException(statusVariablePath.getPath() + " StatusVariable is unavailable");
        }
        Collection<String> consumerVariables = this.filterVariableNames(statusVariablePath.getMonitorableId(), variableNames, this.consumer, consumerPermission);
        if (!consumerVariables.contains(statusVariablePath.getStatusVariableId())) {
            throw new SecurityException(consumerPermission + " permissions not set for StatusVariable: " + statusVariablePath.getPath());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getDescription(String path) throws IllegalArgumentException, SecurityException {
        this.logVisitor.debug("ENTRY: getDescription: " + path, null);
        try {
            StatusVariablePath statusVariablePath = new StatusVariablePath(path);
            ServiceReference serviceReference = this.common.findMonitorableReferenceById(statusVariablePath.getMonitorableId());
            this.checkPermissions(statusVariablePath, serviceReference, "publish", "read");
            String string = this.common.getDescription(serviceReference, statusVariablePath.getStatusVariableId());
            return string;
        }
        finally {
            this.logVisitor.debug("EXIT: getDescription: " + path, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] getMonitorableNames() {
        this.logVisitor.debug("ENTRY: getMonitorableNames", null);
        try {
            ServiceReference[] serviceReferences = this.common.getMonitorableReferences();
            TreeSet<String> names = new TreeSet<String>();
            for (ServiceReference serviceReference : serviceReferences) {
                String pid = (String)serviceReference.getProperty("service.pid");
                String[] variableNames = this.common.getStatusVariableNames(pid);
                if (variableNames.length > 0) {
                    Collection<String> consumerReadVariables;
                    Collection<String> producerPublishedVariables = this.filterVariableNames(pid, variableNames, serviceReference.getBundle(), "publish");
                    if (Collections.disjoint(producerPublishedVariables, consumerReadVariables = this.filterVariableNames(pid, variableNames, this.consumer, "read"))) continue;
                    names.add(pid);
                    continue;
                }
                names.add(pid);
            }
            String[] stringArray = names.toArray(new String[names.size()]);
            return stringArray;
        }
        finally {
            this.logVisitor.debug("EXIT: getMonitorableNames", null);
        }
    }

    private Collection<String> filterVariableNames(String pid, String[] variableNames, Bundle bundle, String permissionAction) {
        ArrayList<String> result = new ArrayList<String>();
        if (bundle != null) {
            for (String variableName : variableNames) {
                try {
                    if (!bundle.hasPermission((Object)new MonitorPermission(String.format("%s/%s", pid, variableName), permissionAction))) continue;
                    result.add(variableName);
                }
                catch (IllegalArgumentException e) {
                    this.logVisitor.debug("Unable to check permission", e);
                }
            }
        } else {
            result.addAll(Arrays.asList(variableNames));
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StatusVariable[] getStatusVariables(String monitorableId) throws IllegalArgumentException {
        this.logVisitor.debug("ENTRY: getStatusVariables: " + monitorableId, null);
        try {
            ArrayList<StatusVariable> result = new ArrayList<StatusVariable>();
            TreeSet<String> availableNames = new TreeSet<String>();
            ServiceReference serviceReference = this.common.findMonitorableReferenceById(monitorableId);
            String[] variableNames = this.common.getStatusVariableNames(monitorableId);
            Collection<String> producerPublishedVariables = this.filterVariableNames(monitorableId, variableNames, serviceReference.getBundle(), "publish");
            Collection<String> consumerReadVariables = this.filterVariableNames(monitorableId, variableNames, this.consumer, "read");
            availableNames.addAll(producerPublishedVariables);
            availableNames.retainAll(consumerReadVariables);
            for (String availableName : availableNames) {
                result.add(this.common.getStatusVariable(serviceReference, availableName));
            }
            StatusVariable[] statusVariableArray = result.toArray(new StatusVariable[result.size()]);
            return statusVariableArray;
        }
        finally {
            this.logVisitor.debug("EXIT: getStatusVariables: " + monitorableId, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] getStatusVariableNames(String monitorableId) throws IllegalArgumentException {
        this.logVisitor.debug("ENTRY: getStatusVariableNames: " + monitorableId, null);
        try {
            TreeSet<String> result = new TreeSet<String>();
            ServiceReference serviceReference = this.common.findMonitorableReferenceById(monitorableId);
            String[] variableNames = this.common.getStatusVariableNames(monitorableId);
            Collection<String> producerPublishedVariables = this.filterVariableNames(monitorableId, variableNames, serviceReference.getBundle(), "publish");
            Collection<String> consumerReadVariables = this.filterVariableNames(monitorableId, variableNames, this.consumer, "read");
            result.addAll(producerPublishedVariables);
            result.retainAll(consumerReadVariables);
            String[] stringArray = result.toArray(new String[result.size()]);
            return stringArray;
        }
        finally {
            this.logVisitor.debug("EXIT: getStatusVariableNames: " + monitorableId, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean resetStatusVariable(String path) throws IllegalArgumentException, SecurityException {
        this.logVisitor.debug("ENTRY: resetStatusVariable: " + path, null);
        try {
            StatusVariablePath statusVariablePath = new StatusVariablePath(path);
            ServiceReference serviceReference = this.common.findMonitorableReferenceById(statusVariablePath.getMonitorableId());
            this.checkPermissions(statusVariablePath, serviceReference, "publish", "reset");
            boolean bl = this.common.resetStatusVariable(serviceReference, statusVariablePath.getStatusVariableId());
            return bl;
        }
        finally {
            this.logVisitor.debug("EXIT: resetStatusVariable: " + path, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void switchEvents(String path, boolean on) throws IllegalArgumentException, SecurityException {
        this.logVisitor.debug("ENTRY: switchEvents: " + path + ", " + on, null);
        try {
            ServiceReference[] monitorableReferences;
            StatusVariablePathFilter filter = new StatusVariablePathFilter(path);
            TreeSet<String> paths = new TreeSet<String>();
            for (ServiceReference monitorableReference : monitorableReferences = this.common.getMonitorableReferences(filter.getMonitorableIdFilter())) {
                String[] statusVariableNames;
                String pid = (String)monitorableReference.getProperty("service.pid");
                for (String statusVariableName : statusVariableNames = this.common.getStatusVariableNames(pid)) {
                    if (!filter.match(pid, statusVariableName)) continue;
                    this.checkPermissions(new StatusVariablePath(pid, statusVariableName), monitorableReference, "publish", "switchevents");
                    paths.add(String.format("%s/%s", pid, statusVariableName));
                }
            }
            if (paths.isEmpty()) {
                throw new IllegalArgumentException(String.format("%s does not point any existing StatusVariables", path));
            }
            this.common.switchEvents(paths, on);
        }
        finally {
            this.logVisitor.debug("EXIT: switchEvents: " + path + ", " + on, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MonitoringJob startScheduledJob(String initiator, String[] statusVariables, int schedule, int count) throws IllegalArgumentException, SecurityException {
        this.logVisitor.debug("ENTRY: startScheduledJob: " + initiator, null);
        try {
            if (initiator == null) {
                throw new IllegalArgumentException("Initiator is null");
            }
            if (statusVariables == null) {
                throw new IllegalArgumentException("StatusVariables are null");
            }
            if (schedule <= 0) {
                throw new IllegalArgumentException("Schedule is invalid: " + count);
            }
            if (count < 0) {
                throw new IllegalArgumentException("Count is invalid: " + count);
            }
            for (String path : statusVariables) {
                StatusVariablePath statusVariablePath = new StatusVariablePath(path);
                ServiceReference monitorableReference = this.common.findMonitorableReferenceById(statusVariablePath.getMonitorableId());
                String pid = (String)monitorableReference.getProperty("service.pid");
                this.checkPermissions(new StatusVariablePath(pid, statusVariablePath.getStatusVariableId()), monitorableReference, "publish", String.format(STARTJOB_PERMISSION_PATTERN, schedule));
            }
            ScheduledMonitoringJob job = new ScheduledMonitoringJob(this.common, this.logVisitor, initiator, statusVariables, schedule, count);
            this.common.addJob(job);
            this.logVisitor.info("New Scheduled Job is started: " + initiator, null);
            ScheduledMonitoringJob scheduledMonitoringJob = job;
            return scheduledMonitoringJob;
        }
        finally {
            this.logVisitor.debug("EXIT: startScheduledJob: " + initiator, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MonitoringJob startJob(String initiator, String[] statusVariables, int count) throws IllegalArgumentException, SecurityException {
        this.logVisitor.debug("ENTRY: startJob: " + initiator, null);
        try {
            if (initiator == null) {
                throw new IllegalArgumentException("Initiator is null");
            }
            if (statusVariables == null) {
                throw new IllegalArgumentException("StatusVariables are null");
            }
            if (count <= 0) {
                throw new IllegalArgumentException("Count is invalid: " + count);
            }
            for (String path : statusVariables) {
                StatusVariablePath statusVariablePath = new StatusVariablePath(path);
                ServiceReference monitorableReference = this.common.findMonitorableReferenceById(statusVariablePath.getMonitorableId());
                String pid = (String)monitorableReference.getProperty("service.pid");
                if (!this.common.notifiesOnChange(monitorableReference, statusVariablePath.getStatusVariableId())) {
                    throw new IllegalArgumentException("StatusVariable: " + path + " does not support notifications");
                }
                this.checkPermissions(new StatusVariablePath(pid, statusVariablePath.getStatusVariableId()), monitorableReference, "publish", "startjob");
            }
            SubscriptionMonitoringJob job = new SubscriptionMonitoringJob(this.common, this.logVisitor, initiator, statusVariables, count);
            this.common.addJob(job);
            this.logVisitor.info("New Subscription Job is started: " + initiator, null);
            SubscriptionMonitoringJob subscriptionMonitoringJob = job;
            return subscriptionMonitoringJob;
        }
        finally {
            this.logVisitor.debug("EXIT: startJob: " + initiator, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MonitoringJob[] getRunningJobs() {
        this.logVisitor.debug("ENTRY: getRunningJobs", null);
        try {
            List<MonitoringJob> runningJobs = this.common.getRunningJobs();
            ArrayList<MonitoringJob> result = new ArrayList<MonitoringJob>();
            for (MonitoringJob runningJob : runningJobs) {
                String[] statusVariableNames = runningJob.getStatusVariableNames();
                String action = String.format(STARTJOB_PERMISSION_PATTERN, runningJob.getSchedule());
                boolean hasPermissions = true;
                if (this.consumer != null) {
                    for (String statusVariableName : statusVariableNames) {
                        if (this.consumer.hasPermission((Object)new MonitorPermission(statusVariableName, action))) continue;
                        hasPermissions = false;
                        break;
                    }
                }
                if (!hasPermissions) continue;
                result.add(runningJob);
            }
            MonitoringJob[] monitoringJobArray = result.toArray(new MonitoringJob[result.size()]);
            return monitoringJobArray;
        }
        finally {
            this.logVisitor.debug("EXIT: getRunningJobs", null);
        }
    }
}

