/*
 * Decompiled with CFR 0.152.
 */
package org.knowhowlab.osgi.monitoradmin.job;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.knowhowlab.osgi.monitoradmin.LogVisitor;
import org.knowhowlab.osgi.monitoradmin.job.MonitoringJobVisitor;
import org.osgi.service.monitor.MonitoringJob;
import org.osgi.service.monitor.StatusVariable;

public abstract class AbstractMonitoringJob
implements MonitoringJob {
    MonitoringJobVisitor visitor;
    LogVisitor logVisitor;
    private String initiator;
    Set<String> statusVariablePaths = new HashSet<String>();
    boolean isRunning;
    int schedule = 0;
    int count = 0;

    AbstractMonitoringJob(MonitoringJobVisitor visitor, LogVisitor logVisitor, String initiator, String[] statusVariablePaths, int schedule, int count) {
        this.visitor = visitor;
        this.logVisitor = logVisitor;
        this.initiator = initiator;
        this.statusVariablePaths.addAll(Arrays.asList(statusVariablePaths));
        this.schedule = schedule;
        this.count = count;
        this.isRunning = true;
    }

    AbstractMonitoringJob(MonitoringJobVisitor visitor, LogVisitor logVisitor, String initiator, String[] statusVariablePaths, int count) {
        this.visitor = visitor;
        this.logVisitor = logVisitor;
        this.initiator = initiator;
        this.statusVariablePaths.addAll(Arrays.asList(statusVariablePaths));
        this.count = count;
        this.isRunning = true;
    }

    @Override
    public synchronized void stop() {
        if (this.isRunning) {
            this.isRunning = false;
            this.visitor.cancelJob(this);
        }
    }

    @Override
    public String getInitiator() {
        return this.initiator;
    }

    @Override
    public String[] getStatusVariableNames() {
        return this.statusVariablePaths.toArray(new String[this.statusVariablePaths.size()]);
    }

    @Override
    public int getSchedule() {
        return this.schedule;
    }

    @Override
    public int getReportCount() {
        return this.count;
    }

    @Override
    public boolean isLocal() {
        return true;
    }

    @Override
    public boolean isRunning() {
        return this.isRunning;
    }

    public abstract void cancel();

    public abstract boolean isHandleUpdateEvent(String var1);

    public abstract void handleUpdateEvent(String var1, StatusVariable var2);

    public String toString() {
        return String.format("%s{{initiator='%s', statusVariablePaths=%s, schedule=%s, count=%s}", this.getClass().getSimpleName(), this.initiator, this.statusVariablePaths, this.schedule, this.count);
    }
}

