/*
 * Decompiled with CFR 0.152.
 */
package org.knowhowlab.osgi.monitoradmin.job;

import java.util.HashMap;
import java.util.Map;
import org.knowhowlab.osgi.monitoradmin.LogVisitor;
import org.knowhowlab.osgi.monitoradmin.job.AbstractMonitoringJob;
import org.knowhowlab.osgi.monitoradmin.job.MonitoringJobVisitor;
import org.knowhowlab.osgi.monitoradmin.util.StatusVariablePath;
import org.osgi.service.monitor.StatusVariable;

public class SubscriptionMonitoringJob
extends AbstractMonitoringJob {
    private Map<String, Integer> countStatesMap = new HashMap<String, Integer>();

    public SubscriptionMonitoringJob(MonitoringJobVisitor visitor, LogVisitor logVisitor, String initiator, String[] statusVariablePaths, int count) {
        super(visitor, logVisitor, initiator, statusVariablePaths, count);
        for (String statusVariablePath : statusVariablePaths) {
            this.countStatesMap.put(statusVariablePath, 0);
        }
    }

    @Override
    public void cancel() {
        this.isRunning = false;
        this.logVisitor.info("Job Canceled: " + this, null);
    }

    @Override
    public boolean isHandleUpdateEvent(String path) {
        return this.isRunning() && this.statusVariablePaths.contains(path);
    }

    @Override
    public void handleUpdateEvent(String monitorableId, StatusVariable statusVariable) {
        StatusVariablePath path = new StatusVariablePath(monitorableId, statusVariable.getID());
        int statusVariableChangesCount = this.countStatesMap.get(path.getPath());
        if (statusVariableChangesCount + 1 == this.count) {
            this.visitor.fireEvent(monitorableId, statusVariable, this.getInitiator());
            this.countStatesMap.put(path.getPath(), 0);
        } else {
            this.countStatesMap.put(path.getPath(), statusVariableChangesCount + 1);
        }
    }
}

