/*
 * Decompiled with CFR 0.152.
 */
package org.knowhowlab.osgi.monitoradmin.util;

import org.knowhowlab.osgi.monitoradmin.util.Utils;

public class StatusVariablePath {
    protected String monitorableId;
    String statusVariableId;
    protected String path;

    public StatusVariablePath(String path) throws IllegalArgumentException {
        String[] ids = this.parseIds(path);
        this.path = path;
        this.monitorableId = ids[0];
        this.statusVariableId = ids[1];
    }

    public StatusVariablePath(String monitorableId, String statusVariableId) throws IllegalArgumentException {
        if (monitorableId == null) {
            throw new IllegalArgumentException("MonitorableId is null");
        }
        if (statusVariableId == null) {
            throw new IllegalArgumentException("StatusVariableId is null");
        }
        if (!this.validateId(monitorableId)) {
            throw new IllegalArgumentException("MonitorableId is invalid");
        }
        if (!this.validateId(statusVariableId)) {
            throw new IllegalArgumentException("StatusVariableId is invalid");
        }
        this.monitorableId = monitorableId;
        this.statusVariableId = statusVariableId;
        this.path = this.monitorableId + '/' + this.statusVariableId;
    }

    public StatusVariablePath() {
    }

    public String getMonitorableId() {
        return this.monitorableId;
    }

    public String getStatusVariableId() {
        return this.statusVariableId;
    }

    public String getPath() {
        return this.path;
    }

    String[] parseIds(String path) throws IllegalArgumentException {
        if (path == null) {
            throw new IllegalArgumentException("Path is null");
        }
        String[] parts = path.split("/");
        if (parts.length != 2 || !this.validateId(parts[0]) || !this.validateId(parts[1])) {
            throw new IllegalArgumentException("Path value is invalid: " + path);
        }
        return parts;
    }

    protected boolean validateId(String id) {
        return Utils.validatePathId(id);
    }
}

