/*
 * Decompiled with CFR 0.152.
 */
package org.knowhowlab.osgi.monitoradmin.util;

import java.util.regex.Pattern;

public class Utils {
    private static final Pattern PATH_ID_VALIDATE_PATTERN = Pattern.compile("((\\w|_|-)+)(\\.(\\w|_|-)+)*");
    private static final Pattern FILTER_ID_VALIDATE_PATTERN = Pattern.compile("(\\*)|(((\\w|_|-)+)(\\.(\\w|_|-)*)*)(\\*)?");

    public static String createServicePidFilter(String monitorableId) {
        return String.format("(%s=%s)", "service.pid", monitorableId);
    }

    public static boolean validatePathId(String id) {
        return PATH_ID_VALIDATE_PATTERN.matcher(id).matches();
    }

    static boolean validatePathFilterId(String id) {
        return FILTER_ID_VALIDATE_PATTERN.matcher(id).matches();
    }
}

