/*
 * Decompiled with CFR 0.152.
 */
package org.knowhowlab.osgi.networkadapter;

import java.net.NetworkInterface;
import java.util.Collections;
import java.util.Optional;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.knowhowlab.osgi.networkadapter.NetworkServicesRegistrationManager;
import org.knowhowlab.osgi.networkadapter.registry.IPRegistry;
import org.knowhowlab.osgi.networkadapter.utils.Functions;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;

public class Activator
implements BundleActivator {
    private static final String REFRESH_DELAY_PROPERTY = "org.knowhowlab.osgi.networkadapter.refresh_delay";
    private static final String REFRESH_DELAY_DEFAULT = String.valueOf(TimeUnit.SECONDS.toMillis(5L));
    private ScheduledExecutorService pool;
    private NetworkServicesRegistrationManager registrationManager;

    public void start(BundleContext bc) throws Exception {
        this.registrationManager = new NetworkServicesRegistrationManager((arg_0, arg_1, arg_2) -> ((BundleContext)bc).registerService(arg_0, arg_1, arg_2), (arg_0, arg_1, arg_2) -> ((BundleContext)bc).registerService(arg_0, arg_1, arg_2), IPRegistry.rfc6890());
        long refreshDelay = Long.parseLong(Optional.ofNullable(bc.getProperty(REFRESH_DELAY_PROPERTY)).orElse(REFRESH_DELAY_DEFAULT));
        this.pool = Executors.newScheduledThreadPool(0);
        this.pool.scheduleWithFixedDelay(new NetworkMonitor(), 0L, refreshDelay, TimeUnit.MILLISECONDS);
    }

    public void stop(BundleContext bc) throws Exception {
        this.pool.shutdownNow();
        this.registrationManager.close();
    }

    private class NetworkMonitor
    implements Runnable {
        private NetworkMonitor() {
        }

        @Override
        public void run() {
            Activator.this.registrationManager.updateServices(Collections.list(Functions.ofThrowable(NetworkInterface::getNetworkInterfaces).orElseGet(Collections::emptyEnumeration)));
        }
    }
}

