/*
 * Decompiled with CFR 0.152.
 */
package org.knowhowlab.osgi.networkadapter;

import java.net.InterfaceAddress;
import java.net.NetworkInterface;
import java.util.Collections;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.knowhowlab.osgi.networkadapter.impl.NetworkAdapterImpl;
import org.knowhowlab.osgi.networkadapter.impl.NetworkAddressImpl;
import org.knowhowlab.osgi.networkadapter.registry.IPRegistry;
import org.knowhowlab.osgi.networkadapter.utils.Functions;
import org.knowhowlab.osgi.networkadapter.utils.PropertiesCollector;
import org.knowhowlab.osgi.networkadapter.utils.RegistrationManager;
import org.knowhowlab.osgi.networkadapter.utils.Utils;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.networkadapter.NetworkAdapter;
import org.osgi.service.networkadapter.NetworkAddress;

class NetworkServicesRegistrationManager {
    private Functions.TriFunction<Class<NetworkAddress>, NetworkAddressImpl, Dictionary, ServiceRegistration<NetworkAddress>> addressRegistrationFunction;
    private IPRegistry ipRegistry;
    private RegistrationManager<NetworkInterface, NetworkAdapter, NetworkAdapterImpl> networkInterfaceRegistrationManager;
    private Map<String, RegistrationManager<InterfaceAddress, NetworkAddress, NetworkAddressImpl>> interfaceAddressRegistrationManagers = new HashMap<String, RegistrationManager<InterfaceAddress, NetworkAddress, NetworkAddressImpl>>();

    NetworkServicesRegistrationManager(Functions.TriFunction<Class<NetworkAdapter>, NetworkAdapterImpl, Dictionary, ServiceRegistration<NetworkAdapter>> adapterRegistrationFunction, Functions.TriFunction<Class<NetworkAddress>, NetworkAddressImpl, Dictionary, ServiceRegistration<NetworkAddress>> addressRegistrationFunction, IPRegistry ipRegistry) {
        this.addressRegistrationFunction = addressRegistrationFunction;
        this.ipRegistry = ipRegistry;
        this.networkInterfaceRegistrationManager = this.createNetworkInterfaceManager(adapterRegistrationFunction);
    }

    void updateServices(List<NetworkInterface> networkInterfaces) {
        this.networkInterfaceRegistrationManager.updateServices(networkInterfaces);
    }

    void close() {
        this.updateServices(Collections.emptyList());
    }

    private RegistrationManager<NetworkInterface, NetworkAdapter, NetworkAdapterImpl> createNetworkInterfaceManager(Functions.TriFunction<Class<NetworkAdapter>, NetworkAdapterImpl, Dictionary, ServiceRegistration<NetworkAdapter>> registrationTriFunction) {
        return new RegistrationManager.Builder(NetworkAdapter.class).withRegistrationFunction(registrationTriFunction).withIdFunction(NetworkInterface::getName).withNewInstanceFunction(NetworkAdapterImpl::new).withPropertiesCollector(new PropertiesCollector.Builder<NetworkInterface>().addProperty("networkAdapter.type", t -> this.ipRegistry.getType(Utils.getAddressForRegistry(t))).addProperty("networkAdapter.hardwareAddress", NetworkInterface::getHardwareAddress, NetworkAdapter.EMPTY_BYTE_ARRAY).addProperty("networkAdapter.name", NetworkInterface::getName).addProperty("networkAdapter.displayName", NetworkInterface::getDisplayName, "").addProperty("networkAdapter.isUp", NetworkInterface::isUp, false).addProperty("networkAdapter.isLoopback", NetworkInterface::isLoopback, false).addProperty("networkAdapter.isPointToPoint", NetworkInterface::isPointToPoint, false).addProperty("networkAdapter.isVirtual", NetworkInterface::isVirtual, false).addProperty("networkAdapter.supportsMulticast", NetworkInterface::supportsMulticast, false).addProperty("networkAdapter.parent", t -> Optional.ofNullable(t.getParent()).map(Utils::pid).orElse("")).addProperty("networkAdapter.subInterface", t -> (String[])Collections.list(t.getSubInterfaces()).stream().map(Utils::pid).toArray(String[]::new)).addProperty("service.pid", Utils::pid).build()).withNewInstanceNotificationConsumer((i, a) -> {
            RegistrationManager<InterfaceAddress, NetworkAddress, NetworkAddressImpl> interfaceAddressManager = this.createInterfaceAddressManager((NetworkInterface)i, this.addressRegistrationFunction);
            this.interfaceAddressRegistrationManagers.put(a.getId(), interfaceAddressManager);
            interfaceAddressManager.updateServices(i.getInterfaceAddresses());
        }).withRemoveInstanceNotificationConsumer(a -> {
            RegistrationManager<InterfaceAddress, NetworkAddress, NetworkAddressImpl> interfaceAddressManager = this.interfaceAddressRegistrationManagers.remove(a.getId());
            interfaceAddressManager.updateServices(Collections.emptyList());
        }).withUpdateInstanceNotificationConsumer(a -> {
            RegistrationManager<InterfaceAddress, NetworkAddress, NetworkAddressImpl> interfaceAddressManager = this.interfaceAddressRegistrationManagers.get(a.getId());
            interfaceAddressManager.updateServices(a.getInterfaceAddresses());
        }).build();
    }

    private RegistrationManager<InterfaceAddress, NetworkAddress, NetworkAddressImpl> createInterfaceAddressManager(NetworkInterface networkInterface, Functions.TriFunction<Class<NetworkAddress>, NetworkAddressImpl, Dictionary, ServiceRegistration<NetworkAddress>> registrationTriFunction) {
        return new RegistrationManager.Builder(NetworkAddress.class).withRegistrationFunction(registrationTriFunction).withIdFunction(t -> t.getAddress().getHostAddress()).withNewInstanceFunction(NetworkAddressImpl::new).withPropertiesCollector(new PropertiesCollector.Builder<InterfaceAddress>().addProperty("networkAdapter.type", t -> this.ipRegistry.getType(Utils.getAddressForRegistry(networkInterface))).addProperty("ipAddress.version", t -> Utils.isIPv4(t.getAddress()) ? "IPV4" : "IPV6").addProperty("ipAddress.scope", t -> this.ipRegistry.getScope(t.getAddress())).addProperty("ipAddress", t -> t.getAddress().getHostAddress()).addProperty("subnetmask.length", InterfaceAddress::getNetworkPrefixLength).addProperty("networkAdapter.pid", t -> Utils.pid(networkInterface)).addProperty("service.pid", Utils::pid).build()).build();
    }
}

