/*
 * Decompiled with CFR 0.152.
 */
package org.knowhowlab.osgi.networkadapter.impl;

import java.net.InterfaceAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.List;
import java.util.Map;
import org.knowhowlab.osgi.networkadapter.impl.AbstractInstance;
import org.knowhowlab.osgi.networkadapter.utils.Functions;
import org.osgi.service.networkadapter.NetworkAdapter;

public class NetworkAdapterImpl
extends AbstractInstance<NetworkInterface>
implements NetworkAdapter {
    public NetworkAdapterImpl(NetworkInterface networkInterface, Map<String, Object> properties) {
        super(networkInterface, properties);
    }

    @Override
    public String getId() {
        return this.getName();
    }

    @Override
    public String getNetworkAdapterType() {
        return Functions.cast(String.class::cast, this.properties.get("networkAdapter.type")).orElse("");
    }

    @Override
    public String getDisplayName() {
        return Functions.cast(String.class::cast, this.properties.get("networkAdapter.displayName")).orElse("");
    }

    @Override
    public String getName() {
        return Functions.cast(String.class::cast, this.properties.get("networkAdapter.name")).orElse("");
    }

    @Override
    public byte[] getHardwareAddress() {
        return Functions.cast(byte[].class::cast, this.properties.get("networkAdapter.supportsMulticast")).orElse(NetworkAdapter.EMPTY_BYTE_ARRAY);
    }

    @Override
    public int getMTU() throws SocketException {
        return ((NetworkInterface)this.source).getMTU();
    }

    @Override
    public boolean isLoopback() throws SocketException {
        return Functions.cast(Boolean.TYPE::cast, this.properties.get("networkAdapter.isLoopback")).orElse(false);
    }

    @Override
    public boolean isPointToPoint() throws SocketException {
        return Functions.cast(Boolean.TYPE::cast, this.properties.get("networkAdapter.isPointToPoint")).orElse(false);
    }

    @Override
    public boolean isUp() throws SocketException {
        return Functions.cast(Boolean.TYPE::cast, this.properties.get("networkAdapter.isUp")).orElse(false);
    }

    @Override
    public boolean isVirtual() {
        return Functions.cast(Boolean.TYPE::cast, this.properties.get("networkAdapter.isVirtual")).orElse(false);
    }

    @Override
    public boolean supportsMulticast() throws SocketException {
        return Functions.cast(Boolean.TYPE::cast, this.properties.get("networkAdapter.supportsMulticast")).orElse(false);
    }

    public List<InterfaceAddress> getInterfaceAddresses() {
        return ((NetworkInterface)this.source).getInterfaceAddresses();
    }
}

