/*
 * Decompiled with CFR 0.152.
 */
package org.knowhowlab.osgi.networkadapter.registry;

import java.net.InetAddress;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.knowhowlab.osgi.networkadapter.utils.CIDR;

public class IPRegistry {
    public static final String IPADDRESS_SCOPE_OTHER = "OTHER";
    public static final String OTHER = "OTHER";
    private Map<String, List<CIDR>> types;
    private Map<String, List<CIDR>> scopes;
    private String defaultType;
    private String defaultScope;

    public IPRegistry(Map<String, List<CIDR>> types, Map<String, List<CIDR>> scopes, String defaultType, String defaultScope) {
        this.types = types;
        this.scopes = scopes;
        this.defaultType = defaultType;
        this.defaultScope = defaultScope;
    }

    public String getType(InetAddress inetAddress) {
        return this.findKey(this.types, inetAddress, this.defaultType);
    }

    public String getScope(InetAddress inetAddress) {
        return this.findKey(this.scopes, inetAddress, this.defaultScope);
    }

    private String findKey(Map<String, List<CIDR>> map, InetAddress inetAddress, String defaultValue) {
        return map.entrySet().stream().flatMap(entry -> ((List)entry.getValue()).stream().map(cidr -> new AbstractMap.SimpleEntry(entry.getKey(), (CIDR)cidr))).filter(entry -> ((CIDR)entry.getValue()).contains(inetAddress)).map(Map.Entry::getKey).findFirst().orElse(defaultValue);
    }

    public static IPRegistry rfc6890() {
        return new Builder().defaultType("WAN").defaultScope("GLOBAL").entry("LAN", "PRIVATE_USE", "10.0.0.0/8").entry("LAN", "PRIVATE_USE", "172.16.0.0/12").entry("LAN", "PRIVATE_USE", "192.168.0.0/16").entry("OTHER", "LOOPBACK", "127.0.0.0/8").entry("OTHER", "LOOPBACK", "::1/128").entry("LAN", "LINKLOCAL", "169.254.0.0/16").entry("OTHER", "UNIQUE_LOCAL", "fc00::/7").entry("OTHER", "UNSPECIFIED", "::/128").entry("OTHER", "HOST", "0.0.0.0/8").entry("OTHER", "SHARED", "100.64.0.0/10").entry("OTHER", "LINKED_SCOPED_UNICAST", "fe80::/10").entry("OTHER", "OTHER", "192.0.0.0/24").entry("OTHER", "OTHER", "192.0.0.0/29").entry("OTHER", "OTHER", "192.0.2.0/24").entry("OTHER", "OTHER", "192.88.99.0/24").entry("OTHER", "OTHER", "198.18.0.0/15").entry("OTHER", "OTHER", "198.51.100.0/24").entry("OTHER", "OTHER", "203.0.113.0/24").entry("OTHER", "OTHER", "240.0.0.0/4").entry("OTHER", "OTHER", "255.255.255.255/32").entry("OTHER", "OTHER", "64:ff9b::/96").entry("OTHER", "OTHER", "::ffff:0:0/96").entry("OTHER", "OTHER", "100::/64").entry("OTHER", "OTHER", "2001::/23").entry("OTHER", "OTHER", "2001::/32").entry("OTHER", "OTHER", "2001:2::/48").entry("OTHER", "OTHER", "2001:db8::/32").entry("OTHER", "OTHER", "2001:10::/28").entry("OTHER", "OTHER", "2002::/16").build();
    }

    public static class Builder {
        private Map<String, List<CIDR>> types = new HashMap<String, List<CIDR>>();
        private Map<String, List<CIDR>> scopes = new HashMap<String, List<CIDR>>();
        private String defaultType;
        private String defaultScope;

        public Builder entry(String type, String scope, String cidr) {
            this.addKey(this.types, type, CIDR.of(cidr));
            this.addKey(this.scopes, scope, CIDR.of(cidr));
            return this;
        }

        public Builder defaultScope(String defaultScope) {
            this.defaultScope = defaultScope;
            return this;
        }

        public Builder defaultType(String defaultType) {
            this.defaultType = defaultType;
            return this;
        }

        private void addKey(Map<String, List<CIDR>> map, String key, CIDR cidr) {
            map.computeIfAbsent(key, k -> new ArrayList<CIDR>(Collections.singletonList(cidr)));
            map.computeIfPresent(key, (k, l) -> {
                l.add(cidr);
                return l;
            });
        }

        public IPRegistry build() {
            return new IPRegistry(this.types, this.scopes, this.defaultType, this.defaultScope);
        }
    }
}

