/*
 * Decompiled with CFR 0.152.
 */
package org.knowhowlab.osgi.networkadapter.utils;

import java.math.BigInteger;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import org.knowhowlab.osgi.networkadapter.utils.Utils;

public class CIDR {
    private InetAddress inetAddress;
    private InetAddress startAddress;
    private InetAddress endAddress;
    private final int prefixLength;
    private BigInteger start;
    private BigInteger end;

    public static CIDR of(String cidr) {
        if (cidr == null) {
            throw new NullPointerException("CIDR is null");
        }
        if (!cidr.contains("/")) {
            throw new IllegalArgumentException("Invalid CIDR format");
        }
        try {
            return new CIDR(cidr);
        }
        catch (UnknownHostException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private CIDR(String cidr) throws UnknownHostException {
        int index = cidr.indexOf("/");
        String addressPart = cidr.substring(0, index);
        String networkPart = cidr.substring(index + 1);
        this.inetAddress = InetAddress.getByName(addressPart);
        this.prefixLength = Integer.parseInt(networkPart);
        this.calculate();
    }

    private void calculate() throws UnknownHostException {
        int length = this.inetAddress.getAddress().length;
        ByteBuffer maskBuffer = ByteBuffer.allocate(length);
        if (Utils.isIPv4(this.inetAddress)) {
            maskBuffer.putInt(-1);
        } else {
            maskBuffer.putLong(-1L).putLong(-1L);
        }
        BigInteger mask = new BigInteger(1, maskBuffer.array()).not().shiftRight(this.prefixLength);
        ByteBuffer buffer = ByteBuffer.wrap(this.inetAddress.getAddress());
        BigInteger ipVal = new BigInteger(1, buffer.array());
        BigInteger startIp = ipVal.and(mask);
        BigInteger endIp = startIp.add(mask.not());
        byte[] startIpArr = this.toBytes(startIp.toByteArray(), length);
        byte[] endIpArr = this.toBytes(endIp.toByteArray(), length);
        this.startAddress = InetAddress.getByAddress(startIpArr);
        this.endAddress = InetAddress.getByAddress(endIpArr);
        this.start = new BigInteger(1, this.startAddress.getAddress());
        this.end = new BigInteger(1, this.endAddress.getAddress());
    }

    private byte[] toBytes(byte[] array, int targetSize) {
        ArrayList<Byte> newArr = new ArrayList<Byte>();
        for (int counter = 0; counter < targetSize && array.length - 1 - counter >= 0; ++counter) {
            newArr.add(0, array[array.length - 1 - counter]);
        }
        int size = newArr.size();
        for (int i = 0; i < targetSize - size; ++i) {
            newArr.add(0, (byte)0);
        }
        byte[] ret = new byte[newArr.size()];
        for (int i = 0; i < newArr.size(); ++i) {
            ret[i] = (Byte)newArr.get(i);
        }
        return ret;
    }

    public InetAddress getNetworkAddress() {
        return this.startAddress;
    }

    public InetAddress getBroadcastAddress() {
        return this.endAddress;
    }

    public boolean contains(InetAddress ipAddress) {
        BigInteger target = new BigInteger(1, ipAddress.getAddress());
        return this.start.compareTo(target) <= 0 && target.compareTo(this.end) <= 0;
    }
}

