/*
 * Decompiled with CFR 0.152.
 */
package org.knowhowlab.osgi.networkadapter.utils;

import java.util.Optional;
import java.util.function.Supplier;

public class Functions {
    public static <T> Optional<T> ofThrowable(SupplierWithException<T> supplier) {
        try {
            return Optional.ofNullable(supplier.get());
        }
        catch (Exception e) {
            return Optional.empty();
        }
    }

    public static <T, R> Optional<R> ofThrowable(FunctionWithException<T, R> function, Supplier<T> supplier) {
        try {
            return Optional.ofNullable(function.apply(supplier.get()));
        }
        catch (Exception e) {
            return Optional.empty();
        }
    }

    public static <T> Optional<T> cast(CastFunction<T> function, Object value) {
        try {
            return Optional.ofNullable(function.apply(value));
        }
        catch (Exception e) {
            return Optional.empty();
        }
    }

    @FunctionalInterface
    public static interface TriFunction<T, U, S, R> {
        public R apply(T var1, U var2, S var3);
    }

    @FunctionalInterface
    public static interface FunctionWithException<T, R> {
        public R apply(T var1) throws Exception;
    }

    @FunctionalInterface
    public static interface SupplierWithException<T> {
        public T get() throws Exception;
    }

    @FunctionalInterface
    public static interface CastFunction<T> {
        public T apply(Object var1) throws Exception;
    }
}

