/*
 * Decompiled with CFR 0.152.
 */
package org.knowhowlab.osgi.networkadapter.utils;

import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.knowhowlab.osgi.networkadapter.utils.Functions;

public class PropertiesCollector<U> {
    private Hashtable<String, Function<U, Object>> functions;

    private PropertiesCollector(Map<String, Function<U, Object>> functions) {
        this.functions = new Hashtable<String, Function<U, Object>>(functions);
    }

    public Hashtable<String, Object> collect(U instance) {
        return new Hashtable<String, Object>(this.functions.keySet().stream().collect(Collectors.toMap(Function.identity(), key -> this.functions.get(key).apply(instance))));
    }

    public static class Builder<T> {
        private Map<String, Function<T, Object>> propertyFunctions = new HashMap<String, Function<T, Object>>();

        public Builder<T> addProperty(String key, Function<T, Object> function) {
            this.propertyFunctions.put(key, function);
            return this;
        }

        public Builder<T> addProperty(String key, Functions.FunctionWithException<T, Object> function, Object defaultValue) {
            this.propertyFunctions.put(key, this.property(function, defaultValue));
            return this;
        }

        public Builder<T> addProperty(String key, Object value) {
            this.propertyFunctions.put(key, t -> value);
            return this;
        }

        public PropertiesCollector<T> build() {
            return new PropertiesCollector(this.propertyFunctions);
        }

        private <R> Function<T, R> property(Functions.FunctionWithException<T, R> function, R defaultValue) {
            return t -> {
                try {
                    return Optional.ofNullable(function.apply(t)).orElse(defaultValue);
                }
                catch (Exception e) {
                    return defaultValue;
                }
            };
        }
    }
}

