/*
 * Decompiled with CFR 0.152.
 */
package org.knowhowlab.osgi.networkadapter.utils;

import java.util.Collections;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.knowhowlab.osgi.networkadapter.impl.AbstractInstance;
import org.knowhowlab.osgi.networkadapter.utils.CompareUtils;
import org.knowhowlab.osgi.networkadapter.utils.Functions;
import org.knowhowlab.osgi.networkadapter.utils.PropertiesCollector;
import org.osgi.dto.DTO;
import org.osgi.framework.ServiceRegistration;

public class RegistrationManager<T, R, U extends AbstractInstance> {
    private Map<String, RegistrationDTO<R, U>> registrations = new HashMap<String, RegistrationDTO<R, U>>();
    private Class<R> registrationClass;
    private PropertiesCollector<T> propertiesCollector;
    private Function<T, String> idFunction;
    private BiFunction<T, Map<String, Object>, U> newInstanceFunction;
    private Functions.TriFunction<Class<R>, U, Dictionary, ServiceRegistration<R>> registrationFunction;
    private BiConsumer<T, U> newInstanceNotificationConsumer;
    private Consumer<U> removeInstanceNotificationConsumer;
    private Consumer<U> updateInstanceNotificationConsumer;

    private RegistrationManager(Class<R> registrationClass, PropertiesCollector<T> propertiesCollector, Function<T, String> idFunction, BiFunction<T, Map<String, Object>, U> newInstanceFunction, Functions.TriFunction<Class<R>, U, Dictionary, ServiceRegistration<R>> registrationFunction, BiConsumer<T, U> newInstanceNotificationConsumer, Consumer<U> removeInstanceNotificationConsumer, Consumer<U> updateInstanceNotificationConsumer) {
        this.registrationClass = registrationClass;
        this.propertiesCollector = propertiesCollector;
        this.idFunction = idFunction;
        this.newInstanceFunction = newInstanceFunction;
        this.registrationFunction = registrationFunction;
        this.newInstanceNotificationConsumer = newInstanceNotificationConsumer;
        this.removeInstanceNotificationConsumer = removeInstanceNotificationConsumer;
        this.updateInstanceNotificationConsumer = updateInstanceNotificationConsumer;
    }

    public void updateServices(List<T> instances) {
        Map actualSources = instances.stream().collect(Collectors.toMap(this.idFunction, Function.identity()));
        this.unregisterObsoleteServices(actualSources);
        this.registerNewServices(actualSources);
        this.updateExistingServices(actualSources);
    }

    public void close() {
        this.updateServices(Collections.emptyList());
    }

    Map<String, RegistrationDTO<R, U>> getRegistrations() {
        return this.registrations;
    }

    private void updateExistingServices(Map<String, T> actualInstances) {
        HashSet<String> candidatesToUpdate = new HashSet<String>(actualInstances.keySet());
        candidatesToUpdate.retainAll(this.registrations.keySet());
        candidatesToUpdate.stream().map(actualInstances::get).map(this.propertiesCollector::collect).filter(m -> !CompareUtils.deepEquals(m, this.registrations.get(m.get((Object)"service.pid")).properties)).forEach(m -> {
            RegistrationDTO<R, U> dto = this.registrations.get(m.get("service.pid"));
            dto.serviceRegistration.setProperties((Dictionary)m);
            dto.properties.clear();
            dto.properties.putAll((Map<String, Object>)m);
            this.updateInstanceNotificationConsumer.accept(dto.instance);
        });
    }

    private void registerNewServices(Map<String, T> actualInstances) {
        HashSet<String> candidatesToRegister = new HashSet<String>(actualInstances.keySet());
        candidatesToRegister.removeAll(this.registrations.keySet());
        candidatesToRegister.stream().map(actualInstances::remove).map(source -> {
            Hashtable<String, Object> props = this.propertiesCollector.collect(source);
            AbstractInstance newInstance = (AbstractInstance)this.newInstanceFunction.apply(source, props);
            this.newInstanceNotificationConsumer.accept(source, newInstance);
            ServiceRegistration<R> registration = this.registrationFunction.apply(this.registrationClass, newInstance, props);
            return new RegistrationDTO<R, AbstractInstance>(newInstance, registration, props);
        }).forEach(r -> this.registrations.put(((AbstractInstance)r.instance).getId(), (RegistrationDTO<R, U>)((Object)r)));
    }

    private void unregisterObsoleteServices(Map<String, T> actualInstances) {
        HashSet<String> candidatesToUnregister = new HashSet<String>(this.registrations.keySet());
        candidatesToUnregister.removeAll(actualInstances.keySet());
        candidatesToUnregister.stream().map(this.registrations::remove).forEach(r -> {
            this.removeInstanceNotificationConsumer.accept(r.instance);
            r.serviceRegistration.unregister();
        });
    }

    static class RegistrationDTO<T, U extends AbstractInstance>
    extends DTO {
        final U instance;
        final ServiceRegistration<T> serviceRegistration;
        final Hashtable<String, Object> properties;

        RegistrationDTO(U instance, ServiceRegistration<T> serviceRegistration, Hashtable<String, Object> properties) {
            this.instance = instance;
            this.serviceRegistration = serviceRegistration;
            this.properties = properties;
        }
    }

    public static class Builder<T, R, U extends AbstractInstance> {
        private Functions.TriFunction<Class<R>, U, Dictionary, ServiceRegistration<R>> registrationFunction;
        private PropertiesCollector<T> propertiesCollector;
        private Function<T, String> idFunction;
        private BiFunction<T, Map<String, Object>, U> newInstanceFunction;
        private Class<R> registrationClass;
        private BiConsumer<T, U> newInstanceNotificationConsumer = (t, u) -> {};
        private Consumer<U> removeInstanceNotificationConsumer = u -> {};
        private Consumer<U> updateInstanceNotificationConsumer = u -> {};

        public Builder(Class<R> registrationClass) {
            this.registrationClass = registrationClass;
        }

        public Builder<T, R, U> withRegistrationFunction(Functions.TriFunction<Class<R>, U, Dictionary, ServiceRegistration<R>> registrationFunction) {
            this.registrationFunction = registrationFunction;
            return this;
        }

        public Builder<T, R, U> withPropertiesCollector(PropertiesCollector<T> propertiesCollector) {
            this.propertiesCollector = propertiesCollector;
            return this;
        }

        public Builder<T, R, U> withIdFunction(Function<T, String> idFunction) {
            this.idFunction = idFunction;
            return this;
        }

        public Builder<T, R, U> withNewInstanceFunction(BiFunction<T, Map<String, Object>, U> newInstanceFunction) {
            this.newInstanceFunction = newInstanceFunction;
            return this;
        }

        public Builder<T, R, U> withNewInstanceNotificationConsumer(BiConsumer<T, U> newInstanceNotificationConsumer) {
            this.newInstanceNotificationConsumer = newInstanceNotificationConsumer;
            return this;
        }

        public Builder<T, R, U> withRemoveInstanceNotificationConsumer(Consumer<U> removeInstanceNotificationConsumer) {
            this.removeInstanceNotificationConsumer = removeInstanceNotificationConsumer;
            return this;
        }

        public Builder<T, R, U> withUpdateInstanceNotificationConsumer(Consumer<U> updateInstanceNotificationConsumer) {
            this.updateInstanceNotificationConsumer = updateInstanceNotificationConsumer;
            return this;
        }

        public RegistrationManager<T, R, U> build() {
            return new RegistrationManager(this.registrationClass, this.propertiesCollector, this.idFunction, this.newInstanceFunction, this.registrationFunction, this.newInstanceNotificationConsumer, this.removeInstanceNotificationConsumer, this.updateInstanceNotificationConsumer);
        }
    }
}

