/*
 * Decompiled with CFR 0.152.
 */
package org.knowhowlab.osgi.testing.assertions;

import java.util.concurrent.TimeUnit;
import org.hamcrest.CoreMatchers;
import org.hamcrest.MatcherAssert;
import org.knowhowlab.osgi.testing.assertions.OSGiAssert;
import org.knowhowlab.osgi.testing.utils.BundleUtils;
import org.knowhowlab.osgi.testing.utils.ServiceUtils;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.Version;
import org.osgi.service.packageadmin.PackageAdmin;

public class BundleAssert
extends OSGiAssert {
    private BundleAssert() {
    }

    public static void assertBundleState(int state, long bundleId) {
        BundleAssert.assertBundleState(String.format("Invalid state of bundle: %s", bundleId), state, bundleId);
    }

    public static void assertBundleState(String message, int state, long bundleId) {
        Bundle bundle = BundleUtils.findBundle(BundleAssert.getBundleContext(), bundleId);
        MatcherAssert.assertThat(String.format("Unknown bundle with ID: %d", bundleId), bundle, CoreMatchers.notNullValue());
        MatcherAssert.assertThat(message, bundle.getState(), CoreMatchers.equalTo(state));
    }

    public static void assertBundleState(int state, String symbolicName) {
        BundleAssert.assertBundleState(String.format("Invalid state of bundle: %s", symbolicName), state, symbolicName);
    }

    public static void assertBundleState(int state, String symbolicName, long timeoutInMillis) {
        BundleAssert.assertBundleState(String.format("Invalid state %s of bundle: %s within timeout: %sms", state, symbolicName, timeoutInMillis), state, symbolicName, null, timeoutInMillis, TimeUnit.MILLISECONDS);
    }

    public static void assertBundleState(String message, int stateMask, String symbolicName, long timeoutInMillis) {
        BundleAssert.assertBundleState(message, stateMask, symbolicName, null, timeoutInMillis, TimeUnit.MILLISECONDS);
    }

    public static void assertBundleState(String message, int stateMask, String symbolicName, long timeout, TimeUnit timeUnit) {
        BundleAssert.assertBundleState(message, stateMask, symbolicName, null, timeout, timeUnit);
    }

    public static void assertBundleState(String message, int state, String symbolicName) {
        MatcherAssert.assertThat("SymbolicName is null", symbolicName, CoreMatchers.notNullValue());
        Bundle bundle = BundleUtils.findBundle(BundleAssert.getBundleContext(), symbolicName);
        MatcherAssert.assertThat(String.format("Unknown bundle with SymbolicName: %s", symbolicName), bundle, CoreMatchers.notNullValue());
        MatcherAssert.assertThat(message, bundle.getState(), CoreMatchers.equalTo(state));
    }

    public static void assertBundleState(String message, int stateMask, String symbolicName, Version version, long timeout, TimeUnit timeUnit) {
        MatcherAssert.assertThat("SymbolicName is null", symbolicName, CoreMatchers.notNullValue());
        MatcherAssert.assertThat("TimeUnit is null", timeUnit, CoreMatchers.notNullValue());
        Bundle bundle = BundleUtils.findBundle(BundleAssert.getBundleContext(), symbolicName, version, stateMask, timeout, timeUnit);
        MatcherAssert.assertThat(message, bundle, CoreMatchers.notNullValue());
    }

    public static void assertBundleState(int state, String symbolicName, Version version) {
        BundleAssert.assertBundleState(String.format("Invalid state of bundle: %s[%s]", symbolicName, version), state, symbolicName, version);
    }

    public static void assertBundleState(int stateMask, String symbolicName, Version version, long timeout, TimeUnit timeUnit) {
        BundleAssert.assertBundleState(String.format("Invalid state %s of bundle: %s[%s] within timeout: %s%s", new Object[]{stateMask, symbolicName, version, timeout, timeUnit}), stateMask, symbolicName, version, timeout, timeUnit);
    }

    public static void assertBundleState(int stateMask, String symbolicName, long timeout, TimeUnit timeUnit) {
        BundleAssert.assertBundleState(String.format("Invalid state %s of bundle: %s within timeout: %s%s", new Object[]{stateMask, symbolicName, timeout, timeUnit}), stateMask, symbolicName, null, timeout, timeUnit);
    }

    public static void assertBundleState(String message, int state, String symbolicName, Version version) {
        MatcherAssert.assertThat("SymbolicName is null", symbolicName, CoreMatchers.notNullValue());
        Bundle bundle = BundleUtils.findBundle(BundleAssert.getBundleContext(), symbolicName, version);
        MatcherAssert.assertThat(String.format("Unknown bundle with SymbolicName: %s and version: %s", symbolicName, version), bundle, CoreMatchers.notNullValue());
        MatcherAssert.assertThat(message, bundle.getState(), CoreMatchers.equalTo(state));
    }

    public static void assertBundleAvailable(long bundleId) {
        BundleAssert.assertBundleAvailable(String.format("Bundle: %s is unavailable", bundleId), bundleId);
    }

    public static void assertBundleAvailable(String message, long bundleId) {
        Bundle bundle = BundleUtils.findBundle(BundleAssert.getBundleContext(), bundleId);
        MatcherAssert.assertThat(message, bundle, CoreMatchers.notNullValue());
    }

    public static void assertBundleAvailable(String symbolicName) {
        BundleAssert.assertBundleAvailable(String.format("Bundle: %s is unavailable", symbolicName), symbolicName);
    }

    public static void assertBundleAvailable(String message, String symbolicName) {
        MatcherAssert.assertThat("SymbolicName is null", symbolicName, CoreMatchers.notNullValue());
        Bundle bundle = BundleUtils.findBundle(BundleAssert.getBundleContext(), symbolicName);
        MatcherAssert.assertThat(message, bundle, CoreMatchers.notNullValue());
    }

    public static void assertBundleAvailable(String symbolicName, Version version) {
        BundleAssert.assertBundleAvailable(String.format("Bundle: %s[%s] is unavailable", symbolicName, version), symbolicName, version);
    }

    public static void assertBundleAvailable(String message, String symbolicName, Version version) {
        MatcherAssert.assertThat("SymbolicName is null", symbolicName, CoreMatchers.notNullValue());
        Bundle bundle = BundleUtils.findBundle(BundleAssert.getBundleContext(), symbolicName, version);
        MatcherAssert.assertThat(message, bundle, CoreMatchers.notNullValue());
    }

    public static void assertBundleUnavailable(long bundleId) {
        BundleAssert.assertBundleUnavailable(String.format("Bundle: %s is available", bundleId), bundleId);
    }

    public static void assertBundleUnavailable(String message, long bundleId) {
        Bundle bundle = BundleUtils.findBundle(BundleAssert.getBundleContext(), bundleId);
        MatcherAssert.assertThat(message, bundle, CoreMatchers.nullValue());
    }

    public static void assertBundleUnavailable(String symbolicName) {
        BundleAssert.assertBundleUnavailable(String.format("Bundle: %s is available", symbolicName), symbolicName);
    }

    public static void assertBundleUnavailable(String message, String symbolicName) {
        MatcherAssert.assertThat("SymbolicName is null", symbolicName, CoreMatchers.notNullValue());
        Bundle bundle = BundleUtils.findBundle(BundleAssert.getBundleContext(), symbolicName);
        MatcherAssert.assertThat(message, bundle, CoreMatchers.nullValue());
    }

    public static void assertBundleUnavailable(String symbolicName, Version version) {
        BundleAssert.assertBundleUnavailable(String.format("Bundle: %s[%s] is available", symbolicName, version), symbolicName, version);
    }

    public static void assertBundleUnavailable(String message, String symbolicName, Version version) {
        MatcherAssert.assertThat("SymbolicName is null", symbolicName, CoreMatchers.notNullValue());
        Bundle bundle = BundleUtils.findBundle(BundleAssert.getBundleContext(), symbolicName, version);
        MatcherAssert.assertThat(message, bundle, CoreMatchers.nullValue());
    }

    public static void assertFragment(long bundleId) {
        BundleAssert.assertFragment(String.format("Bundle: %s is not a fragment", bundleId), bundleId);
    }

    public static void assertFragment(String message, long bundleId) {
        Bundle bundle = BundleUtils.findBundle(BundleAssert.getBundleContext(), bundleId);
        MatcherAssert.assertThat(String.format("Unknown bundle with ID: %d", bundleId), bundle, CoreMatchers.notNullValue());
        PackageAdmin packageAdmin = ServiceUtils.getService(BundleAssert.getBundleContext(), PackageAdmin.class);
        MatcherAssert.assertThat("PackageAdmin is unavailable", packageAdmin, CoreMatchers.notNullValue());
        int type = packageAdmin.getBundleType(bundle);
        MatcherAssert.assertThat(message, type & 1, CoreMatchers.is(CoreMatchers.not(0)));
    }

    public static void assertFragment(String symbolicName) {
        BundleAssert.assertFragment(String.format("Bundle: %s is not a fragment", symbolicName), symbolicName);
    }

    public static void assertFragment(String message, String symbolicName) {
        MatcherAssert.assertThat("SymbolicName is null", symbolicName, CoreMatchers.notNullValue());
        Bundle bundle = BundleUtils.findBundle(BundleAssert.getBundleContext(), symbolicName);
        MatcherAssert.assertThat(String.format("Unknown bundle with SymbolicName: %s", symbolicName), bundle, CoreMatchers.notNullValue());
        PackageAdmin packageAdmin = ServiceUtils.getService(BundleAssert.getBundleContext(), PackageAdmin.class);
        MatcherAssert.assertThat("PackageAdmin is unavailable", packageAdmin, CoreMatchers.notNullValue());
        int type = packageAdmin.getBundleType(bundle);
        MatcherAssert.assertThat(message, type & 1, CoreMatchers.is(CoreMatchers.not(0)));
    }

    public static void assertFragment(String symbolicName, Version version) {
        BundleAssert.assertFragment(String.format("Bundle: %s[%s] is not a fragment", symbolicName, version), symbolicName, version);
    }

    public static void assertFragment(String message, String symbolicName, Version version) {
        MatcherAssert.assertThat("SymbolicName is null", symbolicName, CoreMatchers.notNullValue());
        Bundle bundle = BundleUtils.findBundle(BundleAssert.getBundleContext(), symbolicName, version);
        MatcherAssert.assertThat(String.format("Unknown bundle with SymbolicName: %s and version: %s", symbolicName, version), bundle, CoreMatchers.notNullValue());
        PackageAdmin packageAdmin = ServiceUtils.getService(BundleAssert.getBundleContext(), PackageAdmin.class);
        MatcherAssert.assertThat("PackageAdmin is unavailable", packageAdmin, CoreMatchers.notNullValue());
        int type = packageAdmin.getBundleType(bundle);
        MatcherAssert.assertThat(message, type & 1, CoreMatchers.is(CoreMatchers.not(0)));
    }

    public static void assertNotFragment(long bundleId) {
        BundleAssert.assertNotFragment(String.format("Bundle: %s is a fragment", bundleId), bundleId);
    }

    public static void assertNotFragment(String message, long bundleId) {
        Bundle bundle = BundleUtils.findBundle(BundleAssert.getBundleContext(), bundleId);
        MatcherAssert.assertThat(String.format("Unknown bundle with ID: %d", bundleId), bundle, CoreMatchers.notNullValue());
        PackageAdmin packageAdmin = ServiceUtils.getService(BundleAssert.getBundleContext(), PackageAdmin.class);
        MatcherAssert.assertThat("PackageAdmin is unavailable", packageAdmin, CoreMatchers.notNullValue());
        int type = packageAdmin.getBundleType(bundle);
        MatcherAssert.assertThat(message, type & 1, CoreMatchers.is(CoreMatchers.not(0)));
    }

    public static void assertNotFragment(String symbolicName) {
        BundleAssert.assertNotFragment(String.format("Bundle: %s is a fragment", symbolicName), symbolicName);
    }

    public static void assertNotFragment(String message, String symbolicName) {
        MatcherAssert.assertThat("SymbolicName is null", symbolicName, CoreMatchers.notNullValue());
        Bundle bundle = BundleUtils.findBundle(BundleAssert.getBundleContext(), symbolicName);
        MatcherAssert.assertThat(String.format("Unknown bundle with SymbolicName: %s", symbolicName), bundle, CoreMatchers.notNullValue());
        PackageAdmin packageAdmin = ServiceUtils.getService(BundleAssert.getBundleContext(), PackageAdmin.class);
        MatcherAssert.assertThat("PackageAdmin is unavailable", packageAdmin, CoreMatchers.notNullValue());
        int type = packageAdmin.getBundleType(bundle);
        MatcherAssert.assertThat(message, type & 1, CoreMatchers.is(CoreMatchers.not(0)));
    }

    public static void assertNotFragment(String symbolicName, Version version) {
        BundleAssert.assertNotFragment(String.format("Bundle: %s[%s] is a fragment", symbolicName, version), symbolicName, version);
    }

    public static void assertNotFragment(String message, String symbolicName, Version version) {
        MatcherAssert.assertThat("SymbolicName is null", symbolicName, CoreMatchers.notNullValue());
        Bundle bundle = BundleUtils.findBundle(BundleAssert.getBundleContext(), symbolicName, version);
        MatcherAssert.assertThat(String.format("Unknown bundle with SymbolicName: %s and version: %s", symbolicName, version), bundle, CoreMatchers.notNullValue());
        PackageAdmin packageAdmin = ServiceUtils.getService(BundleAssert.getBundleContext(), PackageAdmin.class);
        MatcherAssert.assertThat("PackageAdmin is unavailable", packageAdmin, CoreMatchers.notNullValue());
        int type = packageAdmin.getBundleType(bundle);
        MatcherAssert.assertThat(message, type & 1, CoreMatchers.is(CoreMatchers.not(0)));
    }

    public static void assertBundleEvent(int eventTypeMask, int bundleId, long timeoutInMillis) {
        BundleAssert.assertBundleEvent(String.format("BundleEvent is unavailable: %s - %s within timeout: %sms", eventTypeMask, bundleId, timeoutInMillis), eventTypeMask, bundleId, timeoutInMillis);
    }

    public static void assertBundleEvent(String message, int eventTypeMask, int bundleId, long timeoutInMillis) {
        BundleAssert.assertBundleEvent(message, eventTypeMask, bundleId, timeoutInMillis, TimeUnit.MILLISECONDS);
    }

    public static void assertBundleEvent(int eventTypeMask, int bundleId, long timeout, TimeUnit timeUnit) {
        BundleAssert.assertBundleEvent(String.format("BundleEvent is unavailable: %s - %s within timeout: %s%s", new Object[]{eventTypeMask, bundleId, timeout, timeUnit}), eventTypeMask, bundleId, timeout, timeUnit);
    }

    public static void assertBundleEvent(String message, int eventTypeMask, int bundleId, long timeout, TimeUnit timeUnit) {
        Bundle bundle = BundleUtils.findBundle(BundleAssert.getBundleContext(), bundleId);
        MatcherAssert.assertThat(String.format("Unknown bundle with ID: %d", bundleId), bundle, CoreMatchers.notNullValue());
        MatcherAssert.assertThat("TimeUnit is null", timeUnit, CoreMatchers.notNullValue());
        BundleEvent event = BundleUtils.waitForBundleEvent(BundleAssert.getBundleContext(), bundleId, eventTypeMask, timeout, timeUnit);
        MatcherAssert.assertThat(message, event, CoreMatchers.notNullValue());
    }

    public static void assertBundleEvent(int eventTypeMask, String symbolicName, long timeoutInMillis) {
        BundleAssert.assertBundleEvent(String.format("BundleEvent is unavailable: %s - %s within timeout: %sms", eventTypeMask, symbolicName, timeoutInMillis), eventTypeMask, symbolicName, timeoutInMillis);
    }

    public static void assertBundleEvent(String message, int eventTypeMask, String symbolicName, long timeoutInMillis) {
        BundleAssert.assertBundleEvent(message, eventTypeMask, symbolicName, timeoutInMillis, TimeUnit.MILLISECONDS);
    }

    public static void assertBundleEvent(int eventTypeMask, String symbolicName, long timeout, TimeUnit timeUnit) {
        BundleAssert.assertBundleEvent(String.format("BundleEvent is unavailable: %s - %s within timeout: %s%s", new Object[]{eventTypeMask, symbolicName, timeout, timeUnit}), eventTypeMask, symbolicName, timeout, timeUnit);
    }

    public static void assertBundleEvent(String message, int eventTypeMask, String symbolicName, long timeout, TimeUnit timeUnit) {
        MatcherAssert.assertThat("SymbolicName is null", symbolicName, CoreMatchers.notNullValue());
        MatcherAssert.assertThat("TimeUnit is null", timeUnit, CoreMatchers.notNullValue());
        BundleEvent event = BundleUtils.waitForBundleEvent(BundleAssert.getBundleContext(), symbolicName, eventTypeMask, timeout, timeUnit);
        MatcherAssert.assertThat(message, event, CoreMatchers.notNullValue());
    }

    public static void assertBundleEvent(int eventTypeMask, String symbolicName, Version version, long timeoutInMillis) {
        BundleAssert.assertBundleEvent(String.format("BundleEvent is unavailable: %s - %s[%s] within timeout: %sms", eventTypeMask, symbolicName, version, timeoutInMillis), eventTypeMask, symbolicName, version, timeoutInMillis);
    }

    public static void assertBundleEvent(String message, int eventTypeMask, String symbolicName, Version version, long timeoutInMillis) {
        BundleAssert.assertBundleEvent(message, eventTypeMask, symbolicName, version, timeoutInMillis, TimeUnit.MILLISECONDS);
    }

    public static void assertBundleEvent(int eventTypeMask, String symbolicName, long timeout, Version version, TimeUnit timeUnit) {
        BundleAssert.assertBundleEvent(String.format("BundleEvent is unavailable: %s - %s[%s] within timeout: %s%s", new Object[]{eventTypeMask, symbolicName, version, timeout, timeUnit}), eventTypeMask, symbolicName, version, timeout, timeUnit);
    }

    public static void assertBundleEvent(String message, int eventTypeMask, String symbolicName, Version version, long timeout, TimeUnit timeUnit) {
        MatcherAssert.assertThat("SymbolicName is null", symbolicName, CoreMatchers.notNullValue());
        MatcherAssert.assertThat("TimeUnit is null", timeUnit, CoreMatchers.notNullValue());
        BundleEvent event = BundleUtils.waitForBundleEvent(BundleAssert.getBundleContext(), symbolicName, version, eventTypeMask, timeout, timeUnit);
        MatcherAssert.assertThat(message, event, CoreMatchers.notNullValue());
    }
}

