/*
 * Decompiled with CFR 0.152.
 */
package org.knowhowlab.osgi.testing.assertions;

import org.hamcrest.CoreMatchers;
import org.hamcrest.MatcherAssert;
import org.knowhowlab.osgi.testing.assertions.OSGiAssert;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;

public class FilterAssert
extends OSGiAssert {
    private FilterAssert() {
    }

    public static void assertFilterCorrect(String filter) {
        FilterAssert.assertFilterCorrect(String.format("Filter is incorrect: %s", filter), filter);
    }

    public static void assertFilterCorrect(String message, String filter) {
        MatcherAssert.assertThat("Filter is null", filter, CoreMatchers.notNullValue());
        try {
            FrameworkUtil.createFilter((String)filter);
        }
        catch (InvalidSyntaxException e) {
            FilterAssert.fail(message);
        }
    }

    public static void assertFilterIncorrect(String filter) {
        FilterAssert.assertFilterIncorrect(String.format("Filter is correct: %s", filter), filter);
    }

    public static void assertFilterIncorrect(String message, String filter) {
        MatcherAssert.assertThat("Filter is null", filter, CoreMatchers.notNullValue());
        try {
            FrameworkUtil.createFilter((String)filter);
            FilterAssert.fail(message);
        }
        catch (InvalidSyntaxException invalidSyntaxException) {
            // empty catch block
        }
    }
}

