/*
 * Decompiled with CFR 0.152.
 */
package org.knowhowlab.osgi.testing.assertions;

import java.util.concurrent.TimeUnit;
import org.hamcrest.CoreMatchers;
import org.hamcrest.MatcherAssert;
import org.knowhowlab.osgi.testing.assertions.OSGiAssert;
import org.knowhowlab.osgi.testing.utils.BundleUtils;
import org.knowhowlab.osgi.testing.utils.FrameworkUtils;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkEvent;
import org.osgi.framework.Version;

public class FrameworkAssert
extends OSGiAssert {
    private FrameworkAssert() {
    }

    public static void assertFrameworkEvent(int eventTypeMask, int bundleId, long timeoutInMillis) {
        FrameworkAssert.assertFrameworkEvent(String.format("FrameworkEvent is unavailable: %s for bundle: %s within timeout: %sms", eventTypeMask, bundleId, timeoutInMillis), eventTypeMask, bundleId, timeoutInMillis);
    }

    public static void assertFrameworkEvent(String message, int eventTypeMask, int bundleId, long timeoutInMillis) {
        FrameworkAssert.assertFrameworkEvent(message, eventTypeMask, bundleId, timeoutInMillis, TimeUnit.MILLISECONDS);
    }

    public static void assertFrameworkEvent(int eventTypeMask, int bundleId, long timeout, TimeUnit timeUnit) {
        FrameworkAssert.assertFrameworkEvent(String.format("FrameworkEvent is unavailable: %s for bundle: %s within timeout: %s%s", new Object[]{eventTypeMask, bundleId, timeout, timeUnit}), eventTypeMask, bundleId, timeout, timeUnit);
    }

    public static void assertFrameworkEvent(String message, int eventTypeMask, int bundleId, long timeout, TimeUnit timeUnit) {
        Bundle bundle = BundleUtils.findBundle(FrameworkAssert.getBundleContext(), bundleId);
        MatcherAssert.assertThat(String.format("Unknown bundle with ID: %d", bundleId), bundle, CoreMatchers.notNullValue());
        MatcherAssert.assertThat("TimeUnit is null", timeUnit, CoreMatchers.notNullValue());
        FrameworkEvent event = FrameworkUtils.waitForFrameworkEvent(FrameworkAssert.getBundleContext(), bundleId, eventTypeMask, timeout, timeUnit);
        MatcherAssert.assertThat(message, event, CoreMatchers.notNullValue());
    }

    public static void assertFrameworkEvent(int eventTypeMask, String symbolicName, long timeoutInMillis) {
        FrameworkAssert.assertFrameworkEvent(String.format("FrameworkEvent is unavailable: %s for bundle: %s within timeout: %sms", eventTypeMask, symbolicName, timeoutInMillis), eventTypeMask, symbolicName, timeoutInMillis, TimeUnit.MILLISECONDS);
    }

    public static void assertFrameworkEvent(String message, int eventTypeMask, String symbolicName, long timeoutInMillis) {
        FrameworkAssert.assertFrameworkEvent(message, eventTypeMask, symbolicName, timeoutInMillis, TimeUnit.MILLISECONDS);
    }

    public static void assertFrameworkEvent(int eventTypeMask, String symbolicName, long timeout, TimeUnit timeUnit) {
        FrameworkAssert.assertFrameworkEvent(String.format("FrameworkEvent is unavailable: %s for bundle: %s within timeout: %s%s", new Object[]{eventTypeMask, symbolicName, timeout, timeUnit}), eventTypeMask, symbolicName, timeout, timeUnit);
    }

    public static void assertFrameworkEvent(String message, int eventTypeMask, String symbolicName, long timeout, TimeUnit timeUnit) {
        MatcherAssert.assertThat("SymbolicName is null", symbolicName, CoreMatchers.notNullValue());
        MatcherAssert.assertThat("TimeUnit is null", timeUnit, CoreMatchers.notNullValue());
        FrameworkEvent event = FrameworkUtils.waitForFrameworkEvent(FrameworkAssert.getBundleContext(), symbolicName, eventTypeMask, timeout, timeUnit);
        MatcherAssert.assertThat(message, event, CoreMatchers.notNullValue());
    }

    public static void assertFrameworkEvent(int eventTypeMask, String symbolicName, Version version, long timeoutInMillis) {
        FrameworkAssert.assertFrameworkEvent(String.format("FrameworkEvent is unavailable: %s for bundle: %s[%s] within timeout: %sms", eventTypeMask, symbolicName, version, timeoutInMillis), eventTypeMask, symbolicName, version, timeoutInMillis);
    }

    public static void assertFrameworkEvent(String message, int eventTypeMask, String symbolicName, Version version, long timeoutInMillis) {
        FrameworkAssert.assertFrameworkEvent(message, eventTypeMask, symbolicName, version, timeoutInMillis, TimeUnit.MILLISECONDS);
    }

    public static void assertFrameworkEvent(int eventTypeMask, String symbolicName, Version version, long timeout, TimeUnit timeUnit) {
        FrameworkAssert.assertFrameworkEvent(String.format("FrameworkEvent is unavailable: %s for bundle: %s[%s] within timeout: %s%s", new Object[]{eventTypeMask, symbolicName, version, timeout, timeUnit}), eventTypeMask, symbolicName, version, timeout, timeUnit);
    }

    public static void assertFrameworkEvent(String message, int eventTypeMask, String symbolicName, Version version, long timeout, TimeUnit timeUnit) {
        MatcherAssert.assertThat("SymbolicName is null", symbolicName, CoreMatchers.notNullValue());
        MatcherAssert.assertThat("TimeUnit is null", timeUnit, CoreMatchers.notNullValue());
        FrameworkEvent event = FrameworkUtils.waitForFrameworkEvent(FrameworkAssert.getBundleContext(), symbolicName, version, eventTypeMask, timeout, timeUnit);
        MatcherAssert.assertThat(message, event, CoreMatchers.notNullValue());
    }
}

