/*
 * Decompiled with CFR 0.152.
 */
package org.knowhowlab.osgi.testing.assertions;

import java.util.concurrent.TimeUnit;
import org.hamcrest.CoreMatchers;
import org.hamcrest.MatcherAssert;
import org.knowhowlab.osgi.testing.assertions.OSGiAssert;
import org.knowhowlab.osgi.testing.utils.ServiceUtils;
import org.osgi.framework.Filter;
import org.osgi.framework.ServiceEvent;

public class ServiceAssert
extends OSGiAssert {
    private ServiceAssert() {
    }

    public static void assertServiceAvailable(Class clazz) {
        ServiceAssert.assertServiceAvailable(String.format("Service is unavailable: %s", clazz.getName()), clazz);
    }

    public static void assertServiceAvailable(String message, Class clazz) {
        MatcherAssert.assertThat("Class is null", clazz, CoreMatchers.notNullValue());
        Object service = ServiceUtils.getService(ServiceAssert.getBundleContext(), clazz);
        MatcherAssert.assertThat(message, service, CoreMatchers.notNullValue());
    }

    public static void assertServiceAvailable(Class clazz, long timeoutInMillis) {
        ServiceAssert.assertServiceAvailable(String.format("Service is unavailable: %s within timeout: %sms", clazz.getName(), timeoutInMillis), clazz, timeoutInMillis);
    }

    public static void assertServiceAvailable(String message, Class clazz, long timeoutInMillis) {
        ServiceAssert.assertServiceAvailable(message, clazz, timeoutInMillis, TimeUnit.MILLISECONDS);
    }

    public static void assertServiceAvailable(Class clazz, long timeout, TimeUnit timeUnit) {
        ServiceAssert.assertServiceAvailable(String.format("Service is unavailable: %s within timeout: %s%s", new Object[]{clazz.getName(), timeout, timeUnit}), clazz, timeout, timeUnit);
    }

    public static void assertServiceAvailable(String message, Class clazz, long timeout, TimeUnit timeUnit) {
        MatcherAssert.assertThat("Class is null", clazz, CoreMatchers.notNullValue());
        MatcherAssert.assertThat("TimeUnit is null", timeUnit, CoreMatchers.notNullValue());
        Object service = ServiceUtils.getService(ServiceAssert.getBundleContext(), clazz, timeout, timeUnit);
        MatcherAssert.assertThat(message, service, CoreMatchers.notNullValue());
    }

    public static void assertServiceAvailable(String className) {
        ServiceAssert.assertServiceAvailable(String.format("Service is unavailable: %s", className), className);
    }

    public static void assertServiceAvailable(String message, String className) {
        MatcherAssert.assertThat("Class name is null", className, CoreMatchers.notNullValue());
        Object service = ServiceUtils.getService(ServiceAssert.getBundleContext(), className);
        MatcherAssert.assertThat(message, service, CoreMatchers.notNullValue());
    }

    public static void assertServiceAvailable(String className, long timeoutInMillis) {
        ServiceAssert.assertServiceAvailable(String.format("Service is unavailable: %s within timeout: %sms", className, timeoutInMillis), className, timeoutInMillis);
    }

    public static void assertServiceAvailable(String message, String className, long timeoutInMillis) {
        ServiceAssert.assertServiceAvailable(message, className, timeoutInMillis, TimeUnit.MILLISECONDS);
    }

    public static void assertServiceAvailable(String className, long timeout, TimeUnit timeUnit) {
        ServiceAssert.assertServiceAvailable(String.format("Service is unavailable: %s within timeout: %s%s", new Object[]{className, timeout, timeUnit}), className, timeout, timeUnit);
    }

    public static void assertServiceAvailable(String message, String className, long timeout, TimeUnit timeUnit) {
        MatcherAssert.assertThat("Class name is null", className, CoreMatchers.notNullValue());
        MatcherAssert.assertThat("TimeUnit is null", timeUnit, CoreMatchers.notNullValue());
        Object service = ServiceUtils.getService(ServiceAssert.getBundleContext(), className, timeout, timeUnit);
        MatcherAssert.assertThat(message, service, CoreMatchers.notNullValue());
    }

    public static void assertServiceAvailable(Filter filter) {
        ServiceAssert.assertServiceAvailable(String.format("Service is unavailable: %s", filter), filter);
    }

    public static void assertServiceAvailable(String message, Filter filter) {
        MatcherAssert.assertThat("Filter is null", filter, CoreMatchers.notNullValue());
        Object service = ServiceUtils.getService(ServiceAssert.getBundleContext(), filter);
        MatcherAssert.assertThat(message, service, CoreMatchers.notNullValue());
    }

    public static void assertServiceAvailable(Filter filter, long timeoutInMillis) {
        ServiceAssert.assertServiceAvailable(String.format("Service is unavailable: %s within timeout: %sms", filter, timeoutInMillis), filter, timeoutInMillis);
    }

    public static void assertServiceAvailable(String message, Filter filter, long timeoutInMillis) {
        ServiceAssert.assertServiceAvailable(message, filter, timeoutInMillis, TimeUnit.MILLISECONDS);
    }

    public static void assertServiceAvailable(Filter filter, long timeout, TimeUnit timeUnit) {
        ServiceAssert.assertServiceAvailable(String.format("Service is unavailable: %s within timeout: %s%s", new Object[]{filter, timeout, timeUnit}), filter, timeout, timeUnit);
    }

    public static void assertServiceAvailable(String message, Filter filter, long timeout, TimeUnit timeUnit) {
        MatcherAssert.assertThat("Filter is null", filter, CoreMatchers.notNullValue());
        MatcherAssert.assertThat("TimeUnit is null", timeUnit, CoreMatchers.notNullValue());
        Object service = ServiceUtils.getService(ServiceAssert.getBundleContext(), filter, timeout, timeUnit);
        MatcherAssert.assertThat(message, service, CoreMatchers.notNullValue());
    }

    public static void assertServiceUnavailable(Class clazz) {
        ServiceAssert.assertServiceUnavailable(String.format("Service is available: %s", clazz.getName()), clazz);
    }

    public static void assertServiceUnavailable(String message, Class clazz) {
        MatcherAssert.assertThat("Class is null", clazz, CoreMatchers.notNullValue());
        Object service = ServiceUtils.getService(ServiceAssert.getBundleContext(), clazz);
        MatcherAssert.assertThat(message, service, CoreMatchers.nullValue());
    }

    public static void assertServiceUnavailable(Class clazz, long timeoutInMillis) {
        ServiceAssert.assertServiceUnavailable(String.format("Service is available: %s within timeout: %sms", clazz.getName(), timeoutInMillis), clazz, timeoutInMillis);
    }

    public static void assertServiceUnavailable(String message, Class clazz, long timeoutInMillis) {
        ServiceAssert.assertServiceUnavailable(message, clazz, timeoutInMillis, TimeUnit.MILLISECONDS);
    }

    public static void assertServiceUnavailable(Class clazz, long timeout, TimeUnit timeUnit) {
        ServiceAssert.assertServiceUnavailable(String.format("Service is available: %s within timeout: %s%s", new Object[]{clazz.getName(), timeout, timeUnit}), clazz, timeout, timeUnit);
    }

    public static void assertServiceUnavailable(String message, Class clazz, long timeout, TimeUnit timeUnit) {
        MatcherAssert.assertThat("Class is null", clazz, CoreMatchers.notNullValue());
        MatcherAssert.assertThat("TimeUnit is null", timeUnit, CoreMatchers.notNullValue());
        Object service = ServiceUtils.getService(ServiceAssert.getBundleContext(), clazz, timeout, timeUnit);
        MatcherAssert.assertThat(message, service, CoreMatchers.nullValue());
    }

    public static void assertServiceUnavailable(String className) {
        ServiceAssert.assertServiceUnavailable(String.format("Service is available: %s", className), className);
    }

    public static void assertServiceUnavailable(String message, String className) {
        MatcherAssert.assertThat("Class name is null", className, CoreMatchers.notNullValue());
        Object service = ServiceUtils.getService(ServiceAssert.getBundleContext(), className);
        MatcherAssert.assertThat(message, service, CoreMatchers.nullValue());
    }

    public static void assertServiceUnavailable(String className, long timeoutInMillis) {
        ServiceAssert.assertServiceUnavailable(String.format("Service is available: %s within timeout: %sms", className, timeoutInMillis), className, timeoutInMillis);
    }

    public static void assertServiceUnavailable(String message, String className, long timeoutInMillis) {
        ServiceAssert.assertServiceUnavailable(message, className, timeoutInMillis, TimeUnit.MILLISECONDS);
    }

    public static void assertServiceUnavailable(String className, long timeout, TimeUnit timeUnit) {
        ServiceAssert.assertServiceUnavailable(String.format("Service is available: %s within timeout: %s%s", new Object[]{className, timeout, timeUnit}), className, timeout, timeUnit);
    }

    public static void assertServiceUnavailable(String message, String className, long timeout, TimeUnit timeUnit) {
        MatcherAssert.assertThat("Class name is null", className, CoreMatchers.notNullValue());
        MatcherAssert.assertThat("TimeUnit is null", timeUnit, CoreMatchers.notNullValue());
        Object service = ServiceUtils.getService(ServiceAssert.getBundleContext(), className, timeout, timeUnit);
        MatcherAssert.assertThat(message, service, CoreMatchers.nullValue());
    }

    public static void assertServiceUnavailable(Filter filter) {
        ServiceAssert.assertServiceUnavailable(String.format("Service is available: %s", filter), filter);
    }

    public static void assertServiceUnavailable(String message, Filter filter) {
        MatcherAssert.assertThat("Filter is null", filter, CoreMatchers.notNullValue());
        Object service = ServiceUtils.getService(ServiceAssert.getBundleContext(), filter);
        MatcherAssert.assertThat(message, service, CoreMatchers.nullValue());
    }

    public static void assertServiceUnavailable(Filter filter, long timeoutInMillis) {
        ServiceAssert.assertServiceUnavailable(String.format("Service is available: %s within timeout: %sms", filter, timeoutInMillis), filter, timeoutInMillis);
    }

    public static void assertServiceUnavailable(String message, Filter filter, long timeoutInMillis) {
        ServiceAssert.assertServiceUnavailable(message, filter, timeoutInMillis, TimeUnit.MILLISECONDS);
    }

    public static void assertServiceUnavailable(Filter filter, long timeout, TimeUnit timeUnit) {
        ServiceAssert.assertServiceUnavailable(String.format("Service is available: %s within timeout: %s%s", new Object[]{filter, timeout, timeUnit}), filter, timeout, timeUnit);
    }

    public static void assertServiceUnavailable(String message, Filter filter, long timeout, TimeUnit timeUnit) {
        MatcherAssert.assertThat("Filter is null", filter, CoreMatchers.notNullValue());
        MatcherAssert.assertThat("TimeUnit is null", timeUnit, CoreMatchers.notNullValue());
        Object service = ServiceUtils.getService(ServiceAssert.getBundleContext(), filter, timeout, timeUnit);
        MatcherAssert.assertThat(message, service, CoreMatchers.nullValue());
    }

    public static void assertServiceEvent(int eventTypeMask, Filter filter, long timeoutInMillis) {
        ServiceAssert.assertServiceEvent(String.format("ServiceEvent is unavailable: %s - %s within timeout: %sms", eventTypeMask, filter, timeoutInMillis), eventTypeMask, filter, timeoutInMillis);
    }

    public static void assertServiceEvent(String message, int eventTypeMask, Filter filter, long timeoutInMillis) {
        ServiceAssert.assertServiceEvent(message, eventTypeMask, filter, timeoutInMillis, TimeUnit.MILLISECONDS);
    }

    public static void assertServiceEvent(int eventTypeMask, Filter filter, long timeout, TimeUnit timeUnit) {
        ServiceAssert.assertServiceEvent(String.format("ServiceEvent is unavailable: %s - %s within timeout: %s%s", new Object[]{eventTypeMask, filter, timeout, timeUnit}), eventTypeMask, filter, timeout, timeUnit);
    }

    public static void assertServiceEvent(String message, int eventTypeMask, Filter filter, long timeout, TimeUnit timeUnit) {
        ServiceAssert.assertServiceEvent(message, eventTypeMask, filter, false, timeout, timeUnit);
    }

    public static void assertServiceEvent(int eventTypeMask, Filter filter, boolean all, long timeoutInMillis) {
        ServiceAssert.assertServiceEvent(String.format("ServiceEvent is unavailable: %s - %s; all=%s within timeout: %sms", eventTypeMask, filter, all, timeoutInMillis), eventTypeMask, filter, all, timeoutInMillis);
    }

    public static void assertServiceEvent(String message, int eventTypeMask, Filter filter, boolean all, long timeoutInMillis) {
        ServiceAssert.assertServiceEvent(message, eventTypeMask, filter, all, timeoutInMillis, TimeUnit.MILLISECONDS);
    }

    public static void assertServiceEvent(int eventTypeMask, Filter filter, boolean all, long timeout, TimeUnit timeUnit) {
        ServiceAssert.assertServiceEvent(String.format("ServiceEvent is unavailable: %s - %s; all=%s within timeout: %s%s", new Object[]{eventTypeMask, filter, all, timeout, timeUnit}), eventTypeMask, filter, all, timeout, timeUnit);
    }

    public static void assertServiceEvent(String message, int eventTypeMask, Filter filter, boolean all, long timeout, TimeUnit timeUnit) {
        MatcherAssert.assertThat("Filter is null", filter, CoreMatchers.notNullValue());
        MatcherAssert.assertThat("TimeUnit is null", timeUnit, CoreMatchers.notNullValue());
        ServiceEvent event = ServiceUtils.waitForServiceEvent(ServiceAssert.getBundleContext(), filter, eventTypeMask, all, timeout, timeUnit);
        MatcherAssert.assertThat(message, event, CoreMatchers.notNullValue());
    }

    public static void assertServiceEvent(int eventTypeMask, String className, long timeoutInMillis) {
        ServiceAssert.assertServiceEvent(String.format("ServiceEvent is unavailable: %s - %s within timeout: %sms", eventTypeMask, className, timeoutInMillis), eventTypeMask, className, timeoutInMillis);
    }

    public static void assertServiceEvent(String message, int eventTypeMask, String className, long timeoutInMillis) {
        ServiceAssert.assertServiceEvent(message, eventTypeMask, className, timeoutInMillis, TimeUnit.MILLISECONDS);
    }

    public static void assertServiceEvent(int eventTypeMask, String className, long timeout, TimeUnit timeUnit) {
        ServiceAssert.assertServiceEvent(String.format("ServiceEvent is unavailable: %s - %s within timeout: %s%s", new Object[]{eventTypeMask, className, timeout, timeUnit}), eventTypeMask, className, timeout, timeUnit);
    }

    public static void assertServiceEvent(String message, int eventTypeMask, String className, long timeout, TimeUnit timeUnit) {
        ServiceAssert.assertServiceEvent(message, eventTypeMask, className, false, timeout, timeUnit);
    }

    public static void assertServiceEvent(int eventTypeMask, String className, boolean all, long timeoutInMillis) {
        ServiceAssert.assertServiceEvent(String.format("ServiceEvent is unavailable: %s - %s; all=%s within timeout: %sms", eventTypeMask, className, all, timeoutInMillis), eventTypeMask, className, all, timeoutInMillis);
    }

    public static void assertServiceEvent(String message, int eventTypeMask, String className, boolean all, long timeoutInMillis) {
        ServiceAssert.assertServiceEvent(message, eventTypeMask, className, all, timeoutInMillis, TimeUnit.MILLISECONDS);
    }

    public static void assertServiceEvent(int eventTypeMask, String className, boolean all, long timeout, TimeUnit timeUnit) {
        ServiceAssert.assertServiceEvent(String.format("ServiceEvent is unavailable: %s - %s; all=%s within timeout: %s%s", new Object[]{eventTypeMask, className, all, timeout, timeUnit}), eventTypeMask, className, all, timeout, timeUnit);
    }

    public static void assertServiceEvent(String message, int eventTypeMask, String className, boolean all, long timeout, TimeUnit timeUnit) {
        MatcherAssert.assertThat("Class name is null", className, CoreMatchers.notNullValue());
        MatcherAssert.assertThat("TimeUnit is null", timeUnit, CoreMatchers.notNullValue());
        ServiceEvent event = ServiceUtils.waitForServiceEvent(ServiceAssert.getBundleContext(), className, eventTypeMask, all, timeout, timeUnit);
        MatcherAssert.assertThat(message, event, CoreMatchers.notNullValue());
    }

    public static void assertServiceEvent(int eventTypeMask, Class clazz, long timeoutInMillis) {
        ServiceAssert.assertServiceEvent(String.format("ServiceEvent is unavailable: %s - %s within timeout: %sms", eventTypeMask, clazz.getName(), timeoutInMillis), eventTypeMask, clazz, timeoutInMillis);
    }

    public static void assertServiceEvent(String message, int eventTypeMask, Class clazz, long timeoutInMillis) {
        ServiceAssert.assertServiceEvent(message, eventTypeMask, clazz, timeoutInMillis, TimeUnit.MILLISECONDS);
    }

    public static void assertServiceEvent(int eventTypeMask, Class clazz, long timeout, TimeUnit timeUnit) {
        ServiceAssert.assertServiceEvent(String.format("ServiceEvent is unavailable: %s - %s within timeout: %s%s", new Object[]{eventTypeMask, clazz.getName(), timeout, timeUnit}), eventTypeMask, clazz, timeout, timeUnit);
    }

    public static void assertServiceEvent(String message, int eventTypeMask, Class clazz, long timeout, TimeUnit timeUnit) {
        ServiceAssert.assertServiceEvent(message, eventTypeMask, clazz, false, timeout, timeUnit);
    }

    public static void assertServiceEvent(int eventTypeMask, Class clazz, boolean all, long timeoutInMillis) {
        ServiceAssert.assertServiceEvent(String.format("ServiceEvent is unavailable: %s - %s; all=%s within timeout: %sms", eventTypeMask, clazz.getName(), all, timeoutInMillis), eventTypeMask, clazz, all, timeoutInMillis);
    }

    public static void assertServiceEvent(String message, int eventTypeMask, Class clazz, boolean all, long timeoutInMillis) {
        ServiceAssert.assertServiceEvent(message, eventTypeMask, clazz, all, timeoutInMillis, TimeUnit.MILLISECONDS);
    }

    public static void assertServiceEvent(int eventTypeMask, Class clazz, boolean all, long timeout, TimeUnit timeUnit) {
        ServiceAssert.assertServiceEvent(String.format("ServiceEvent is unavailable: %s - %s; all=%s within timeout: %s%s", new Object[]{eventTypeMask, clazz.getName(), all, timeout, timeUnit}), eventTypeMask, clazz, all, timeout, timeUnit);
    }

    public static void assertServiceEvent(String message, int eventTypeMask, Class clazz, boolean all, long timeout, TimeUnit timeUnit) {
        MatcherAssert.assertThat("Class is null", clazz, CoreMatchers.notNullValue());
        MatcherAssert.assertThat("TimeUnit is null", timeUnit, CoreMatchers.notNullValue());
        ServiceEvent event = ServiceUtils.waitForServiceEvent(ServiceAssert.getBundleContext(), clazz, eventTypeMask, all, timeout, timeUnit);
        MatcherAssert.assertThat(message, event, CoreMatchers.notNullValue());
    }
}

