/*
 * Decompiled with CFR 0.152.
 */
package org.knowhowlab.osgi.testing.utils;

import java.io.InputStream;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.knowhowlab.osgi.testing.utils.ServiceUtils;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.osgi.framework.Version;
import org.osgi.service.packageadmin.PackageAdmin;
import org.osgi.util.tracker.BundleTracker;
import org.osgi.util.tracker.BundleTrackerCustomizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BundleUtils {
    public static final int ANY_STATE = 63;

    private BundleUtils() {
    }

    public static Bundle findBundle(BundleContext bc, long bundleId) {
        return bc.getBundle(bundleId);
    }

    public static Bundle findBundle(BundleContext bc, String symbolicName) {
        return BundleUtils.findBundle(bc, symbolicName, null);
    }

    public static Bundle findBundle(BundleContext bc, String symbolicName, Version version) {
        Bundle[] bundles;
        PackageAdmin packageAdmin = ServiceUtils.getService(bc, PackageAdmin.class);
        if (packageAdmin != null && (bundles = packageAdmin.getBundles(symbolicName, version != null ? version.toString() : null)) != null && bundles.length > 0) {
            return bundles[0];
        }
        return null;
    }

    public static Bundle findBundle(BundleContext bc, String symbolicName, Version version, long timeoutInMillis) {
        return BundleUtils.findBundle(bc, symbolicName, version, timeoutInMillis, TimeUnit.MILLISECONDS);
    }

    public static Bundle findBundle(BundleContext bc, String symbolicName, Version version, int stateMask, long timeoutInMillis) {
        return BundleUtils.findBundle(bc, symbolicName, version, stateMask, timeoutInMillis, TimeUnit.MILLISECONDS);
    }

    public static Bundle findBundle(BundleContext bc, String symbolicName, long timeoutInMillis) {
        return BundleUtils.findBundle(bc, symbolicName, null, timeoutInMillis, TimeUnit.MILLISECONDS);
    }

    public static Bundle findBundle(BundleContext bc, String symbolicName, int stateMask, long timeoutInMillis) {
        return BundleUtils.findBundle(bc, symbolicName, null, stateMask, timeoutInMillis, TimeUnit.MILLISECONDS);
    }

    public static Bundle findBundle(BundleContext bc, String symbolicName, long timeout, TimeUnit timeUnit) {
        return BundleUtils.findBundle(bc, symbolicName, null, timeout, timeUnit);
    }

    public static Bundle findBundle(BundleContext bc, String symbolicName, int stateMask, long timeout, TimeUnit timeUnit) {
        return BundleUtils.findBundle(bc, symbolicName, null, stateMask, timeout, timeUnit);
    }

    public static Bundle findBundle(BundleContext bc, String symbolicName, Version version, long timeout, TimeUnit timeUnit) {
        return BundleUtils.findBundle(bc, symbolicName, version, 63, timeout, timeUnit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Bundle findBundle(BundleContext bc, String symbolicName, Version version, int stateMask, long timeout, TimeUnit timeUnit) {
        CountDownLatch latch = new CountDownLatch(1);
        long timeoutInMillis = timeUnit.toMillis(timeout);
        BundleTracker tracker = new BundleTracker(bc, stateMask, (BundleTrackerCustomizer)new SymbolicNameVersionBundleTrackerCustomizer(bc, latch, symbolicName, version));
        tracker.open();
        try {
            Bundle bundle = BundleUtils.waitForBundle(tracker, timeoutInMillis, latch);
            return bundle;
        }
        catch (InterruptedException e) {
            Bundle bundle = null;
            return bundle;
        }
        finally {
            tracker.close();
        }
    }

    public static Future<Bundle> installBundleAsync(BundleContext bc, String location) {
        return BundleUtils.installBundleAsync(bc, location, 0L);
    }

    public static Future<Bundle> installBundleAsync(BundleContext bc, String location, InputStream input) {
        return BundleUtils.installBundleAsync(bc, location, input, 0L);
    }

    public static Future<Bundle> installBundleAsync(BundleContext bc, String location, long delayInMillis) {
        return BundleUtils.installBundleAsync(bc, location, delayInMillis, TimeUnit.MILLISECONDS);
    }

    public static Future<Bundle> installBundleAsync(BundleContext bc, String location, InputStream input, long delayInMillis) {
        return BundleUtils.installBundleAsync(bc, location, input, delayInMillis, TimeUnit.MILLISECONDS);
    }

    public static Future<Bundle> installBundleAsync(BundleContext bc, String location, long delay, TimeUnit timeUnit) {
        return BundleUtils.installBundleAsync(bc, location, null, delay, timeUnit);
    }

    public static Future<Bundle> installBundleAsync(final BundleContext bc, final String location, final InputStream input, long delay, TimeUnit timeUnit) {
        return Executors.newSingleThreadScheduledExecutor().schedule(new Callable<Bundle>(){

            @Override
            public Bundle call() throws Exception {
                return bc.installBundle(location, input);
            }
        }, delay, timeUnit);
    }

    public static Future<?> startBundleAsync(Bundle bundle) {
        return BundleUtils.startBundleAsync(bundle, 0L);
    }

    public static Future<?> startBundleAsync(BundleContext bc, long bundleId) {
        return BundleUtils.startBundleAsync(bc, bundleId, 0L);
    }

    public static Future<?> startBundleAsync(BundleContext bc, String symbolicName) {
        return BundleUtils.startBundleAsync(bc, symbolicName, 0L);
    }

    public static Future<?> startBundleAsync(BundleContext bc, String symbolicName, Version version) {
        return BundleUtils.startBundleAsync(bc, symbolicName, version, 0L);
    }

    public static Future<?> startBundleAsync(Bundle bundle, int options) {
        return BundleUtils.startBundleAsync(bundle, options, 0L);
    }

    public static Future<?> startBundleAsync(BundleContext bc, long bundleId, int options) {
        return BundleUtils.startBundleAsync(bc, bundleId, options, 0L);
    }

    public static Future<?> startBundleAsync(BundleContext bc, String symbolicName, int options) {
        return BundleUtils.startBundleAsync(bc, symbolicName, options, 0L);
    }

    public static Future<?> startBundleAsync(BundleContext bc, String symbolicName, Version version, int options) {
        return BundleUtils.startBundleAsync(bc, symbolicName, version, options, 0L);
    }

    public static Future<?> startBundleAsync(Bundle bundle, long delayInMillis) {
        return BundleUtils.startBundleAsync(bundle, delayInMillis, TimeUnit.MILLISECONDS);
    }

    public static Future<?> startBundleAsync(BundleContext bc, long bundleId, long delayInMillis) {
        return BundleUtils.startBundleAsync(bc, bundleId, delayInMillis, TimeUnit.MILLISECONDS);
    }

    public static Future<?> startBundleAsync(BundleContext bc, String symbolicName, long delayInMillis) {
        return BundleUtils.startBundleAsync(bc, symbolicName, delayInMillis, TimeUnit.MILLISECONDS);
    }

    public static Future<?> startBundleAsync(BundleContext bc, String symbolicName, Version version, long delayInMillis) {
        return BundleUtils.startBundleAsync(bc, symbolicName, version, delayInMillis, TimeUnit.MILLISECONDS);
    }

    public static Future<?> startBundleAsync(Bundle bundle, int options, long delayInMillis) {
        return BundleUtils.startBundleAsync(bundle, options, delayInMillis, TimeUnit.MILLISECONDS);
    }

    public static Future<?> startBundleAsync(BundleContext bc, long bundleId, int options, long delayInMillis) {
        return BundleUtils.startBundleAsync(bc, bundleId, options, delayInMillis, TimeUnit.MILLISECONDS);
    }

    public static Future<?> startBundleAsync(BundleContext bc, String symbolicName, int options, long delayInMillis) {
        return BundleUtils.startBundleAsync(bc, symbolicName, options, delayInMillis, TimeUnit.MILLISECONDS);
    }

    public static Future<?> startBundleAsync(BundleContext bc, String symbolicName, Version version, int options, long delayInMillis) {
        return BundleUtils.startBundleAsync(bc, symbolicName, version, options, delayInMillis, TimeUnit.MILLISECONDS);
    }

    public static Future<?> startBundleAsync(Bundle bundle, long delay, TimeUnit timeUnit) {
        return BundleUtils.startBundleAsync(bundle, 0, delay, timeUnit);
    }

    public static Future<?> startBundleAsync(BundleContext bc, long bundleId, long delay, TimeUnit timeUnit) {
        return BundleUtils.startBundleAsync(BundleUtils.findBundle(bc, bundleId), delay, timeUnit);
    }

    public static Future<?> startBundleAsync(BundleContext bc, String symbolicName, long delay, TimeUnit timeUnit) {
        return BundleUtils.startBundleAsync(BundleUtils.findBundle(bc, symbolicName), delay, timeUnit);
    }

    public static Future<?> startBundleAsync(BundleContext bc, String symbolicName, Version version, long delay, TimeUnit timeUnit) {
        return BundleUtils.startBundleAsync(BundleUtils.findBundle(bc, symbolicName, version), delay, timeUnit);
    }

    public static Future<?> startBundleAsync(final Bundle bundle, final int options, long delay, TimeUnit timeUnit) {
        return Executors.newSingleThreadScheduledExecutor().schedule(new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                bundle.start(options);
                return null;
            }
        }, delay, timeUnit);
    }

    public static Future<?> startBundleAsync(BundleContext bc, long bundleId, int options, long delay, TimeUnit timeUnit) {
        return BundleUtils.startBundleAsync(BundleUtils.findBundle(bc, bundleId), options, delay, timeUnit);
    }

    public static Future<?> startBundleAsync(BundleContext bc, String symbolicName, int options, long delay, TimeUnit timeUnit) {
        return BundleUtils.startBundleAsync(BundleUtils.findBundle(bc, symbolicName), options, delay, timeUnit);
    }

    public static Future<?> startBundleAsync(BundleContext bc, String symbolicName, Version version, int options, long delay, TimeUnit timeUnit) {
        return BundleUtils.startBundleAsync(BundleUtils.findBundle(bc, symbolicName, version), options, delay, timeUnit);
    }

    public static Future<?> stopBundleAsync(Bundle bundle) {
        return BundleUtils.stopBundleAsync(bundle, 0L);
    }

    public static Future<?> stopBundleAsync(BundleContext bc, long bundleId) {
        return BundleUtils.stopBundleAsync(bc, bundleId, 0L);
    }

    public static Future<?> stopBundleAsync(BundleContext bc, String symbolicName) {
        return BundleUtils.stopBundleAsync(bc, symbolicName, 0L);
    }

    public static Future<?> stopBundleAsync(BundleContext bc, String symbolicName, Version version) {
        return BundleUtils.stopBundleAsync(bc, symbolicName, version, 0L);
    }

    public static Future<?> stopBundleAsync(Bundle bundle, int options) {
        return BundleUtils.stopBundleAsync(bundle, options, 0L);
    }

    public static Future<?> stopBundleAsync(BundleContext bc, long bundleId, int options) {
        return BundleUtils.stopBundleAsync(bc, bundleId, options, 0L);
    }

    public static Future<?> stopBundleAsync(BundleContext bc, String symbolicName, int options) {
        return BundleUtils.stopBundleAsync(bc, symbolicName, options, 0L);
    }

    public static Future<?> stopBundleAsync(BundleContext bc, String symbolicName, Version version, int options) {
        return BundleUtils.stopBundleAsync(bc, symbolicName, version, options, 0L);
    }

    public static Future<?> stopBundleAsync(Bundle bundle, long delayInMillis) {
        return BundleUtils.stopBundleAsync(bundle, delayInMillis, TimeUnit.MILLISECONDS);
    }

    public static Future<?> stopBundleAsync(BundleContext bc, long bundleId, long delayInMillis) {
        return BundleUtils.stopBundleAsync(bc, bundleId, delayInMillis, TimeUnit.MILLISECONDS);
    }

    public static Future<?> stopBundleAsync(BundleContext bc, String symbolicName, long delayInMillis) {
        return BundleUtils.stopBundleAsync(bc, symbolicName, delayInMillis, TimeUnit.MILLISECONDS);
    }

    public static Future<?> stopBundleAsync(BundleContext bc, String symbolicName, Version version, long delayInMillis) {
        return BundleUtils.stopBundleAsync(bc, symbolicName, version, delayInMillis, TimeUnit.MILLISECONDS);
    }

    public static Future<?> stopBundleAsync(Bundle bundle, int options, long delayInMillis) {
        return BundleUtils.stopBundleAsync(bundle, options, delayInMillis, TimeUnit.MILLISECONDS);
    }

    public static Future<?> stopBundleAsync(BundleContext bc, long bundleId, int options, long delayInMillis) {
        return BundleUtils.stopBundleAsync(bc, bundleId, options, delayInMillis, TimeUnit.MILLISECONDS);
    }

    public static Future<?> stopBundleAsync(BundleContext bc, String symbolicName, int options, long delayInMillis) {
        return BundleUtils.stopBundleAsync(bc, symbolicName, options, delayInMillis, TimeUnit.MILLISECONDS);
    }

    public static Future<?> stopBundleAsync(BundleContext bc, String symbolicName, Version version, int options, long delayInMillis) {
        return BundleUtils.stopBundleAsync(bc, symbolicName, version, options, delayInMillis, TimeUnit.MILLISECONDS);
    }

    public static Future<?> stopBundleAsync(Bundle bundle, long delay, TimeUnit timeUnit) {
        return BundleUtils.stopBundleAsync(bundle, 0, delay, timeUnit);
    }

    public static Future<?> stopBundleAsync(BundleContext bc, long bundleId, long delay, TimeUnit timeUnit) {
        return BundleUtils.stopBundleAsync(BundleUtils.findBundle(bc, bundleId), delay, timeUnit);
    }

    public static Future<?> stopBundleAsync(BundleContext bc, String symbolicName, long delay, TimeUnit timeUnit) {
        return BundleUtils.stopBundleAsync(BundleUtils.findBundle(bc, symbolicName), delay, timeUnit);
    }

    public static Future<?> stopBundleAsync(BundleContext bc, String symbolicName, Version version, long delay, TimeUnit timeUnit) {
        return BundleUtils.stopBundleAsync(BundleUtils.findBundle(bc, symbolicName, version), delay, timeUnit);
    }

    public static Future<?> stopBundleAsync(final Bundle bundle, final int options, long delay, TimeUnit timeUnit) {
        return Executors.newSingleThreadScheduledExecutor().schedule(new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                bundle.stop(options);
                return null;
            }
        }, delay, timeUnit);
    }

    public static Future<?> stopBundleAsync(BundleContext bc, long bundleId, int options, long delay, TimeUnit timeUnit) {
        return BundleUtils.stopBundleAsync(BundleUtils.findBundle(bc, bundleId), options, delay, timeUnit);
    }

    public static Future<?> stopBundleAsync(BundleContext bc, String symbolicName, int options, long delay, TimeUnit timeUnit) {
        return BundleUtils.stopBundleAsync(BundleUtils.findBundle(bc, symbolicName), options, delay, timeUnit);
    }

    public static Future<?> stopBundleAsync(BundleContext bc, String symbolicName, Version version, int options, long delay, TimeUnit timeUnit) {
        return BundleUtils.stopBundleAsync(BundleUtils.findBundle(bc, symbolicName, version), options, delay, timeUnit);
    }

    public static Future<?> uninstallBundleAsync(Bundle bundle) {
        return BundleUtils.uninstallBundleAsync(bundle, 0L);
    }

    public static Future<?> uninstallBundleAsync(BundleContext bc, long bundleId) {
        return BundleUtils.uninstallBundleAsync(bc, bundleId, 0L);
    }

    public static Future<?> uninstallBundleAsync(BundleContext bc, String symbolicName) {
        return BundleUtils.uninstallBundleAsync(bc, symbolicName, 0L);
    }

    public static Future<?> uninstallBundleAsync(BundleContext bc, String symbolicName, Version version) {
        return BundleUtils.uninstallBundleAsync(bc, symbolicName, version, 0L);
    }

    public static Future<?> uninstallBundleAsync(Bundle bundle, long delayInMillis) {
        return BundleUtils.uninstallBundleAsync(bundle, delayInMillis, TimeUnit.MILLISECONDS);
    }

    public static Future<?> uninstallBundleAsync(BundleContext bc, long bundleId, long delayInMillis) {
        return BundleUtils.uninstallBundleAsync(bc, bundleId, delayInMillis, TimeUnit.MILLISECONDS);
    }

    public static Future<?> uninstallBundleAsync(BundleContext bc, String symbolicName, long delayInMillis) {
        return BundleUtils.uninstallBundleAsync(bc, symbolicName, delayInMillis, TimeUnit.MILLISECONDS);
    }

    public static Future<?> uninstallBundleAsync(BundleContext bc, String symbolicName, Version version, long delayInMillis) {
        return BundleUtils.uninstallBundleAsync(bc, symbolicName, version, delayInMillis, TimeUnit.MILLISECONDS);
    }

    public static Future<?> uninstallBundleAsync(final Bundle bundle, long delay, TimeUnit timeUnit) {
        return Executors.newSingleThreadScheduledExecutor().schedule(new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                bundle.uninstall();
                return null;
            }
        }, delay, timeUnit);
    }

    public static Future<?> uninstallBundleAsync(BundleContext bc, long bundleId, long delay, TimeUnit timeUnit) {
        return BundleUtils.uninstallBundleAsync(BundleUtils.findBundle(bc, bundleId), delay, timeUnit);
    }

    public static Future<?> uninstallBundleAsync(BundleContext bc, String symbolicName, long delay, TimeUnit timeUnit) {
        return BundleUtils.uninstallBundleAsync(BundleUtils.findBundle(bc, symbolicName), delay, timeUnit);
    }

    public static Future<?> uninstallBundleAsync(BundleContext bc, String symbolicName, Version version, long delay, TimeUnit timeUnit) {
        return BundleUtils.uninstallBundleAsync(BundleUtils.findBundle(bc, symbolicName, version), delay, timeUnit);
    }

    public static Future<?> updateBundleAsync(Bundle bundle) {
        return BundleUtils.updateBundleAsync(bundle, 0L);
    }

    public static Future<?> updateBundleAsync(BundleContext bc, long bundleId) {
        return BundleUtils.updateBundleAsync(bc, bundleId, 0L);
    }

    public static Future<?> updateBundleAsync(BundleContext bc, String symbolicName) {
        return BundleUtils.updateBundleAsync(bc, symbolicName, 0L);
    }

    public static Future<?> updateBundleAsync(BundleContext bc, String symbolicName, Version version) {
        return BundleUtils.updateBundleAsync(bc, symbolicName, version, 0L);
    }

    public static Future<?> updateBundleAsync(Bundle bundle, InputStream input) {
        return BundleUtils.updateBundleAsync(bundle, input, 0L);
    }

    public static Future<?> updateBundleAsync(BundleContext bc, long bundleId, InputStream input) {
        return BundleUtils.updateBundleAsync(bc, bundleId, input, 0L);
    }

    public static Future<?> updateBundleAsync(BundleContext bc, String symbolicName, InputStream input) {
        return BundleUtils.updateBundleAsync(bc, symbolicName, input, 0L);
    }

    public static Future<?> updateBundleAsync(BundleContext bc, String symbolicName, Version version, InputStream input) {
        return BundleUtils.updateBundleAsync(bc, symbolicName, version, input, 0L);
    }

    public static Future<?> updateBundleAsync(Bundle bundle, long delayInMillis) {
        return BundleUtils.updateBundleAsync(bundle, delayInMillis, TimeUnit.MILLISECONDS);
    }

    public static Future<?> updateBundleAsync(BundleContext bc, long bundleId, long delayInMillis) {
        return BundleUtils.updateBundleAsync(bc, bundleId, delayInMillis, TimeUnit.MILLISECONDS);
    }

    public static Future<?> updateBundleAsync(BundleContext bc, String symbolicName, long delayInMillis) {
        return BundleUtils.updateBundleAsync(bc, symbolicName, delayInMillis, TimeUnit.MILLISECONDS);
    }

    public static Future<?> updateBundleAsync(BundleContext bc, String symbolicName, Version version, long delayInMillis) {
        return BundleUtils.updateBundleAsync(bc, symbolicName, version, delayInMillis, TimeUnit.MILLISECONDS);
    }

    public static Future<?> updateBundleAsync(Bundle bundle, InputStream input, long delayInMillis) {
        return BundleUtils.updateBundleAsync(bundle, input, delayInMillis, TimeUnit.MILLISECONDS);
    }

    public static Future<?> updateBundleAsync(BundleContext bc, long bundleId, InputStream input, long delayInMillis) {
        return BundleUtils.updateBundleAsync(bc, bundleId, input, delayInMillis, TimeUnit.MILLISECONDS);
    }

    public static Future<?> updateBundleAsync(BundleContext bc, String symbolicName, InputStream input, long delayInMillis) {
        return BundleUtils.updateBundleAsync(bc, symbolicName, input, delayInMillis, TimeUnit.MILLISECONDS);
    }

    public static Future<?> updateBundleAsync(BundleContext bc, String symbolicName, Version version, InputStream input, long delayInMillis) {
        return BundleUtils.updateBundleAsync(bc, symbolicName, version, input, delayInMillis, TimeUnit.MILLISECONDS);
    }

    public static Future<?> updateBundleAsync(Bundle bundle, long delay, TimeUnit timeUnit) {
        return BundleUtils.updateBundleAsync(bundle, null, delay, timeUnit);
    }

    public static Future<?> updateBundleAsync(BundleContext bc, long bundleId, long delay, TimeUnit timeUnit) {
        return BundleUtils.updateBundleAsync(BundleUtils.findBundle(bc, bundleId), delay, timeUnit);
    }

    public static Future<?> updateBundleAsync(BundleContext bc, String symbolicName, long delay, TimeUnit timeUnit) {
        return BundleUtils.updateBundleAsync(BundleUtils.findBundle(bc, symbolicName), delay, timeUnit);
    }

    public static Future<?> updateBundleAsync(BundleContext bc, String symbolicName, Version version, long delay, TimeUnit timeUnit) {
        return BundleUtils.updateBundleAsync(BundleUtils.findBundle(bc, symbolicName, version), delay, timeUnit);
    }

    public static Future<?> updateBundleAsync(final Bundle bundle, final InputStream input, long delay, TimeUnit timeUnit) {
        return Executors.newSingleThreadScheduledExecutor().schedule(new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                bundle.update(input);
                return null;
            }
        }, delay, timeUnit);
    }

    public static Future<?> updateBundleAsync(BundleContext bc, long bundleId, InputStream input, long delay, TimeUnit timeUnit) {
        return BundleUtils.updateBundleAsync(BundleUtils.findBundle(bc, bundleId), input, delay, timeUnit);
    }

    public static Future<?> updateBundleAsync(BundleContext bc, String symbolicName, InputStream input, long delay, TimeUnit timeUnit) {
        return BundleUtils.updateBundleAsync(BundleUtils.findBundle(bc, symbolicName), input, delay, timeUnit);
    }

    public static Future<?> updateBundleAsync(BundleContext bc, String symbolicName, Version version, InputStream input, long delay, TimeUnit timeUnit) {
        return BundleUtils.updateBundleAsync(BundleUtils.findBundle(bc, symbolicName, version), input, delay, timeUnit);
    }

    public static BundleEvent waitForBundleEvent(BundleContext bc, int bundleId, int eventTypeMask, long timeoutInMillis) {
        return BundleUtils.waitForBundleEvent(bc, bundleId, eventTypeMask, timeoutInMillis, TimeUnit.MILLISECONDS);
    }

    public static BundleEvent waitForBundleEvent(BundleContext bc, String symbolicName, int eventTypeMask, long timeoutInMillis) {
        return BundleUtils.waitForBundleEvent(bc, symbolicName, eventTypeMask, timeoutInMillis, TimeUnit.MILLISECONDS);
    }

    public static BundleEvent waitForBundleEvent(BundleContext bc, String symbolicName, Version version, int eventTypeMask, long timeoutInMillis) {
        return BundleUtils.waitForBundleEvent(bc, symbolicName, version, eventTypeMask, timeoutInMillis, TimeUnit.MILLISECONDS);
    }

    public static BundleEvent waitForBundleEvent(BundleContext bc, int bundleId, int eventTypeMask, long timeout, TimeUnit timeUnit) {
        Bundle bundle = BundleUtils.findBundle(bc, bundleId);
        if (bundle == null) {
            throw new IllegalArgumentException("bundleId is invalid");
        }
        return BundleUtils.waitForBundleEvent(bc, bundle.getSymbolicName(), bundle.getVersion(), eventTypeMask, timeout, timeUnit);
    }

    public static BundleEvent waitForBundleEvent(BundleContext bc, String symbolicName, int eventTypeMask, long timeout, TimeUnit timeUnit) {
        return BundleUtils.waitForBundleEvent(bc, symbolicName, null, eventTypeMask, timeout, timeUnit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BundleEvent waitForBundleEvent(BundleContext bc, String symbolicName, Version version, int eventTypeMask, long timeout, TimeUnit timeUnit) {
        CountDownLatch latch = new CountDownLatch(1);
        long timeoutInMillis = timeUnit.toMillis(timeout);
        BundleListenerImpl listener = new BundleListenerImpl(symbolicName, version, eventTypeMask, latch);
        bc.addBundleListener((BundleListener)listener);
        try {
            BundleEvent bundleEvent = BundleUtils.waitForBundleEvent(listener, timeoutInMillis, latch);
            return bundleEvent;
        }
        catch (InterruptedException e) {
            BundleEvent bundleEvent = null;
            return bundleEvent;
        }
        finally {
            bc.removeBundleListener((BundleListener)listener);
        }
    }

    private static BundleEvent waitForBundleEvent(BundleListenerImpl listener, long timeoutInMillis, CountDownLatch latch) throws InterruptedException {
        if (timeoutInMillis < 0L) {
            throw new IllegalArgumentException("timeout value is negative");
        }
        if (latch.await(timeoutInMillis, TimeUnit.MILLISECONDS)) {
            return listener.getBundleEvent();
        }
        return null;
    }

    private static Bundle waitForBundle(BundleTracker tracker, long timeoutInMillis, CountDownLatch latch) throws InterruptedException {
        if (timeoutInMillis < 0L) {
            throw new IllegalArgumentException("timeout value is negative");
        }
        Bundle[] bundles = tracker.getBundles();
        if (bundles == null) {
            if (latch.await(timeoutInMillis, TimeUnit.MILLISECONDS)) {
                bundles = tracker.getBundles();
                return bundles == null ? null : bundles[0];
            }
            return null;
        }
        return bundles[0];
    }

    private static class BundleListenerImpl
    implements BundleListener {
        private String symbolicName;
        private Version version;
        private int eventTypeMask;
        private CountDownLatch latch;
        private BundleEvent event;

        public BundleListenerImpl(String symbolicName, Version version, int eventTypeMask, CountDownLatch latch) {
            this.symbolicName = symbolicName;
            this.version = version;
            this.eventTypeMask = eventTypeMask;
            this.latch = latch;
        }

        public void bundleChanged(BundleEvent event) {
            if (this.match(event)) {
                this.event = event;
                this.latch.countDown();
            }
        }

        private boolean match(BundleEvent event) {
            Bundle bundle = event.getBundle();
            return bundle.getSymbolicName().equals(this.symbolicName) && (this.version == null || bundle.getVersion().equals((Object)this.version)) && (this.eventTypeMask & event.getType()) != 0;
        }

        public BundleEvent getBundleEvent() {
            return this.event;
        }
    }

    private static class SymbolicNameVersionBundleTrackerCustomizer
    extends BundleTrackerCustomizerWithLock {
        private String symbolicName;
        private Version version;

        public SymbolicNameVersionBundleTrackerCustomizer(BundleContext bc, CountDownLatch latch, String symbolicName, Version version) {
            super(bc, latch);
            this.symbolicName = symbolicName;
            this.version = version;
        }

        protected Object isTrackedBundle(Bundle bundle, BundleEvent event) {
            return this.symbolicName.equals(bundle.getSymbolicName()) && (this.version == null || this.version.equals((Object)bundle.getVersion())) ? bundle : null;
        }
    }

    private static abstract class BundleTrackerCustomizerWithLock
    implements BundleTrackerCustomizer {
        protected final BundleContext bc;
        private CountDownLatch latch;

        public BundleTrackerCustomizerWithLock(BundleContext bc, CountDownLatch latch) {
            this.bc = bc;
            this.latch = latch;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object addingBundle(Bundle bundle, BundleEvent event) {
            boolean found = false;
            try {
                Object trackedBundle = this.isTrackedBundle(bundle, event);
                found = trackedBundle != null;
                Object object = trackedBundle;
                return object;
            }
            finally {
                if (found) {
                    this.latch.countDown();
                }
            }
        }

        protected abstract Object isTrackedBundle(Bundle var1, BundleEvent var2);

        public void modifiedBundle(Bundle bundle, BundleEvent event, Object object) {
        }

        public void removedBundle(Bundle bundle, BundleEvent event, Object object) {
        }
    }
}

