/*
 * Decompiled with CFR 0.152.
 */
package org.knowhowlab.osgi.testing.utils;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import org.knowhowlab.osgi.testing.utils.FilterUtils;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServiceUtils {
    private ServiceUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ServiceReference getServiceReference(BundleContext bc, Filter filter) {
        ServiceTracker tracker = new ServiceTracker(bc, filter, null);
        tracker.open();
        try {
            ServiceReference serviceReference = tracker.getServiceReference();
            return serviceReference;
        }
        finally {
            tracker.close();
        }
    }

    public static ServiceReference getServiceReference(BundleContext bc, Filter filter, long timeoutInMillis) {
        return ServiceUtils.getServiceReference(bc, filter, timeoutInMillis, TimeUnit.MILLISECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ServiceReference getServiceReference(BundleContext bc, Filter filter, long timeout, TimeUnit timeUnit) {
        ReentrantLock lock = new ReentrantLock();
        Condition condition = lock.newCondition();
        long timeoutInMillis = timeUnit.toMillis(timeout);
        ServiceTracker tracker = new ServiceTracker(bc, filter, (ServiceTrackerCustomizer)new ServiceTrackerCustomizerWithLock(bc, lock, condition));
        tracker.open();
        try {
            ServiceReference serviceReference = ServiceUtils.waitForServiceReference(tracker, timeoutInMillis, lock, condition);
            return serviceReference;
        }
        catch (InterruptedException e) {
            ServiceReference serviceReference = null;
            return serviceReference;
        }
        finally {
            tracker.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ServiceReference getServiceReference(BundleContext bc, String className) {
        ServiceTracker tracker = new ServiceTracker(bc, className, null);
        tracker.open();
        try {
            ServiceReference serviceReference = tracker.getServiceReference();
            return serviceReference;
        }
        finally {
            tracker.close();
        }
    }

    public static ServiceReference getServiceReference(BundleContext bc, String className, long timeoutInMillis) {
        return ServiceUtils.getServiceReference(bc, className, timeoutInMillis, TimeUnit.MILLISECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ServiceReference getServiceReference(BundleContext bc, String className, long timeout, TimeUnit timeUnit) {
        ReentrantLock lock = new ReentrantLock();
        Condition condition = lock.newCondition();
        long timeoutInMillis = timeUnit.toMillis(timeout);
        ServiceTracker tracker = new ServiceTracker(bc, className, (ServiceTrackerCustomizer)new ServiceTrackerCustomizerWithLock(bc, lock, condition));
        tracker.open();
        try {
            ServiceReference serviceReference = ServiceUtils.waitForServiceReference(tracker, timeoutInMillis, lock, condition);
            return serviceReference;
        }
        catch (InterruptedException e) {
            ServiceReference serviceReference = null;
            return serviceReference;
        }
        finally {
            tracker.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ServiceReference getServiceReference(BundleContext bc, Class clazz) {
        ServiceTracker tracker = new ServiceTracker(bc, clazz.getName(), null);
        tracker.open();
        try {
            ServiceReference serviceReference = tracker.getServiceReference();
            return serviceReference;
        }
        finally {
            tracker.close();
        }
    }

    public static ServiceReference getServiceReference(BundleContext bc, Class clazz, long timeoutInMillis) {
        return ServiceUtils.getServiceReference(bc, clazz, timeoutInMillis, TimeUnit.MILLISECONDS);
    }

    public static ServiceReference getServiceReference(BundleContext bc, Class clazz, long timeout, TimeUnit timeUnit) {
        return ServiceUtils.getServiceReference(bc, clazz.getName(), timeout, timeUnit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object getService(BundleContext bc, Filter filter) {
        ServiceTracker tracker = new ServiceTracker(bc, filter, null);
        tracker.open();
        try {
            Object object = tracker.getService();
            return object;
        }
        finally {
            tracker.close();
        }
    }

    public static Object getService(BundleContext bc, Filter filter, long timeoutInMillis) {
        return ServiceUtils.getService(bc, filter, timeoutInMillis, TimeUnit.MILLISECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object getService(BundleContext bc, Filter filter, long timeout, TimeUnit timeUnit) {
        ServiceTracker tracker = new ServiceTracker(bc, filter, null);
        tracker.open();
        try {
            Object object = tracker.waitForService(timeUnit.toMillis(timeout));
            return object;
        }
        catch (InterruptedException e) {
            Object var7_7 = null;
            return var7_7;
        }
        finally {
            tracker.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object getService(BundleContext bc, String className) {
        ServiceTracker tracker = new ServiceTracker(bc, className, null);
        tracker.open();
        try {
            Object object = tracker.getService();
            return object;
        }
        finally {
            tracker.close();
        }
    }

    public static Object getService(BundleContext bc, String className, long timeoutInMillis) {
        return ServiceUtils.getService(bc, className, timeoutInMillis, TimeUnit.MILLISECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object getService(BundleContext bc, String className, long timeout, TimeUnit timeUnit) {
        ServiceTracker tracker = new ServiceTracker(bc, className, null);
        tracker.open();
        try {
            Object object = tracker.waitForService(timeUnit.toMillis(timeout));
            return object;
        }
        catch (InterruptedException e) {
            Object var7_7 = null;
            return var7_7;
        }
        finally {
            tracker.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T getService(BundleContext bc, Class<T> clazz) {
        ServiceTracker tracker = new ServiceTracker(bc, clazz.getName(), null);
        tracker.open();
        try {
            Object object = tracker.getService();
            return (T)object;
        }
        finally {
            tracker.close();
        }
    }

    public static <T> T getService(BundleContext bc, Class<T> clazz, long timeoutInMillis) {
        return ServiceUtils.getService(bc, clazz, timeoutInMillis, TimeUnit.MILLISECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T getService(BundleContext bc, Class<T> clazz, long timeout, TimeUnit timeUnit) {
        ServiceTracker tracker = new ServiceTracker(bc, clazz.getName(), null);
        tracker.open();
        try {
            Object object = tracker.waitForService(timeUnit.toMillis(timeout));
            return (T)object;
        }
        catch (InterruptedException e) {
            T t = null;
            return t;
        }
        finally {
            tracker.close();
        }
    }

    public static <T> T getService(BundleContext bc, Class<T> clazz, String filter) throws InvalidSyntaxException {
        return ServiceUtils.getService(bc, clazz, FrameworkUtil.createFilter((String)filter));
    }

    public static <T> T getService(BundleContext bc, Class<T> clazz, String filter, long timeoutInMillis) throws InvalidSyntaxException {
        return ServiceUtils.getService(bc, clazz, filter, timeoutInMillis, TimeUnit.MILLISECONDS);
    }

    public static <T> T getService(BundleContext bc, Class<T> clazz, String filter, long timeout, TimeUnit timeUnit) throws InvalidSyntaxException {
        return ServiceUtils.getService(bc, clazz, FrameworkUtil.createFilter((String)filter), timeout, timeUnit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T getService(BundleContext bc, Class<T> clazz, Filter filter) throws InvalidSyntaxException {
        ServiceTracker tracker = new ServiceTracker(bc, FilterUtils.create(clazz, filter), null);
        tracker.open();
        try {
            Object object = tracker.getService();
            return (T)object;
        }
        finally {
            tracker.close();
        }
    }

    public static <T> T getService(BundleContext bc, Class<T> clazz, Filter filter, long timeoutInMillis) throws InvalidSyntaxException {
        return ServiceUtils.getService(bc, clazz, filter, timeoutInMillis, TimeUnit.MILLISECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T getService(BundleContext bc, Class<T> clazz, Filter filter, long timeout, TimeUnit timeUnit) throws InvalidSyntaxException {
        ServiceTracker tracker = new ServiceTracker(bc, FilterUtils.create(clazz, filter), null);
        tracker.open();
        try {
            Object object = tracker.waitForService(timeUnit.toMillis(timeout));
            return (T)object;
        }
        catch (InterruptedException e) {
            T t = null;
            return t;
        }
        finally {
            tracker.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ServiceReference waitForServiceReference(ServiceTracker tracker, long timeoutInMillis, ReentrantLock lock, Condition condition) throws InterruptedException {
        if (timeoutInMillis < 0L) {
            throw new IllegalArgumentException("timeout value is negative");
        }
        try {
            lock.lock();
            ServiceReference reference = tracker.getServiceReference();
            if (reference == null) {
                condition.await(timeoutInMillis, TimeUnit.MILLISECONDS);
                ServiceReference serviceReference = tracker.getServiceReference();
                return serviceReference;
            }
            ServiceReference serviceReference = reference;
            return serviceReference;
        }
        finally {
            lock.unlock();
        }
    }

    private static class ServiceTrackerCustomizerWithLock
    implements ServiceTrackerCustomizer {
        private final BundleContext bc;
        private final ReentrantLock lock;
        private final Condition condition;

        public ServiceTrackerCustomizerWithLock(BundleContext bc, ReentrantLock lock, Condition condition) {
            this.bc = bc;
            this.lock = lock;
            this.condition = condition;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object addingService(ServiceReference serviceReference) {
            try {
                this.lock.lock();
                try {
                    Object object = this.bc.getService(serviceReference);
                    this.condition.signalAll();
                    return object;
                }
                catch (Throwable throwable) {
                    this.condition.signalAll();
                    throw throwable;
                }
            }
            finally {
                this.lock.unlock();
            }
        }

        public void modifiedService(ServiceReference serviceReference, Object o) {
        }

        public void removedService(ServiceReference serviceReference, Object o) {
        }
    }
}

