/*
 * Decompiled with CFR 0.152.
 */
package org.knowhowlab.osgi.testing.utils;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.knowhowlab.osgi.testing.utils.ServiceUtils;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.Version;
import org.osgi.service.packageadmin.PackageAdmin;
import org.osgi.util.tracker.BundleTracker;
import org.osgi.util.tracker.BundleTrackerCustomizer;

public class BundleUtils {
    public static final int ANY_STATE = 63;

    private BundleUtils() {
    }

    public static Bundle findBundle(BundleContext bc, long bundleId) {
        return bc.getBundle(bundleId);
    }

    public static Bundle findBundle(BundleContext bc, String symbolicName) {
        return BundleUtils.findBundle(bc, symbolicName, null);
    }

    public static Bundle findBundle(BundleContext bc, String symbolicName, Version version) {
        Bundle[] bundles;
        PackageAdmin packageAdmin = ServiceUtils.getService(bc, PackageAdmin.class);
        if (packageAdmin != null && (bundles = packageAdmin.getBundles(symbolicName, version != null ? version.toString() : null)) != null && bundles.length > 0) {
            return bundles[0];
        }
        return null;
    }

    public static Bundle findBundle(BundleContext bc, String symbolicName, Version version, long timeoutInMillis) {
        return BundleUtils.findBundle(bc, symbolicName, version, timeoutInMillis, TimeUnit.MILLISECONDS);
    }

    public static Bundle findBundle(BundleContext bc, String symbolicName, Version version, int stateMask, long timeoutInMillis) {
        return BundleUtils.findBundle(bc, symbolicName, version, stateMask, timeoutInMillis, TimeUnit.MILLISECONDS);
    }

    public static Bundle findBundle(BundleContext bc, String symbolicName, long timeoutInMillis) {
        return BundleUtils.findBundle(bc, symbolicName, null, timeoutInMillis, TimeUnit.MILLISECONDS);
    }

    public static Bundle findBundle(BundleContext bc, String symbolicName, int stateMask, long timeoutInMillis) {
        return BundleUtils.findBundle(bc, symbolicName, null, stateMask, timeoutInMillis, TimeUnit.MILLISECONDS);
    }

    public static Bundle findBundle(BundleContext bc, String symbolicName, long timeout, TimeUnit timeUnit) {
        return BundleUtils.findBundle(bc, symbolicName, null, timeout, timeUnit);
    }

    public static Bundle findBundle(BundleContext bc, String symbolicName, int stateMask, long timeout, TimeUnit timeUnit) {
        return BundleUtils.findBundle(bc, symbolicName, null, stateMask, timeout, timeUnit);
    }

    public static Bundle findBundle(BundleContext bc, String symbolicName, Version version, long timeout, TimeUnit timeUnit) {
        return BundleUtils.findBundle(bc, symbolicName, version, 63, timeout, timeUnit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Bundle findBundle(BundleContext bc, String symbolicName, Version version, int stateMask, long timeout, TimeUnit timeUnit) {
        CountDownLatch latch = new CountDownLatch(1);
        long timeoutInMillis = timeUnit.toMillis(timeout);
        BundleTracker tracker = new BundleTracker(bc, stateMask, (BundleTrackerCustomizer)new SymbolicNameVersionBundleTrackerCustomizer(bc, latch, symbolicName, version));
        tracker.open();
        try {
            Bundle bundle = BundleUtils.waitForBundle(tracker, timeoutInMillis, latch);
            return bundle;
        }
        catch (InterruptedException e) {
            Bundle bundle = null;
            return bundle;
        }
        finally {
            tracker.close();
        }
    }

    private static Bundle waitForBundle(BundleTracker tracker, long timeoutInMillis, CountDownLatch latch) throws InterruptedException {
        if (timeoutInMillis < 0L) {
            throw new IllegalArgumentException("timeout value is negative");
        }
        Bundle[] bundles = tracker.getBundles();
        if (bundles == null) {
            if (latch.await(timeoutInMillis, TimeUnit.MILLISECONDS)) {
                bundles = tracker.getBundles();
                return bundles == null ? null : bundles[0];
            }
            return null;
        }
        return bundles[0];
    }

    private static class SymbolicNameVersionBundleTrackerCustomizer
    extends BundleTrackerCustomizerWithLock {
        private String symbolicName;
        private Version version;

        public SymbolicNameVersionBundleTrackerCustomizer(BundleContext bc, CountDownLatch latch, String symbolicName, Version version) {
            super(bc, latch);
            this.symbolicName = symbolicName;
            this.version = version;
        }

        protected Object isTrackedBundle(Bundle bundle, BundleEvent event) {
            Bundle[] bundles;
            PackageAdmin packageAdmin = ServiceUtils.getService(this.bc, PackageAdmin.class);
            if (packageAdmin != null && (bundles = packageAdmin.getBundles(this.symbolicName, this.version != null ? this.version.toString() : null)) != null && bundles.length > 0) {
                return bundles[0];
            }
            return null;
        }
    }

    private static abstract class BundleTrackerCustomizerWithLock
    implements BundleTrackerCustomizer {
        protected final BundleContext bc;
        private CountDownLatch latch;

        public BundleTrackerCustomizerWithLock(BundleContext bc, CountDownLatch latch) {
            this.bc = bc;
            this.latch = latch;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object addingBundle(Bundle bundle, BundleEvent event) {
            boolean found = false;
            try {
                Object trackedBundle = this.isTrackedBundle(bundle, event);
                found = trackedBundle != null;
                Object object = trackedBundle;
                return object;
            }
            finally {
                if (found) {
                    this.latch.countDown();
                }
            }
        }

        protected abstract Object isTrackedBundle(Bundle var1, BundleEvent var2);

        public void modifiedBundle(Bundle bundle, BundleEvent event, Object object) {
        }

        public void removedBundle(Bundle bundle, BundleEvent event, Object object) {
        }
    }
}

