/*
 * Decompiled with CFR 0.152.
 */
package org.knowhowlab.osgi.testing.utils;

import org.osgi.framework.Filter;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;

public class FilterUtils {
    private static final String EQUALS_FILTER_TEMPLATE = "(%s=%s)";
    private static final String APPROX_FILTER_TEMPLATE = "(%s~=%s)";
    private static final String GE_FILTER_TEMPLATE = "(%s>=%s)";
    private static final String LE_FILTER_TEMPLATE = "(%s<=%s)";
    private static final String PRESENT_FILTER_TEMPLATE = "(%s=*)";
    private static final String NOT_TEMPLATE = "(!%s)";
    private static final String AND_TEMPLATE = "(&%s%s)";
    private static final String OR_TEMPLATE = "(|%s%s)";

    private FilterUtils() {
    }

    public static Filter create(Class clazz, Filter filter) throws InvalidSyntaxException {
        return FilterUtils.and(FilterUtils.create(clazz), filter);
    }

    public static Filter create(Class clazz, String filter) throws InvalidSyntaxException {
        return FilterUtils.and(FilterUtils.create(clazz), filter);
    }

    public static Filter create(Class clazz) throws InvalidSyntaxException {
        return FilterUtils.eq("objectClass", clazz.getName());
    }

    public static Filter create(String className, Filter filter) throws InvalidSyntaxException {
        return FilterUtils.and(FilterUtils.create(className), filter);
    }

    public static Filter create(String className, String filter) throws InvalidSyntaxException {
        return FilterUtils.and(FilterUtils.create(className), filter);
    }

    public static Filter create(String className) throws InvalidSyntaxException {
        return FilterUtils.eq("objectClass", className);
    }

    public static Filter and(String filter1, String filter2) throws InvalidSyntaxException {
        return FrameworkUtil.createFilter((String)String.format(AND_TEMPLATE, filter1, filter2));
    }

    public static Filter and(Filter filter1, String filter2) throws InvalidSyntaxException {
        return FrameworkUtil.createFilter((String)String.format(AND_TEMPLATE, filter1, filter2));
    }

    public static Filter and(Filter filter1, Filter filter2) throws InvalidSyntaxException {
        return FrameworkUtil.createFilter((String)String.format(AND_TEMPLATE, filter1, filter2));
    }

    public static Filter or(String filter1, String filter2) throws InvalidSyntaxException {
        return FrameworkUtil.createFilter((String)String.format(OR_TEMPLATE, filter1, filter2));
    }

    public static Filter or(Filter filter1, String filter2) throws InvalidSyntaxException {
        return FrameworkUtil.createFilter((String)String.format(OR_TEMPLATE, filter1, filter2));
    }

    public static Filter or(Filter filter1, Filter filter2) throws InvalidSyntaxException {
        return FrameworkUtil.createFilter((String)String.format(OR_TEMPLATE, filter1, filter2));
    }

    public static Filter not(String filter) throws InvalidSyntaxException {
        return FrameworkUtil.createFilter((String)String.format(NOT_TEMPLATE, filter));
    }

    public static Filter not(Filter filter) throws InvalidSyntaxException {
        return FrameworkUtil.createFilter((String)String.format(NOT_TEMPLATE, filter));
    }

    public static Filter eq(String key, Object value) throws InvalidSyntaxException {
        return FrameworkUtil.createFilter((String)String.format(EQUALS_FILTER_TEMPLATE, key, value));
    }

    public static Filter approx(String key, Object value) throws InvalidSyntaxException {
        return FrameworkUtil.createFilter((String)String.format(APPROX_FILTER_TEMPLATE, key, value));
    }

    public static Filter ge(String key, Object value) throws InvalidSyntaxException {
        return FrameworkUtil.createFilter((String)String.format(GE_FILTER_TEMPLATE, key, value));
    }

    public static Filter le(String key, Object value) throws InvalidSyntaxException {
        return FrameworkUtil.createFilter((String)String.format(LE_FILTER_TEMPLATE, key, value));
    }

    public static Filter present(String key) throws InvalidSyntaxException {
        return FrameworkUtil.createFilter((String)String.format(PRESENT_FILTER_TEMPLATE, key));
    }
}

