/*
 * Decompiled with CFR 0.152.
 */
package org.knowhowlab.osgi.testing.utils;

import java.util.Dictionary;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.knowhowlab.osgi.testing.utils.FilterUtils;
import org.osgi.framework.AllServiceListener;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServiceUtils {
    private ServiceUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ServiceReference getServiceReference(BundleContext bc, Filter filter) {
        ServiceTracker tracker = new ServiceTracker(bc, filter, null);
        tracker.open();
        try {
            ServiceReference serviceReference = tracker.getServiceReference();
            return serviceReference;
        }
        finally {
            tracker.close();
        }
    }

    public static ServiceReference getServiceReference(BundleContext bc, Filter filter, long timeoutInMillis) {
        return ServiceUtils.getServiceReference(bc, filter, timeoutInMillis, TimeUnit.MILLISECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ServiceReference getServiceReference(BundleContext bc, Filter filter, long timeout, TimeUnit timeUnit) {
        CountDownLatch latch = new CountDownLatch(1);
        long timeoutInMillis = timeUnit.toMillis(timeout);
        ServiceTracker tracker = new ServiceTracker(bc, filter, (ServiceTrackerCustomizer)new ServiceTrackerCustomizerWithLock(bc, latch));
        tracker.open();
        try {
            ServiceReference serviceReference = ServiceUtils.waitForServiceReference(tracker, timeoutInMillis, latch);
            return serviceReference;
        }
        catch (InterruptedException e) {
            ServiceReference serviceReference = null;
            return serviceReference;
        }
        finally {
            tracker.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ServiceReference getServiceReference(BundleContext bc, String className) {
        ServiceTracker tracker = new ServiceTracker(bc, className, null);
        tracker.open();
        try {
            ServiceReference serviceReference = tracker.getServiceReference();
            return serviceReference;
        }
        finally {
            tracker.close();
        }
    }

    public static ServiceReference getServiceReference(BundleContext bc, String className, long timeoutInMillis) {
        return ServiceUtils.getServiceReference(bc, className, timeoutInMillis, TimeUnit.MILLISECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ServiceReference getServiceReference(BundleContext bc, String className, long timeout, TimeUnit timeUnit) {
        CountDownLatch latch = new CountDownLatch(1);
        long timeoutInMillis = timeUnit.toMillis(timeout);
        ServiceTracker tracker = new ServiceTracker(bc, className, (ServiceTrackerCustomizer)new ServiceTrackerCustomizerWithLock(bc, latch));
        tracker.open();
        try {
            ServiceReference serviceReference = ServiceUtils.waitForServiceReference(tracker, timeoutInMillis, latch);
            return serviceReference;
        }
        catch (InterruptedException e) {
            ServiceReference serviceReference = null;
            return serviceReference;
        }
        finally {
            tracker.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ServiceReference getServiceReference(BundleContext bc, Class clazz) {
        ServiceTracker tracker = new ServiceTracker(bc, clazz.getName(), null);
        tracker.open();
        try {
            ServiceReference serviceReference = tracker.getServiceReference();
            return serviceReference;
        }
        finally {
            tracker.close();
        }
    }

    public static ServiceReference getServiceReference(BundleContext bc, Class clazz, long timeoutInMillis) {
        return ServiceUtils.getServiceReference(bc, clazz, timeoutInMillis, TimeUnit.MILLISECONDS);
    }

    public static ServiceReference getServiceReference(BundleContext bc, Class clazz, long timeout, TimeUnit timeUnit) {
        return ServiceUtils.getServiceReference(bc, clazz.getName(), timeout, timeUnit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object getService(BundleContext bc, Filter filter) {
        ServiceTracker tracker = new ServiceTracker(bc, filter, null);
        tracker.open();
        try {
            Object object = tracker.getService();
            return object;
        }
        finally {
            tracker.close();
        }
    }

    public static Object getService(BundleContext bc, Filter filter, long timeoutInMillis) {
        return ServiceUtils.getService(bc, filter, timeoutInMillis, TimeUnit.MILLISECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object getService(BundleContext bc, Filter filter, long timeout, TimeUnit timeUnit) {
        ServiceTracker tracker = new ServiceTracker(bc, filter, null);
        tracker.open();
        try {
            Object object = tracker.waitForService(timeUnit.toMillis(timeout));
            return object;
        }
        catch (InterruptedException e) {
            Object var7_7 = null;
            return var7_7;
        }
        finally {
            tracker.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object getService(BundleContext bc, String className) {
        ServiceTracker tracker = new ServiceTracker(bc, className, null);
        tracker.open();
        try {
            Object object = tracker.getService();
            return object;
        }
        finally {
            tracker.close();
        }
    }

    public static Object getService(BundleContext bc, String className, long timeoutInMillis) {
        return ServiceUtils.getService(bc, className, timeoutInMillis, TimeUnit.MILLISECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object getService(BundleContext bc, String className, long timeout, TimeUnit timeUnit) {
        ServiceTracker tracker = new ServiceTracker(bc, className, null);
        tracker.open();
        try {
            Object object = tracker.waitForService(timeUnit.toMillis(timeout));
            return object;
        }
        catch (InterruptedException e) {
            Object var7_7 = null;
            return var7_7;
        }
        finally {
            tracker.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T getService(BundleContext bc, Class<T> clazz) {
        ServiceTracker tracker = new ServiceTracker(bc, clazz.getName(), null);
        tracker.open();
        try {
            Object object = tracker.getService();
            return (T)object;
        }
        finally {
            tracker.close();
        }
    }

    public static <T> T getService(BundleContext bc, Class<T> clazz, long timeoutInMillis) {
        return ServiceUtils.getService(bc, clazz, timeoutInMillis, TimeUnit.MILLISECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T getService(BundleContext bc, Class<T> clazz, long timeout, TimeUnit timeUnit) {
        ServiceTracker tracker = new ServiceTracker(bc, clazz.getName(), null);
        tracker.open();
        try {
            Object object = tracker.waitForService(timeUnit.toMillis(timeout));
            return (T)object;
        }
        catch (InterruptedException e) {
            T t = null;
            return t;
        }
        finally {
            tracker.close();
        }
    }

    public static <T> T getService(BundleContext bc, Class<T> clazz, String filter) throws InvalidSyntaxException {
        return ServiceUtils.getService(bc, clazz, FrameworkUtil.createFilter((String)filter));
    }

    public static <T> T getService(BundleContext bc, Class<T> clazz, String filter, long timeoutInMillis) throws InvalidSyntaxException {
        return ServiceUtils.getService(bc, clazz, filter, timeoutInMillis, TimeUnit.MILLISECONDS);
    }

    public static <T> T getService(BundleContext bc, Class<T> clazz, String filter, long timeout, TimeUnit timeUnit) throws InvalidSyntaxException {
        return ServiceUtils.getService(bc, clazz, FrameworkUtil.createFilter((String)filter), timeout, timeUnit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T getService(BundleContext bc, Class<T> clazz, Filter filter) throws InvalidSyntaxException {
        ServiceTracker tracker = new ServiceTracker(bc, FilterUtils.create(clazz, filter), null);
        tracker.open();
        try {
            Object object = tracker.getService();
            return (T)object;
        }
        finally {
            tracker.close();
        }
    }

    public static <T> T getService(BundleContext bc, Class<T> clazz, Filter filter, long timeoutInMillis) throws InvalidSyntaxException {
        return ServiceUtils.getService(bc, clazz, filter, timeoutInMillis, TimeUnit.MILLISECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T getService(BundleContext bc, Class<T> clazz, Filter filter, long timeout, TimeUnit timeUnit) throws InvalidSyntaxException {
        ServiceTracker tracker = new ServiceTracker(bc, FilterUtils.create(clazz, filter), null);
        tracker.open();
        try {
            Object object = tracker.waitForService(timeUnit.toMillis(timeout));
            return (T)object;
        }
        catch (InterruptedException e) {
            T t = null;
            return t;
        }
        finally {
            tracker.close();
        }
    }

    public static <T> Future<ServiceRegistration> registerServiceAsync(BundleContext bc, Class<T> clazz, T service, Dictionary properties) {
        return ServiceUtils.registerServiceAsync(bc, clazz, service, properties, 0L);
    }

    public static Future<ServiceRegistration> registerServiceAsync(BundleContext bc, String clazz, Object service, Dictionary properties) {
        return ServiceUtils.registerServiceAsync(bc, clazz, service, properties, 0L);
    }

    public static Future<ServiceRegistration> registerServiceAsync(BundleContext bc, String[] clazzes, Object service, Dictionary properties) {
        return ServiceUtils.registerServiceAsync(bc, clazzes, service, properties, 0L);
    }

    public static <T> Future<ServiceRegistration> registerServiceAsync(BundleContext bc, Class<T> clazz, T service, Dictionary properties, long delayInMillis) {
        return ServiceUtils.registerServiceAsync(bc, clazz, service, properties, delayInMillis, TimeUnit.MILLISECONDS);
    }

    public static Future<ServiceRegistration> registerServiceAsync(BundleContext bc, String clazz, Object service, Dictionary properties, long delayInMillis) {
        return ServiceUtils.registerServiceAsync(bc, clazz, service, properties, delayInMillis, TimeUnit.MILLISECONDS);
    }

    public static Future<ServiceRegistration> registerServiceAsync(BundleContext bc, String[] clazzes, Object service, Dictionary properties, long delayInMillis) {
        return ServiceUtils.registerServiceAsync(bc, clazzes, service, properties, delayInMillis, TimeUnit.MILLISECONDS);
    }

    public static <T> Future<ServiceRegistration> registerServiceAsync(final BundleContext bc, final Class<T> clazz, final T service, final Dictionary properties, long delay, TimeUnit timeUnit) {
        return Executors.newSingleThreadScheduledExecutor().schedule(new Callable<ServiceRegistration>(){

            @Override
            public ServiceRegistration call() throws Exception {
                return bc.registerService(clazz.getName(), service, properties);
            }
        }, delay, timeUnit);
    }

    public static Future<ServiceRegistration> registerServiceAsync(final BundleContext bc, final String clazz, final Object service, final Dictionary properties, long delay, TimeUnit timeUnit) {
        return Executors.newSingleThreadScheduledExecutor().schedule(new Callable<ServiceRegistration>(){

            @Override
            public ServiceRegistration call() throws Exception {
                return bc.registerService(clazz, service, properties);
            }
        }, delay, timeUnit);
    }

    public static Future<ServiceRegistration> registerServiceAsync(final BundleContext bc, final String[] clazzes, final Object service, final Dictionary properties, long delay, TimeUnit timeUnit) {
        return Executors.newSingleThreadScheduledExecutor().schedule(new Callable<ServiceRegistration>(){

            @Override
            public ServiceRegistration call() throws Exception {
                return bc.registerService(clazzes, service, properties);
            }
        }, delay, timeUnit);
    }

    public static Future<?> updateServiceAsync(ServiceRegistration registration, Dictionary properties) {
        return ServiceUtils.updateServiceAsync(registration, properties, 0L);
    }

    public static Future<?> updateServiceAsync(ServiceRegistration registration, Dictionary properties, long delayInMillis) {
        return ServiceUtils.updateServiceAsync(registration, properties, delayInMillis, TimeUnit.MILLISECONDS);
    }

    public static Future<?> updateServiceAsync(final ServiceRegistration registration, final Dictionary properties, long delay, TimeUnit timeUnit) {
        return Executors.newSingleThreadScheduledExecutor().schedule(new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                registration.setProperties(properties);
                return null;
            }
        }, delay, timeUnit);
    }

    public static Future<?> unregisterServiceAsync(ServiceRegistration registration) {
        return ServiceUtils.unregisterServiceAsync(registration, 0L);
    }

    public static Future<?> unregisterServiceAsync(ServiceRegistration registration, long delayInMillis) {
        return ServiceUtils.unregisterServiceAsync(registration, delayInMillis, TimeUnit.MILLISECONDS);
    }

    public static Future<?> unregisterServiceAsync(final ServiceRegistration registration, long delay, TimeUnit timeUnit) {
        return Executors.newSingleThreadScheduledExecutor().schedule(new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                registration.unregister();
                return null;
            }
        }, delay, timeUnit);
    }

    public static ServiceEvent waitForServiceEvent(BundleContext bc, Filter filter, int eventTypeMask, long timeoutInMillis) throws InvalidSyntaxException {
        return ServiceUtils.waitForServiceEvent(bc, filter, eventTypeMask, timeoutInMillis, TimeUnit.MILLISECONDS);
    }

    public static ServiceEvent waitForServiceEvent(BundleContext bc, String className, int eventTypeMask, long timeoutInMillis) throws InvalidSyntaxException {
        return ServiceUtils.waitForServiceEvent(bc, className, eventTypeMask, timeoutInMillis, TimeUnit.MILLISECONDS);
    }

    public static ServiceEvent waitForServiceEvent(BundleContext bc, Class clazz, int eventTypeMask, long timeoutInMillis) throws InvalidSyntaxException {
        return ServiceUtils.waitForServiceEvent(bc, clazz, eventTypeMask, timeoutInMillis, TimeUnit.MILLISECONDS);
    }

    public static ServiceEvent waitForServiceEvent(BundleContext bc, String className, int eventTypeMask, long timeout, TimeUnit timeUnit) throws InvalidSyntaxException {
        return ServiceUtils.waitForServiceEvent(bc, className, eventTypeMask, false, timeout, timeUnit);
    }

    public static ServiceEvent waitForServiceEvent(BundleContext bc, Class clazz, int eventTypeMask, long timeout, TimeUnit timeUnit) throws InvalidSyntaxException {
        return ServiceUtils.waitForServiceEvent(bc, clazz, eventTypeMask, false, timeout, timeUnit);
    }

    public static ServiceEvent waitForServiceEvent(BundleContext bc, Filter filter, int eventTypeMask, long timeout, TimeUnit timeUnit) throws InvalidSyntaxException {
        return ServiceUtils.waitForServiceEvent(bc, filter, eventTypeMask, false, timeout, timeUnit);
    }

    public static ServiceEvent waitForServiceEvent(BundleContext bc, Filter filter, int eventTypeMask, boolean all, long timeoutInMillis) throws InvalidSyntaxException {
        return ServiceUtils.waitForServiceEvent(bc, filter, eventTypeMask, all, timeoutInMillis, TimeUnit.MILLISECONDS);
    }

    public static ServiceEvent waitForServiceEvent(BundleContext bc, String className, int eventTypeMask, boolean all, long timeoutInMillis) throws InvalidSyntaxException {
        return ServiceUtils.waitForServiceEvent(bc, className, eventTypeMask, all, timeoutInMillis, TimeUnit.MILLISECONDS);
    }

    public static ServiceEvent waitForServiceEvent(BundleContext bc, Class clazz, int eventTypeMask, boolean all, long timeoutInMillis) throws InvalidSyntaxException {
        return ServiceUtils.waitForServiceEvent(bc, clazz, eventTypeMask, all, timeoutInMillis, TimeUnit.MILLISECONDS);
    }

    public static ServiceEvent waitForServiceEvent(BundleContext bc, String className, int eventTypeMask, boolean all, long timeout, TimeUnit timeUnit) throws InvalidSyntaxException {
        Filter filter = null;
        if (className != null) {
            filter = FilterUtils.create(className);
        }
        return ServiceUtils.waitForServiceEvent(bc, filter, eventTypeMask, all, timeout, timeUnit);
    }

    public static ServiceEvent waitForServiceEvent(BundleContext bc, Class clazz, int eventTypeMask, boolean all, long timeout, TimeUnit timeUnit) throws InvalidSyntaxException {
        Filter filter = null;
        if (clazz != null) {
            filter = FilterUtils.create(clazz);
        }
        return ServiceUtils.waitForServiceEvent(bc, filter, eventTypeMask, all, timeout, timeUnit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ServiceEvent waitForServiceEvent(BundleContext bc, Filter filter, int eventTypeMask, boolean all, long timeout, TimeUnit timeUnit) throws InvalidSyntaxException {
        CountDownLatch latch = new CountDownLatch(1);
        long timeoutInMillis = timeUnit.toMillis(timeout);
        ServiceListenerImpl listener = all ? new AllServiceListenerImpl(eventTypeMask, latch) : new ServiceListenerImpl(eventTypeMask, latch);
        bc.addServiceListener((ServiceListener)listener, filter != null ? filter.toString() : null);
        try {
            ServiceEvent serviceEvent = ServiceUtils.waitForServiceEvent(listener, timeoutInMillis, latch);
            return serviceEvent;
        }
        catch (InterruptedException e) {
            ServiceEvent serviceEvent = null;
            return serviceEvent;
        }
        finally {
            bc.removeServiceListener((ServiceListener)listener);
        }
    }

    private static ServiceEvent waitForServiceEvent(ServiceListenerImpl listener, long timeoutInMillis, CountDownLatch latch) throws InterruptedException {
        if (timeoutInMillis < 0L) {
            throw new IllegalArgumentException("timeout value is negative");
        }
        if (latch.await(timeoutInMillis, TimeUnit.MILLISECONDS)) {
            return listener.getServiceEvent();
        }
        return null;
    }

    private static ServiceReference waitForServiceReference(ServiceTracker tracker, long timeoutInMillis, CountDownLatch latch) throws InterruptedException {
        if (timeoutInMillis < 0L) {
            throw new IllegalArgumentException("timeout value is negative");
        }
        ServiceReference reference = tracker.getServiceReference();
        if (reference == null) {
            if (latch.await(timeoutInMillis, TimeUnit.MILLISECONDS)) {
                return tracker.getServiceReference();
            }
            return null;
        }
        return reference;
    }

    private static class AllServiceListenerImpl
    extends ServiceListenerImpl
    implements AllServiceListener {
        public AllServiceListenerImpl(int eventTypeMask, CountDownLatch latch) {
            super(eventTypeMask, latch);
        }
    }

    private static class ServiceListenerImpl
    implements ServiceListener {
        private int eventTypeMask;
        private CountDownLatch latch;
        private ServiceEvent event;

        public ServiceListenerImpl(int eventTypeMask, CountDownLatch latch) {
            this.eventTypeMask = eventTypeMask;
            this.latch = latch;
        }

        public void serviceChanged(ServiceEvent event) {
            if (this.match(event)) {
                this.event = event;
                this.latch.countDown();
            }
        }

        private boolean match(ServiceEvent event) {
            return (this.eventTypeMask & event.getType()) != 0;
        }

        public ServiceEvent getServiceEvent() {
            return this.event;
        }
    }

    private static class ServiceTrackerCustomizerWithLock
    implements ServiceTrackerCustomizer {
        private final BundleContext bc;
        private final CountDownLatch latch;

        public ServiceTrackerCustomizerWithLock(BundleContext bc, CountDownLatch latch) {
            this.bc = bc;
            this.latch = latch;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object addingService(ServiceReference serviceReference) {
            try {
                Object object = this.bc.getService(serviceReference);
                return object;
            }
            finally {
                this.latch.countDown();
            }
        }

        public void modifiedService(ServiceReference serviceReference, Object o) {
        }

        public void removedService(ServiceReference serviceReference, Object o) {
        }
    }
}

