/*
 * Decompiled with CFR 0.152.
 */
package org.knowhowlab.osgi.testing.utils;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.knowhowlab.osgi.testing.utils.BundleUtils;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkEvent;
import org.osgi.framework.FrameworkListener;
import org.osgi.framework.Version;

public class FrameworkUtils {
    private FrameworkUtils() {
    }

    public static FrameworkEvent waitForFrameworkEvent(BundleContext bc, int bundleId, int eventTypeMask, long timeoutInMillis) {
        return FrameworkUtils.waitForFrameworkEvent(bc, bundleId, eventTypeMask, timeoutInMillis, TimeUnit.MILLISECONDS);
    }

    public static FrameworkEvent waitForFrameworkEvent(BundleContext bc, String symbolicName, int eventTypeMask, long timeoutInMillis) {
        return FrameworkUtils.waitForFrameworkEvent(bc, symbolicName, eventTypeMask, timeoutInMillis, TimeUnit.MILLISECONDS);
    }

    public static FrameworkEvent waitForFrameworkEvent(BundleContext bc, String symbolicName, Version version, int eventTypeMask, long timeoutInMillis) {
        return FrameworkUtils.waitForFrameworkEvent(bc, symbolicName, version, eventTypeMask, timeoutInMillis, TimeUnit.MILLISECONDS);
    }

    public static FrameworkEvent waitForFrameworkEvent(BundleContext bc, int bundleId, int eventTypeMask, long timeout, TimeUnit timeUnit) {
        Bundle bundle = BundleUtils.findBundle(bc, bundleId);
        if (bundle == null) {
            throw new IllegalArgumentException("bundleId is invalid");
        }
        return FrameworkUtils.waitForFrameworkEvent(bc, bundle.getSymbolicName(), bundle.getVersion(), eventTypeMask, timeout, timeUnit);
    }

    public static FrameworkEvent waitForFrameworkEvent(BundleContext bc, String symbolicName, int eventTypeMask, long timeout, TimeUnit timeUnit) {
        return FrameworkUtils.waitForFrameworkEvent(bc, symbolicName, null, eventTypeMask, timeout, timeUnit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FrameworkEvent waitForFrameworkEvent(BundleContext bc, String symbolicName, Version version, int eventTypeMask, long timeout, TimeUnit timeUnit) {
        CountDownLatch latch = new CountDownLatch(1);
        long timeoutInMillis = timeUnit.toMillis(timeout);
        FrameworkListenerImpl listener = new FrameworkListenerImpl(symbolicName, version, eventTypeMask, latch);
        bc.addFrameworkListener((FrameworkListener)listener);
        try {
            FrameworkEvent frameworkEvent = FrameworkUtils.waitForFrameworkEvent(listener, timeoutInMillis, latch);
            return frameworkEvent;
        }
        catch (InterruptedException e) {
            FrameworkEvent frameworkEvent = null;
            return frameworkEvent;
        }
        finally {
            bc.removeFrameworkListener((FrameworkListener)listener);
        }
    }

    private static FrameworkEvent waitForFrameworkEvent(FrameworkListenerImpl listener, long timeoutInMillis, CountDownLatch latch) throws InterruptedException {
        if (timeoutInMillis < 0L) {
            throw new IllegalArgumentException("timeout value is negative");
        }
        if (latch.await(timeoutInMillis, TimeUnit.MILLISECONDS)) {
            return listener.getFrameworkEvent();
        }
        return null;
    }

    private static class FrameworkListenerImpl
    implements FrameworkListener {
        private String symbolicName;
        private Version version;
        private int eventTypeMask;
        private CountDownLatch latch;
        private FrameworkEvent event;

        public FrameworkListenerImpl(String symbolicName, Version version, int eventTypeMask, CountDownLatch latch) {
            this.symbolicName = symbolicName;
            this.version = version;
            this.eventTypeMask = eventTypeMask;
            this.latch = latch;
        }

        public void frameworkEvent(FrameworkEvent event) {
            if (this.match(event)) {
                this.event = event;
                this.latch.countDown();
            }
        }

        private boolean match(FrameworkEvent event) {
            Bundle bundle = event.getBundle();
            return bundle.getSymbolicName().equals(this.symbolicName) && (this.version == null || bundle.getVersion().equals((Object)this.version)) && (this.eventTypeMask & event.getType()) != 0;
        }

        public FrameworkEvent getFrameworkEvent() {
            return this.event;
        }
    }
}

