/*
 * Decompiled with CFR 0.152.
 */
package org.knowhowlab.osgi.testing.utils.cmpn;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.knowhowlab.osgi.testing.utils.FilterUtils;
import org.knowhowlab.osgi.testing.utils.ServiceUtils;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.cm.ConfigurationEvent;
import org.osgi.service.cm.ConfigurationListener;
import org.osgi.service.cm.ConfigurationPlugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigurationAdminUtils {
    private ConfigurationAdminUtils() {
    }

    public static Filter createConfigurationFilter(String pid, String factoryPid, String location) {
        if (pid == null && factoryPid == null && location == null) {
            throw new NullPointerException("All filter properties are null");
        }
        ArrayList<Filter> filters = new ArrayList<Filter>(3);
        try {
            if (pid != null) {
                filters.add(FilterUtils.eq("service.pid", pid));
            }
            if (factoryPid != null) {
                filters.add(FilterUtils.eq("service.factoryPid", factoryPid));
            }
            if (location != null) {
                filters.add(FilterUtils.eq("service.bundleLocation", location));
            }
            return FilterUtils.and(filters.toArray(new Filter[filters.size()]));
        }
        catch (InvalidSyntaxException e) {
            throw new IllegalArgumentException("Unable to create filter", e);
        }
    }

    public static Future<Configuration> supplyConfiguration(ConfigurationAdmin configurationAdmin, String pid, Dictionary properties, long delayInMillis) {
        return ConfigurationAdminUtils.supplyConfiguration(configurationAdmin, pid, properties, delayInMillis, TimeUnit.MILLISECONDS);
    }

    public static Future<Configuration> supplyConfiguration(ConfigurationAdmin configurationAdmin, String pid, Map properties, long delayInMillis) {
        return ConfigurationAdminUtils.supplyConfiguration(configurationAdmin, pid, properties, delayInMillis, TimeUnit.MILLISECONDS);
    }

    public static Future<Configuration> supplyConfiguration(ConfigurationAdmin configurationAdmin, String pid, String location, Dictionary properties, long delayInMillis) {
        return ConfigurationAdminUtils.supplyConfiguration(configurationAdmin, pid, location, properties, delayInMillis, TimeUnit.MILLISECONDS);
    }

    public static Future<Configuration> supplyConfiguration(ConfigurationAdmin configurationAdmin, String pid, String location, Map properties, long delayInMillis) {
        return ConfigurationAdminUtils.supplyConfiguration(configurationAdmin, pid, location, properties, delayInMillis, TimeUnit.MILLISECONDS);
    }

    public static Future<Configuration> supplyConfiguration(BundleContext bc, String pid, Dictionary properties, long delayInMillis) {
        return ConfigurationAdminUtils.supplyConfiguration(bc, pid, properties, delayInMillis, TimeUnit.MILLISECONDS);
    }

    public static Future<Configuration> supplyConfiguration(BundleContext bc, String pid, Map properties, long delayInMillis) {
        return ConfigurationAdminUtils.supplyConfiguration(bc, pid, properties, delayInMillis, TimeUnit.MILLISECONDS);
    }

    public static Future<Configuration> supplyConfiguration(BundleContext bc, String pid, String location, Dictionary properties, long delayInMillis) {
        return ConfigurationAdminUtils.supplyConfiguration(bc, pid, location, properties, delayInMillis, TimeUnit.MILLISECONDS);
    }

    public static Future<Configuration> supplyConfiguration(BundleContext bc, String pid, String location, Map properties, long delayInMillis) {
        return ConfigurationAdminUtils.supplyConfiguration(bc, pid, location, properties, delayInMillis, TimeUnit.MILLISECONDS);
    }

    public static Future<Configuration> supplyConfiguration(final ConfigurationAdmin configurationAdmin, final String pid, final Dictionary properties, long delay, TimeUnit timeUnit) {
        if (configurationAdmin == null) {
            throw new NullPointerException("ConfigurationAdmin is null");
        }
        return Executors.newSingleThreadScheduledExecutor().schedule(new Callable<Configuration>(){

            @Override
            public Configuration call() throws Exception {
                Configuration configuration = configurationAdmin.getConfiguration(pid);
                configuration.update(properties);
                return configuration;
            }
        }, delay, timeUnit);
    }

    public static Future<Configuration> supplyConfiguration(ConfigurationAdmin configurationAdmin, String pid, Map properties, long delay, TimeUnit timeUnit) {
        return ConfigurationAdminUtils.supplyConfiguration(configurationAdmin, pid, ConfigurationAdminUtils.toDictionary(properties), delay, timeUnit);
    }

    public static Future<Configuration> supplyConfiguration(final ConfigurationAdmin configurationAdmin, final String pid, final String location, final Dictionary properties, long delay, TimeUnit timeUnit) {
        if (configurationAdmin == null) {
            throw new NullPointerException("ConfigurationAdmin is null");
        }
        return Executors.newSingleThreadScheduledExecutor().schedule(new Callable<Configuration>(){

            @Override
            public Configuration call() throws Exception {
                Configuration configuration = configurationAdmin.getConfiguration(pid, location);
                configuration.update(properties);
                return configuration;
            }
        }, delay, timeUnit);
    }

    public static Future<Configuration> supplyConfiguration(ConfigurationAdmin configurationAdmin, String pid, String location, Map properties, long delay, TimeUnit timeUnit) {
        return ConfigurationAdminUtils.supplyConfiguration(configurationAdmin, pid, location, ConfigurationAdminUtils.toDictionary(properties), delay, timeUnit);
    }

    public static Future<Configuration> supplyConfiguration(BundleContext bc, String pid, Dictionary properties, long delay, TimeUnit timeUnit) {
        return ConfigurationAdminUtils.supplyConfiguration(ServiceUtils.getService(bc, ConfigurationAdmin.class), pid, properties, delay, timeUnit);
    }

    public static Future<Configuration> supplyConfiguration(BundleContext bc, String pid, Map properties, long delay, TimeUnit timeUnit) {
        return ConfigurationAdminUtils.supplyConfiguration(ServiceUtils.getService(bc, ConfigurationAdmin.class), pid, properties, delay, timeUnit);
    }

    public static Future<Configuration> supplyConfiguration(BundleContext bc, String pid, String location, Dictionary properties, long delay, TimeUnit timeUnit) {
        return ConfigurationAdminUtils.supplyConfiguration(ServiceUtils.getService(bc, ConfigurationAdmin.class), pid, location, properties, delay, timeUnit);
    }

    public static Future<Configuration> supplyConfiguration(BundleContext bc, String pid, String location, Map properties, long delay, TimeUnit timeUnit) {
        return ConfigurationAdminUtils.supplyConfiguration(ServiceUtils.getService(bc, ConfigurationAdmin.class), pid, location, properties, delay, timeUnit);
    }

    public static Future<Configuration> supplyFactoryConfiguration(ConfigurationAdmin configurationAdmin, String factoryPid, Dictionary properties, long delayInMillis) {
        return ConfigurationAdminUtils.supplyFactoryConfiguration(configurationAdmin, factoryPid, properties, delayInMillis, TimeUnit.MILLISECONDS);
    }

    public static Future<Configuration> supplyFactoryConfiguration(ConfigurationAdmin configurationAdmin, String factoryPid, Map properties, long delayInMillis) {
        return ConfigurationAdminUtils.supplyFactoryConfiguration(configurationAdmin, factoryPid, properties, delayInMillis, TimeUnit.MILLISECONDS);
    }

    public static Future<Configuration> supplyFactoryConfiguration(ConfigurationAdmin configurationAdmin, String factoryPid, String location, Dictionary properties, long delayInMillis) {
        return ConfigurationAdminUtils.supplyFactoryConfiguration(configurationAdmin, factoryPid, location, properties, delayInMillis, TimeUnit.MILLISECONDS);
    }

    public static Future<Configuration> supplyFactoryConfiguration(ConfigurationAdmin configurationAdmin, String factoryPid, String location, Map properties, long delayInMillis) {
        return ConfigurationAdminUtils.supplyFactoryConfiguration(configurationAdmin, factoryPid, location, properties, delayInMillis, TimeUnit.MILLISECONDS);
    }

    public static Future<Configuration> supplyFactoryConfiguration(BundleContext bc, String factoryPid, Dictionary properties, long delayInMillis) {
        return ConfigurationAdminUtils.supplyFactoryConfiguration(bc, factoryPid, properties, delayInMillis, TimeUnit.MILLISECONDS);
    }

    public static Future<Configuration> supplyFactoryConfiguration(BundleContext bc, String factoryPid, Map properties, long delayInMillis) {
        return ConfigurationAdminUtils.supplyFactoryConfiguration(bc, factoryPid, properties, delayInMillis, TimeUnit.MILLISECONDS);
    }

    public static Future<Configuration> supplyFactoryConfiguration(BundleContext bc, String factoryPid, String location, Dictionary properties, long delayInMillis) {
        return ConfigurationAdminUtils.supplyFactoryConfiguration(bc, factoryPid, location, properties, delayInMillis, TimeUnit.MILLISECONDS);
    }

    public static Future<Configuration> supplyFactoryConfiguration(BundleContext bc, String factoryPid, String location, Map properties, long delayInMillis) {
        return ConfigurationAdminUtils.supplyFactoryConfiguration(bc, factoryPid, location, properties, delayInMillis, TimeUnit.MILLISECONDS);
    }

    public static Future<Configuration> supplyFactoryConfiguration(final ConfigurationAdmin configurationAdmin, final String factoryPid, final Dictionary properties, long delay, TimeUnit timeUnit) {
        if (configurationAdmin == null) {
            throw new NullPointerException("ConfigurationAdmin is null");
        }
        return Executors.newSingleThreadScheduledExecutor().schedule(new Callable<Configuration>(){

            @Override
            public Configuration call() throws Exception {
                Configuration configuration = configurationAdmin.createFactoryConfiguration(factoryPid);
                configuration.update(properties);
                return configuration;
            }
        }, delay, timeUnit);
    }

    public static Future<Configuration> supplyFactoryConfiguration(ConfigurationAdmin configurationAdmin, String factoryPid, Map properties, long delay, TimeUnit timeUnit) {
        return ConfigurationAdminUtils.supplyFactoryConfiguration(configurationAdmin, factoryPid, ConfigurationAdminUtils.toDictionary(properties), delay, timeUnit);
    }

    public static Future<Configuration> supplyFactoryConfiguration(final ConfigurationAdmin configurationAdmin, final String factoryPid, final String location, final Dictionary properties, long delay, TimeUnit timeUnit) {
        if (configurationAdmin == null) {
            throw new NullPointerException("ConfigurationAdmin is null");
        }
        return Executors.newSingleThreadScheduledExecutor().schedule(new Callable<Configuration>(){

            @Override
            public Configuration call() throws Exception {
                Configuration configuration = configurationAdmin.createFactoryConfiguration(factoryPid, location);
                configuration.update(properties);
                return configuration;
            }
        }, delay, timeUnit);
    }

    public static Future<Configuration> supplyFactoryConfiguration(ConfigurationAdmin configurationAdmin, String factoryPid, String location, Map properties, long delay, TimeUnit timeUnit) {
        return ConfigurationAdminUtils.supplyFactoryConfiguration(configurationAdmin, factoryPid, location, ConfigurationAdminUtils.toDictionary(properties), delay, timeUnit);
    }

    public static Future<Configuration> supplyFactoryConfiguration(BundleContext bc, String factoryPid, Dictionary properties, long delay, TimeUnit timeUnit) {
        return ConfigurationAdminUtils.supplyFactoryConfiguration(ServiceUtils.getService(bc, ConfigurationAdmin.class), factoryPid, properties, delay, timeUnit);
    }

    public static Future<Configuration> supplyFactoryConfiguration(BundleContext bc, String factoryPid, Map properties, long delay, TimeUnit timeUnit) {
        return ConfigurationAdminUtils.supplyFactoryConfiguration(ServiceUtils.getService(bc, ConfigurationAdmin.class), factoryPid, properties, delay, timeUnit);
    }

    public static Future<Configuration> supplyFactoryConfiguration(BundleContext bc, String factoryPid, String location, Dictionary properties, long delay, TimeUnit timeUnit) {
        return ConfigurationAdminUtils.supplyFactoryConfiguration(ServiceUtils.getService(bc, ConfigurationAdmin.class), factoryPid, location, properties, delay, timeUnit);
    }

    public static Future<Configuration> supplyFactoryConfiguration(BundleContext bc, String factoryPid, String location, Map properties, long delay, TimeUnit timeUnit) {
        return ConfigurationAdminUtils.supplyFactoryConfiguration(ServiceUtils.getService(bc, ConfigurationAdmin.class), factoryPid, location, properties, delay, timeUnit);
    }

    public static Configuration getConfiguration(ConfigurationAdmin configurationAdmin, String pid) throws IOException {
        Filter filter = ConfigurationAdminUtils.createConfigurationFilter(pid, null, null);
        Configuration[] configurations = ConfigurationAdminUtils.listConfigurations(configurationAdmin, filter);
        if (configurations != null && configurations.length == 1) {
            return configurations[0];
        }
        return null;
    }

    public static Configuration getConfiguration(ConfigurationAdmin configurationAdmin, String pid, String location) throws IOException {
        Filter filter = ConfigurationAdminUtils.createConfigurationFilter(pid, null, location);
        Configuration[] configurations = ConfigurationAdminUtils.listConfigurations(configurationAdmin, filter);
        if (configurations != null && configurations.length == 1) {
            return configurations[0];
        }
        return null;
    }

    public static Configuration getConfiguration(BundleContext bc, String pid) throws IOException {
        return ConfigurationAdminUtils.getConfiguration(ServiceUtils.getService(bc, ConfigurationAdmin.class), pid);
    }

    public static Configuration getConfiguration(BundleContext bc, String pid, String location) throws IOException {
        return ConfigurationAdminUtils.getConfiguration(ServiceUtils.getService(bc, ConfigurationAdmin.class), pid, location);
    }

    public static Configuration[] listConfigurations(ConfigurationAdmin configurationAdmin, Filter filter) throws IOException {
        try {
            return configurationAdmin.listConfigurations(filter.toString());
        }
        catch (InvalidSyntaxException e) {
            throw new IllegalArgumentException("Unable to use filter", e);
        }
    }

    public static Configuration[] listConfigurations(BundleContext bc, Filter filter) throws IOException {
        return ConfigurationAdminUtils.listConfigurations(ServiceUtils.getService(bc, ConfigurationAdmin.class), filter);
    }

    public static ConfigurationEvent waitForConfigurationEvent(BundleContext bc, int eventTypeMask, long timeoutInMillis) {
        return ConfigurationAdminUtils.waitForConfigurationEvent(bc, eventTypeMask, timeoutInMillis, TimeUnit.MILLISECONDS);
    }

    public static ConfigurationEvent waitForConfigurationEvent(BundleContext bc, int eventTypeMask, String pid, String factoryPid, String location, long timeoutInMillis) {
        return ConfigurationAdminUtils.waitForConfigurationEvent(bc, eventTypeMask, pid, factoryPid, location, timeoutInMillis, TimeUnit.MILLISECONDS);
    }

    public static ConfigurationEvent waitForConfigurationEvent(BundleContext bc, int eventTypeMask, long timeout, TimeUnit timeUnit) {
        return ConfigurationAdminUtils.waitForConfigurationEvent(bc, eventTypeMask, null, null, null, timeout, timeUnit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ConfigurationEvent waitForConfigurationEvent(BundleContext bc, int eventTypeMask, String pid, String factoryPid, String location, long timeout, TimeUnit timeUnit) {
        CountDownLatch latch = new CountDownLatch(1);
        long timeoutInMillis = timeUnit.toMillis(timeout);
        ConfigurationListenerImpl listener = new ConfigurationListenerImpl(eventTypeMask, pid, factoryPid, location, latch);
        ServiceRegistration registration = bc.registerService(ConfigurationListener.class.getName(), (Object)listener, null);
        try {
            ConfigurationEvent configurationEvent = ConfigurationAdminUtils.waitForConfigurationEvent(listener, timeoutInMillis, latch);
            return configurationEvent;
        }
        catch (InterruptedException e) {
            ConfigurationEvent configurationEvent = null;
            return configurationEvent;
        }
        finally {
            registration.unregister();
        }
    }

    private static ConfigurationEvent waitForConfigurationEvent(ConfigurationListenerImpl listener, long timeoutInMillis, CountDownLatch latch) throws InterruptedException {
        if (timeoutInMillis < 0L) {
            throw new IllegalArgumentException("timeout value is negative");
        }
        if (latch.await(timeoutInMillis, TimeUnit.MILLISECONDS)) {
            return listener.getConfigurationEvent();
        }
        return null;
    }

    public static Future<String> deleteConfiguration(ConfigurationAdmin configurationAdmin, String pid, long delayInMillis) {
        return ConfigurationAdminUtils.deleteConfiguration(configurationAdmin, pid, delayInMillis, TimeUnit.MILLISECONDS);
    }

    public static Future<String> deleteConfiguration(ConfigurationAdmin configurationAdmin, String pid, String location, long delayInMillis) {
        return ConfigurationAdminUtils.deleteConfiguration(configurationAdmin, pid, location, delayInMillis, TimeUnit.MILLISECONDS);
    }

    public static Future<String[]> deleteConfigurations(ConfigurationAdmin configurationAdmin, Filter filter, long delayInMillis) {
        return ConfigurationAdminUtils.deleteConfigurations(configurationAdmin, filter, delayInMillis, TimeUnit.MILLISECONDS);
    }

    public static Future<String> deleteConfiguration(BundleContext bc, String pid, long delayInMillis) {
        return ConfigurationAdminUtils.deleteConfiguration(bc, pid, delayInMillis, TimeUnit.MILLISECONDS);
    }

    public static Future<String> deleteConfiguration(BundleContext bc, String pid, String location, long delayInMillis) {
        return ConfigurationAdminUtils.deleteConfiguration(bc, pid, location, delayInMillis, TimeUnit.MILLISECONDS);
    }

    public static Future<String[]> deleteConfigurations(BundleContext bc, Filter filter, long delayInMillis) {
        return ConfigurationAdminUtils.deleteConfigurations(bc, filter, delayInMillis, TimeUnit.MILLISECONDS);
    }

    public static Future<String> deleteConfiguration(final ConfigurationAdmin configurationAdmin, final String pid, long delay, TimeUnit timeUnit) {
        if (configurationAdmin == null) {
            throw new NullPointerException("ConfigurationAdmin is null");
        }
        if (pid == null) {
            throw new NullPointerException("service.pid is null");
        }
        return Executors.newSingleThreadScheduledExecutor().schedule(new Callable<String>(){

            @Override
            public String call() throws Exception {
                Configuration configuration = ConfigurationAdminUtils.getConfiguration(configurationAdmin, pid);
                if (configuration != null) {
                    configuration.delete();
                }
                return pid;
            }
        }, delay, timeUnit);
    }

    public static Future<String> deleteConfiguration(final ConfigurationAdmin configurationAdmin, final String pid, final String location, long delay, TimeUnit timeUnit) {
        if (configurationAdmin == null) {
            throw new NullPointerException("ConfigurationAdmin is null");
        }
        if (pid == null) {
            throw new NullPointerException("service.pid is null");
        }
        return Executors.newSingleThreadScheduledExecutor().schedule(new Callable<String>(){

            @Override
            public String call() throws Exception {
                Configuration configuration = ConfigurationAdminUtils.getConfiguration(configurationAdmin, pid, location);
                if (configuration != null) {
                    configuration.delete();
                }
                return pid;
            }
        }, delay, timeUnit);
    }

    public static Future<String[]> deleteConfigurations(final ConfigurationAdmin configurationAdmin, final Filter filter, long delay, TimeUnit timeUnit) {
        if (configurationAdmin == null) {
            throw new NullPointerException("ConfigurationAdmin is null");
        }
        return Executors.newSingleThreadScheduledExecutor().schedule(new Callable<String[]>(){

            @Override
            public String[] call() throws Exception {
                Configuration[] configurations = ConfigurationAdminUtils.listConfigurations(configurationAdmin, filter);
                String[] result = null;
                if (configurations != null) {
                    ArrayList<String> deletedPids = new ArrayList<String>();
                    for (Configuration configuration : configurations) {
                        String pid = configuration.getPid();
                        try {
                            configuration.delete();
                            deletedPids.add(pid);
                        }
                        catch (IOException e) {
                            // empty catch block
                        }
                    }
                    result = deletedPids.toArray(new String[deletedPids.size()]);
                }
                return result;
            }
        }, delay, timeUnit);
    }

    public static Future<String> deleteConfiguration(BundleContext bc, String pid, long delay, TimeUnit timeUnit) {
        return ConfigurationAdminUtils.deleteConfiguration(ServiceUtils.getService(bc, ConfigurationAdmin.class), pid, delay, timeUnit);
    }

    public static Future<String> deleteConfiguration(BundleContext bc, String pid, String location, long delay, TimeUnit timeUnit) {
        return ConfigurationAdminUtils.deleteConfiguration(ServiceUtils.getService(bc, ConfigurationAdmin.class), pid, location, delay, timeUnit);
    }

    public static Future<String[]> deleteConfigurations(BundleContext bc, Filter filter, long delay, TimeUnit timeUnit) {
        return ConfigurationAdminUtils.deleteConfigurations(ServiceUtils.getService(bc, ConfigurationAdmin.class), filter, delay, timeUnit);
    }

    public static ServiceRegistration applyConfigurationPlugin(BundleContext bc, ConfigurationPlugin plugin) {
        return ConfigurationAdminUtils.applyConfigurationPlugin(bc, 0, null, plugin);
    }

    public static ServiceRegistration applyConfigurationPlugin(BundleContext bc, int ranking, String[] targets, ConfigurationPlugin plugin) {
        Hashtable<String, Object> props = new Hashtable<String, Object>();
        ((Dictionary)props).put("service.cmRanking", ranking);
        if (targets != null) {
            ((Dictionary)props).put("cm.target", targets);
        }
        return bc.registerService(ConfigurationPlugin.class.getName(), (Object)plugin, props);
    }

    private static Dictionary toDictionary(Map properties) {
        if (properties == null) {
            return null;
        }
        return new Hashtable(properties);
    }

    private static class ConfigurationListenerImpl
    implements ConfigurationListener {
        private int eventTypeMask;
        private String pid;
        private String factoryPid;
        private String location;
        private CountDownLatch latch;
        private ConfigurationEvent event;

        public ConfigurationListenerImpl(int eventTypeMask, String pid, String factoryPid, String location, CountDownLatch latch) {
            this.eventTypeMask = eventTypeMask;
            this.pid = pid;
            this.factoryPid = factoryPid;
            this.location = location;
            this.latch = latch;
        }

        public void configurationEvent(ConfigurationEvent event) {
            if (this.match(event)) {
                this.event = event;
                this.latch.countDown();
            }
        }

        private boolean match(ConfigurationEvent event) {
            return !(this.pid != null && !event.getPid().equals(this.pid) || this.factoryPid != null && !event.getFactoryPid().equals(this.factoryPid) || this.location != null && !event.getReference().getBundle().getLocation().equals(this.location) || (this.eventTypeMask & event.getType()) == 0);
        }

        public ConfigurationEvent getConfigurationEvent() {
            return this.event;
        }
    }
}

