/*
 * Decompiled with CFR 0.152.
 */
package org.knowhowlab.osgi.testing.utils.cmpn;

import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.knowhowlab.osgi.testing.utils.ServiceUtils;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventAdmin;
import org.osgi.service.event.EventHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EventAdminUtils {
    private EventAdminUtils() {
    }

    public static Future<?> postEvent(EventAdmin eventAdmin, String topic, long delayInMillis) {
        return EventAdminUtils.postEvent(eventAdmin, topic, delayInMillis, TimeUnit.MILLISECONDS);
    }

    public static Future<?> postEvent(EventAdmin eventAdmin, String topic, Dictionary properties, long delayInMillis) {
        return EventAdminUtils.postEvent(eventAdmin, topic, properties, delayInMillis, TimeUnit.MILLISECONDS);
    }

    public static Future<?> postEvent(EventAdmin eventAdmin, String topic, Map properties, long delayInMillis) {
        return EventAdminUtils.postEvent(eventAdmin, topic, properties, delayInMillis, TimeUnit.MILLISECONDS);
    }

    public static Future<?> postEvent(EventAdmin eventAdmin, Event event, long delayInMillis) {
        return EventAdminUtils.postEvent(eventAdmin, event, delayInMillis, TimeUnit.MILLISECONDS);
    }

    public static Future<?> postEvent(BundleContext bc, String topic, long delayInMillis) {
        return EventAdminUtils.postEvent(bc, topic, delayInMillis, TimeUnit.MILLISECONDS);
    }

    public static Future<?> postEvent(BundleContext bc, String topic, Dictionary properties, long delayInMillis) {
        return EventAdminUtils.postEvent(bc, topic, properties, delayInMillis, TimeUnit.MILLISECONDS);
    }

    public static Future<?> postEvent(BundleContext bc, String topic, Map properties, long delayInMillis) {
        return EventAdminUtils.postEvent(bc, topic, properties, delayInMillis, TimeUnit.MILLISECONDS);
    }

    public static Future<?> postEvent(BundleContext bc, Event event, long delayInMillis) {
        return EventAdminUtils.postEvent(bc, event, delayInMillis, TimeUnit.MILLISECONDS);
    }

    public static Future<?> postEvent(EventAdmin eventAdmin, String topic, long delay, TimeUnit timeUnit) {
        return EventAdminUtils.postEvent(eventAdmin, new Event(topic, (Map)null), delay, timeUnit);
    }

    public static Future<?> postEvent(EventAdmin eventAdmin, String topic, Dictionary properties, long delay, TimeUnit timeUnit) {
        return EventAdminUtils.postEvent(eventAdmin, new Event(topic, properties), delay, timeUnit);
    }

    public static Future<?> postEvent(EventAdmin eventAdmin, String topic, Map properties, long delay, TimeUnit timeUnit) {
        return EventAdminUtils.postEvent(eventAdmin, new Event(topic, properties), delay, timeUnit);
    }

    public static Future<?> postEvent(BundleContext bc, String topic, long delay, TimeUnit timeUnit) {
        return EventAdminUtils.postEvent(ServiceUtils.getService(bc, EventAdmin.class), new Event(topic, (Map)null), delay, timeUnit);
    }

    public static Future<?> postEvent(BundleContext bc, String topic, Dictionary properties, long delay, TimeUnit timeUnit) {
        return EventAdminUtils.postEvent(ServiceUtils.getService(bc, EventAdmin.class), new Event(topic, properties), delay, timeUnit);
    }

    public static Future<?> postEvent(BundleContext bc, String topic, Map properties, long delay, TimeUnit timeUnit) {
        return EventAdminUtils.postEvent(ServiceUtils.getService(bc, EventAdmin.class), new Event(topic, properties), delay, timeUnit);
    }

    public static Future<?> postEvent(BundleContext bc, Event event, long delay, TimeUnit timeUnit) {
        return EventAdminUtils.postEvent(ServiceUtils.getService(bc, EventAdmin.class), event, delay, timeUnit);
    }

    public static Future<?> postEvent(final EventAdmin eventAdmin, final Event event, long delay, TimeUnit timeUnit) {
        if (eventAdmin == null) {
            throw new NullPointerException("EventAdmin is null");
        }
        return Executors.newSingleThreadScheduledExecutor().schedule(new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                eventAdmin.postEvent(event);
                return null;
            }
        }, delay, timeUnit);
    }

    public static Future<?> sendEvent(EventAdmin eventAdmin, String topic, long delayInMillis) {
        return EventAdminUtils.sendEvent(eventAdmin, topic, delayInMillis, TimeUnit.MILLISECONDS);
    }

    public static Future<?> sendEvent(EventAdmin eventAdmin, String topic, Dictionary properties, long delayInMillis) {
        return EventAdminUtils.sendEvent(eventAdmin, topic, properties, delayInMillis, TimeUnit.MILLISECONDS);
    }

    public static Future<?> sendEvent(EventAdmin eventAdmin, String topic, Map properties, long delayInMillis) {
        return EventAdminUtils.sendEvent(eventAdmin, topic, properties, delayInMillis, TimeUnit.MILLISECONDS);
    }

    public static Future<?> sendEvent(EventAdmin eventAdmin, Event event, long delayInMillis) {
        return EventAdminUtils.sendEvent(eventAdmin, event, delayInMillis, TimeUnit.MILLISECONDS);
    }

    public static Future<?> sendEvent(BundleContext bc, String topic, long delayInMillis) {
        return EventAdminUtils.sendEvent(bc, topic, delayInMillis, TimeUnit.MILLISECONDS);
    }

    public static Future<?> sendEvent(BundleContext bc, String topic, Dictionary properties, long delayInMillis) {
        return EventAdminUtils.sendEvent(bc, topic, properties, delayInMillis, TimeUnit.MILLISECONDS);
    }

    public static Future<?> sendEvent(BundleContext bc, String topic, Map properties, long delayInMillis) {
        return EventAdminUtils.sendEvent(bc, topic, properties, delayInMillis, TimeUnit.MILLISECONDS);
    }

    public static Future<?> sendEvent(BundleContext bc, Event event, long delayInMillis) {
        return EventAdminUtils.sendEvent(bc, event, delayInMillis, TimeUnit.MILLISECONDS);
    }

    public static Future<?> sendEvent(EventAdmin eventAdmin, String topic, long delay, TimeUnit timeUnit) {
        return EventAdminUtils.sendEvent(eventAdmin, new Event(topic, (Map)null), delay, timeUnit);
    }

    public static Future<?> sendEvent(EventAdmin eventAdmin, String topic, Dictionary properties, long delay, TimeUnit timeUnit) {
        return EventAdminUtils.sendEvent(eventAdmin, new Event(topic, properties), delay, timeUnit);
    }

    public static Future<?> sendEvent(EventAdmin eventAdmin, String topic, Map properties, long delay, TimeUnit timeUnit) {
        return EventAdminUtils.sendEvent(eventAdmin, new Event(topic, properties), delay, timeUnit);
    }

    public static Future<?> sendEvent(BundleContext bc, String topic, long delay, TimeUnit timeUnit) {
        return EventAdminUtils.sendEvent(ServiceUtils.getService(bc, EventAdmin.class), new Event(topic, (Map)null), delay, timeUnit);
    }

    public static Future<?> sendEvent(BundleContext bc, String topic, Dictionary properties, long delay, TimeUnit timeUnit) {
        return EventAdminUtils.sendEvent(ServiceUtils.getService(bc, EventAdmin.class), new Event(topic, properties), delay, timeUnit);
    }

    public static Future<?> sendEvent(BundleContext bc, String topic, Map properties, long delay, TimeUnit timeUnit) {
        return EventAdminUtils.sendEvent(ServiceUtils.getService(bc, EventAdmin.class), new Event(topic, properties), delay, timeUnit);
    }

    public static Future<?> sendEvent(BundleContext bc, Event event, long delay, TimeUnit timeUnit) {
        return EventAdminUtils.sendEvent(ServiceUtils.getService(bc, EventAdmin.class), event, delay, timeUnit);
    }

    public static Future<?> sendEvent(final EventAdmin eventAdmin, final Event event, long delay, TimeUnit timeUnit) {
        if (eventAdmin == null) {
            throw new NullPointerException("EventAdmin is null");
        }
        return Executors.newSingleThreadScheduledExecutor().schedule(new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                eventAdmin.sendEvent(event);
                return null;
            }
        }, delay, timeUnit);
    }

    public static Event waitForEvent(BundleContext bc, String topic, long timeoutInMillis) {
        return EventAdminUtils.waitForEvent(bc, topic, timeoutInMillis, TimeUnit.MILLISECONDS);
    }

    public static Event waitForEvent(BundleContext bc, String topic, Filter filter, long timeoutInMillis) {
        return EventAdminUtils.waitForEvent(bc, topic, filter, timeoutInMillis, TimeUnit.MILLISECONDS);
    }

    public static Event waitForEvent(BundleContext bc, String[] topics, long timeoutInMillis) {
        return EventAdminUtils.waitForEvent(bc, topics, timeoutInMillis, TimeUnit.MILLISECONDS);
    }

    public static Event waitForEvent(BundleContext bc, String[] topics, Filter filter, long timeoutInMillis) {
        return EventAdminUtils.waitForEvent(bc, topics, filter, timeoutInMillis, TimeUnit.MILLISECONDS);
    }

    public static Event waitForEvent(BundleContext bc, String topic, long timeout, TimeUnit timeUnit) {
        return EventAdminUtils.waitForEvent(bc, topic, null, timeout, timeUnit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Event waitForEvent(BundleContext bc, String topic, Filter filter, long timeout, TimeUnit timeUnit) {
        CountDownLatch latch = new CountDownLatch(1);
        long timeoutInMillis = timeUnit.toMillis(timeout);
        EventHandlerImpl handler = new EventHandlerImpl(latch);
        Hashtable<String, String> props = new Hashtable<String, String>();
        if (topic != null) {
            ((Dictionary)props).put("event.topics", topic);
        }
        if (filter != null) {
            ((Dictionary)props).put("event.filter", filter.toString());
        }
        ServiceRegistration registration = bc.registerService(EventHandler.class.getName(), (Object)handler, props);
        try {
            Event event = EventAdminUtils.waitForEvent(handler, timeoutInMillis, latch);
            return event;
        }
        catch (InterruptedException e) {
            Event event = null;
            return event;
        }
        finally {
            registration.unregister();
        }
    }

    public static Event waitForEvent(BundleContext bc, String[] topics, long timeout, TimeUnit timeUnit) {
        return EventAdminUtils.waitForEvent(bc, topics, null, timeout, timeUnit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Event waitForEvent(BundleContext bc, String[] topics, Filter filter, long timeout, TimeUnit timeUnit) {
        CountDownLatch latch = new CountDownLatch(1);
        long timeoutInMillis = timeUnit.toMillis(timeout);
        EventHandlerImpl handler = new EventHandlerImpl(latch);
        Hashtable<String, Object> props = new Hashtable<String, Object>();
        if (topics != null) {
            ((Dictionary)props).put("event.topics", topics);
        }
        if (filter != null) {
            ((Dictionary)props).put("event.filter", filter.toString());
        }
        ServiceRegistration registration = bc.registerService(EventHandler.class.getName(), (Object)handler, props);
        try {
            Event event = EventAdminUtils.waitForEvent(handler, timeoutInMillis, latch);
            return event;
        }
        catch (InterruptedException e) {
            Event event = null;
            return event;
        }
        finally {
            registration.unregister();
        }
    }

    private static Event waitForEvent(EventHandlerImpl handler, long timeoutInMillis, CountDownLatch latch) throws InterruptedException {
        if (timeoutInMillis < 0L) {
            throw new IllegalArgumentException("timeout value is negative");
        }
        if (latch.await(timeoutInMillis, TimeUnit.MILLISECONDS)) {
            return handler.getEvent();
        }
        return null;
    }

    private static class EventHandlerImpl
    implements EventHandler {
        private CountDownLatch latch;
        private Event event;

        public EventHandlerImpl(CountDownLatch latch) {
            this.latch = latch;
        }

        public void handleEvent(Event event) {
            this.event = event;
            this.latch.countDown();
        }

        public Event getEvent() {
            return this.event;
        }
    }
}

